/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchAgrmtPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchAgrmtPartner extends VdmEntity<SchAgrmtPartner>
{

    /**
     * Selector for all available fields of SchAgrmtPartner.
     *
     */
    public final static SchAgrmtPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> SCHEDULING_AGREEMENT =
        new SchAgrmtPartnerField<String>("SchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "SchedulingAgreementItem" )
    @JsonProperty( "SchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementItem" )
    private String schedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> SCHEDULING_AGREEMENT_ITEM =
        new SchAgrmtPartnerField<String>("SchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @return Purchasing Organization
     */
    @Key
    @SerializedName( "PurchasingOrganization" )
    @JsonProperty( "PurchasingOrganization" )
    @Nullable
    @ODataField( odataName = "PurchasingOrganization" )
    private String purchasingOrganization;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingOrganization</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> PURCHASING_ORGANIZATION =
        new SchAgrmtPartnerField<String>("PurchasingOrganization");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @return Supplier Subrange
     */
    @Key
    @SerializedName( "SupplierSubrange" )
    @JsonProperty( "SupplierSubrange" )
    @Nullable
    @ODataField( odataName = "SupplierSubrange" )
    private String supplierSubrange;
    /**
     * Use with available fluent helpers to apply the <b>SupplierSubrange</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> SUPPLIER_SUBRANGE =
        new SchAgrmtPartnerField<String>("SupplierSubrange");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> PLANT = new SchAgrmtPartnerField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> PARTNER_FUNCTION =
        new SchAgrmtPartnerField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @return Partner counter
     */
    @Key
    @SerializedName( "PartnerCounter" )
    @JsonProperty( "PartnerCounter" )
    @Nullable
    @ODataField( odataName = "PartnerCounter" )
    private String partnerCounter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCounter</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> PARTNER_COUNTER =
        new SchAgrmtPartnerField<String>("PartnerCounter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<String> SUPPLIER = new SchAgrmtPartnerField<String>("Supplier");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DefaultPartner</b>
     * </p>
     *
     * @return Default Partner
     */
    @SerializedName( "DefaultPartner" )
    @JsonProperty( "DefaultPartner" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DefaultPartner" )
    private Boolean defaultPartner;
    /**
     * Use with available fluent helpers to apply the <b>DefaultPartner</b> field to query operations.
     *
     */
    public final static SchAgrmtPartnerField<Boolean> DEFAULT_PARTNER =
        new SchAgrmtPartnerField<Boolean>("DefaultPartner");

    @Nonnull
    @Override
    public Class<SchAgrmtPartner> getType()
    {
        return SchAgrmtPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     */
    public void setSchedulingAgreementItem( @Nullable final String schedulingAgreementItem )
    {
        rememberChangedField("SchedulingAgreementItem", this.schedulingAgreementItem);
        this.schedulingAgreementItem = schedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     *
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     *
     * @param supplierSubrange
     *            Supplier Subrange
     */
    public void setSupplierSubrange( @Nullable final String supplierSubrange )
    {
        rememberChangedField("SupplierSubrange", this.supplierSubrange);
        this.supplierSubrange = supplierSubrange;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCounter</b>
     * </p>
     *
     * @param partnerCounter
     *            Partner counter
     */
    public void setPartnerCounter( @Nullable final String partnerCounter )
    {
        rememberChangedField("PartnerCounter", this.partnerCounter);
        this.partnerCounter = partnerCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DefaultPartner</b>
     * </p>
     *
     * @param defaultPartner
     *            Default Partner
     */
    public void setDefaultPartner( @Nullable final Boolean defaultPartner )
    {
        rememberChangedField("DefaultPartner", this.defaultPartner);
        this.defaultPartner = defaultPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchAgrmtPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        result.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        result.put("PurchasingOrganization", getPurchasingOrganization());
        result.put("SupplierSubrange", getSupplierSubrange());
        result.put("Plant", getPlant());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("PartnerCounter", getPartnerCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("SupplierSubrange", getSupplierSubrange());
        values.put("Plant", getPlant());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("PartnerCounter", getPartnerCounter());
        values.put("Supplier", getSupplier());
        values.put("DefaultPartner", getDefaultPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementItem") ) {
                final Object value = values.remove("SchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSchedulingAgreementItem())) ) {
                    setSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((String) value));
                }
            }
            if( values.containsKey("SupplierSubrange") ) {
                final Object value = values.remove("SupplierSubrange");
                if( (value == null) || (!value.equals(getSupplierSubrange())) ) {
                    setSupplierSubrange(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("PartnerCounter") ) {
                final Object value = values.remove("PartnerCounter");
                if( (value == null) || (!value.equals(getPartnerCounter())) ) {
                    setPartnerCounter(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("DefaultPartner") ) {
                final Object value = values.remove("DefaultPartner");
                if( (value == null) || (!value.equals(getDefaultPartner())) ) {
                    setDefaultPartner(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SchAgrmtPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchAgrmtPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchAgrmtPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchAgrmtPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

}
