/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtSchLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtSchLineLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtSchLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Schedule Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchAgrmtSchLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchAgrmtSchLine extends VdmEntity<SchAgrmtSchLine>
{

    /**
     * Selector for all available fields of SchAgrmtSchLine.
     *
     */
    public final static SchAgrmtSchLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> SCHEDULING_AGREEMENT =
        new SchAgrmtSchLineField<String>("SchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "SchedulingAgreementItem" )
    @JsonProperty( "SchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementItem" )
    private String schedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> SCHEDULING_AGREEMENT_ITEM =
        new SchAgrmtSchLineField<String>("SchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Delivery Schedule Line Counter
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> SCHEDULE_LINE = new SchAgrmtSchLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @return Category of delivery date
     */
    @SerializedName( "DelivDateCategory" )
    @JsonProperty( "DelivDateCategory" )
    @Nullable
    @ODataField( odataName = "DelivDateCategory" )
    private String delivDateCategory;
    /**
     * Use with available fluent helpers to apply the <b>DelivDateCategory</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> DELIV_DATE_CATEGORY =
        new SchAgrmtSchLineField<String>("DelivDateCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @return Item Delivery Date
     */
    @SerializedName( "ScheduleLineDeliveryDate" )
    @JsonProperty( "ScheduleLineDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduleLineDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryDate</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<LocalDateTime> SCHEDULE_LINE_DELIVERY_DATE =
        new SchAgrmtSchLineField<LocalDateTime>("ScheduleLineDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @return Statistics-Relevant Delivery Date
     */
    @SerializedName( "SchedLineStscDeliveryDate" )
    @JsonProperty( "SchedLineStscDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedLineStscDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedLineStscDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedLineStscDeliveryDate</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<LocalDateTime> SCHED_LINE_STSC_DELIVERY_DATE =
        new SchAgrmtSchLineField<LocalDateTime>("SchedLineStscDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryTime</b>
     * </p>
     *
     * @return Delivery Date Time-Spot
     */
    @SerializedName( "ScheduleLineDeliveryTime" )
    @JsonProperty( "ScheduleLineDeliveryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ScheduleLineDeliveryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime scheduleLineDeliveryTime;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineDeliveryTime</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<LocalTime> SCHEDULE_LINE_DELIVERY_TIME =
        new SchAgrmtSchLineField<LocalTime>("ScheduleLineDeliveryTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Purchase Order Unit of Measure
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> ORDER_QUANTITY_UNIT =
        new SchAgrmtSchLineField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Scheduled Quantity
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new SchAgrmtSchLineField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @return Purchase Requisition Number
     */
    @SerializedName( "PurchaseRequisition" )
    @JsonProperty( "PurchaseRequisition" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisition" )
    private String purchaseRequisition;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisition</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> PURCHASE_REQUISITION =
        new SchAgrmtSchLineField<String>("PurchaseRequisition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @return Item number of purchase requisition
     */
    @SerializedName( "PurchaseRequisitionItem" )
    @JsonProperty( "PurchaseRequisitionItem" )
    @Nullable
    @ODataField( odataName = "PurchaseRequisitionItem" )
    private String purchaseRequisitionItem;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseRequisitionItem</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> PURCHASE_REQUISITION_ITEM =
        new SchAgrmtSchLineField<String>("PurchaseRequisitionItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RoughGoodsReceiptQty</b>
     * </p>
     *
     * @return Quantity of Goods Received
     */
    @SerializedName( "RoughGoodsReceiptQty" )
    @JsonProperty( "RoughGoodsReceiptQty" )
    @Nullable
    @ODataField( odataName = "RoughGoodsReceiptQty" )
    private BigDecimal roughGoodsReceiptQty;
    /**
     * Use with available fluent helpers to apply the <b>RoughGoodsReceiptQty</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<BigDecimal> ROUGH_GOODS_RECEIPT_QTY =
        new SchAgrmtSchLineField<BigDecimal>("RoughGoodsReceiptQty");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineIsFixed</b>
     * </p>
     *
     * @return Schedule Line is "Fixed"
     */
    @SerializedName( "ScheduleLineIsFixed" )
    @JsonProperty( "ScheduleLineIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ScheduleLineIsFixed" )
    private Boolean scheduleLineIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineIsFixed</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<Boolean> SCHEDULE_LINE_IS_FIXED =
        new SchAgrmtSchLineField<Boolean>("ScheduleLineIsFixed");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoOfRemindersOfScheduleLine</b>
     * </p>
     *
     * @return No. of Reminders/Expediters for Schedule Line
     */
    @SerializedName( "NoOfRemindersOfScheduleLine" )
    @JsonProperty( "NoOfRemindersOfScheduleLine" )
    @Nullable
    @ODataField( odataName = "NoOfRemindersOfScheduleLine" )
    private BigDecimal noOfRemindersOfScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>NoOfRemindersOfScheduleLine</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<BigDecimal> NO_OF_REMINDERS_OF_SCHEDULE_LINE =
        new SchAgrmtSchLineField<BigDecimal>("NoOfRemindersOfScheduleLine");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrevDelivQtyOfScheduleLine</b>
     * </p>
     *
     * @return Previous Quantity (Delivery Schedule Lines)
     */
    @SerializedName( "PrevDelivQtyOfScheduleLine" )
    @JsonProperty( "PrevDelivQtyOfScheduleLine" )
    @Nullable
    @ODataField( odataName = "PrevDelivQtyOfScheduleLine" )
    private BigDecimal prevDelivQtyOfScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>PrevDelivQtyOfScheduleLine</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<BigDecimal> PREV_DELIV_QTY_OF_SCHEDULE_LINE =
        new SchAgrmtSchLineField<BigDecimal>("PrevDelivQtyOfScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfCreation</b>
     * </p>
     *
     * @return Creation indicator (purchase requisition/schedule lines)
     */
    @SerializedName( "SourceOfCreation" )
    @JsonProperty( "SourceOfCreation" )
    @Nullable
    @ODataField( odataName = "SourceOfCreation" )
    private String sourceOfCreation;
    /**
     * Use with available fluent helpers to apply the <b>SourceOfCreation</b> field to query operations.
     *
     */
    public final static SchAgrmtSchLineField<String> SOURCE_OF_CREATION =
        new SchAgrmtSchLineField<String>("SourceOfCreation");
    /**
     * Navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> for <b>SchAgrmtSchLine</b> to multiple
     * <b>SchedgAgrmtSubcontrgComp</b>.
     *
     */
    @SerializedName( "to_SchedgAgrmtSubcontrgCompTP" )
    @JsonProperty( "to_SchedgAgrmtSubcontrgCompTP" )
    @ODataField( odataName = "to_SchedgAgrmtSubcontrgCompTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SchedgAgrmtSubcontrgComp> toSchedgAgrmtSubcontrgCompTP;
    /**
     * Use with available fluent helpers to apply the <b>to_SchedgAgrmtSubcontrgCompTP</b> navigation property to query
     * operations.
     *
     */
    public final static SchAgrmtSchLineLink<SchedgAgrmtSubcontrgComp> TO_SCHEDG_AGRMT_SUBCONTRG_COMP_TP =
        new SchAgrmtSchLineLink<SchedgAgrmtSubcontrgComp>("to_SchedgAgrmtSubcontrgCompTP");

    @Nonnull
    @Override
    public Class<SchAgrmtSchLine> getType()
    {
        return SchAgrmtSchLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     */
    public void setSchedulingAgreementItem( @Nullable final String schedulingAgreementItem )
    {
        rememberChangedField("SchedulingAgreementItem", this.schedulingAgreementItem);
        this.schedulingAgreementItem = schedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DelivDateCategory</b>
     * </p>
     *
     * @param delivDateCategory
     *            Category of delivery date
     */
    public void setDelivDateCategory( @Nullable final String delivDateCategory )
    {
        rememberChangedField("DelivDateCategory", this.delivDateCategory);
        this.delivDateCategory = delivDateCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryDate</b>
     * </p>
     *
     * @param scheduleLineDeliveryDate
     *            Item Delivery Date
     */
    public void setScheduleLineDeliveryDate( @Nullable final LocalDateTime scheduleLineDeliveryDate )
    {
        rememberChangedField("ScheduleLineDeliveryDate", this.scheduleLineDeliveryDate);
        this.scheduleLineDeliveryDate = scheduleLineDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedLineStscDeliveryDate</b>
     * </p>
     *
     * @param schedLineStscDeliveryDate
     *            Statistics-Relevant Delivery Date
     */
    public void setSchedLineStscDeliveryDate( @Nullable final LocalDateTime schedLineStscDeliveryDate )
    {
        rememberChangedField("SchedLineStscDeliveryDate", this.schedLineStscDeliveryDate);
        this.schedLineStscDeliveryDate = schedLineStscDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineDeliveryTime</b>
     * </p>
     *
     * @param scheduleLineDeliveryTime
     *            Delivery Date Time-Spot
     */
    public void setScheduleLineDeliveryTime( @Nullable final LocalTime scheduleLineDeliveryTime )
    {
        rememberChangedField("ScheduleLineDeliveryTime", this.scheduleLineDeliveryTime);
        this.scheduleLineDeliveryTime = scheduleLineDeliveryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Purchase Order Unit of Measure
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Scheduled Quantity
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisition</b>
     * </p>
     *
     * @param purchaseRequisition
     *            Purchase Requisition Number
     */
    public void setPurchaseRequisition( @Nullable final String purchaseRequisition )
    {
        rememberChangedField("PurchaseRequisition", this.purchaseRequisition);
        this.purchaseRequisition = purchaseRequisition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseRequisitionItem</b>
     * </p>
     *
     * @param purchaseRequisitionItem
     *            Item number of purchase requisition
     */
    public void setPurchaseRequisitionItem( @Nullable final String purchaseRequisitionItem )
    {
        rememberChangedField("PurchaseRequisitionItem", this.purchaseRequisitionItem);
        this.purchaseRequisitionItem = purchaseRequisitionItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RoughGoodsReceiptQty</b>
     * </p>
     *
     * @param roughGoodsReceiptQty
     *            Quantity of Goods Received
     */
    public void setRoughGoodsReceiptQty( @Nullable final BigDecimal roughGoodsReceiptQty )
    {
        rememberChangedField("RoughGoodsReceiptQty", this.roughGoodsReceiptQty);
        this.roughGoodsReceiptQty = roughGoodsReceiptQty;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineIsFixed</b>
     * </p>
     *
     * @param scheduleLineIsFixed
     *            Schedule Line is "Fixed"
     */
    public void setScheduleLineIsFixed( @Nullable final Boolean scheduleLineIsFixed )
    {
        rememberChangedField("ScheduleLineIsFixed", this.scheduleLineIsFixed);
        this.scheduleLineIsFixed = scheduleLineIsFixed;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>NoOfRemindersOfScheduleLine</b>
     * </p>
     *
     * @param noOfRemindersOfScheduleLine
     *            No. of Reminders/Expediters for Schedule Line
     */
    public void setNoOfRemindersOfScheduleLine( @Nullable final BigDecimal noOfRemindersOfScheduleLine )
    {
        rememberChangedField("NoOfRemindersOfScheduleLine", this.noOfRemindersOfScheduleLine);
        this.noOfRemindersOfScheduleLine = noOfRemindersOfScheduleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrevDelivQtyOfScheduleLine</b>
     * </p>
     *
     * @param prevDelivQtyOfScheduleLine
     *            Previous Quantity (Delivery Schedule Lines)
     */
    public void setPrevDelivQtyOfScheduleLine( @Nullable final BigDecimal prevDelivQtyOfScheduleLine )
    {
        rememberChangedField("PrevDelivQtyOfScheduleLine", this.prevDelivQtyOfScheduleLine);
        this.prevDelivQtyOfScheduleLine = prevDelivQtyOfScheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SourceOfCreation</b>
     * </p>
     *
     * @param sourceOfCreation
     *            Creation indicator (purchase requisition/schedule lines)
     */
    public void setSourceOfCreation( @Nullable final String sourceOfCreation )
    {
        rememberChangedField("SourceOfCreation", this.sourceOfCreation);
        this.sourceOfCreation = sourceOfCreation;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchAgrmtSchLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        result.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("DelivDateCategory", getDelivDateCategory());
        values.put("ScheduleLineDeliveryDate", getScheduleLineDeliveryDate());
        values.put("SchedLineStscDeliveryDate", getSchedLineStscDeliveryDate());
        values.put("ScheduleLineDeliveryTime", getScheduleLineDeliveryTime());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("PurchaseRequisition", getPurchaseRequisition());
        values.put("PurchaseRequisitionItem", getPurchaseRequisitionItem());
        values.put("RoughGoodsReceiptQty", getRoughGoodsReceiptQty());
        values.put("ScheduleLineIsFixed", getScheduleLineIsFixed());
        values.put("NoOfRemindersOfScheduleLine", getNoOfRemindersOfScheduleLine());
        values.put("PrevDelivQtyOfScheduleLine", getPrevDelivQtyOfScheduleLine());
        values.put("SourceOfCreation", getSourceOfCreation());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementItem") ) {
                final Object value = values.remove("SchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSchedulingAgreementItem())) ) {
                    setSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("DelivDateCategory") ) {
                final Object value = values.remove("DelivDateCategory");
                if( (value == null) || (!value.equals(getDelivDateCategory())) ) {
                    setDelivDateCategory(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryDate") ) {
                final Object value = values.remove("ScheduleLineDeliveryDate");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryDate())) ) {
                    setScheduleLineDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedLineStscDeliveryDate") ) {
                final Object value = values.remove("SchedLineStscDeliveryDate");
                if( (value == null) || (!value.equals(getSchedLineStscDeliveryDate())) ) {
                    setSchedLineStscDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduleLineDeliveryTime") ) {
                final Object value = values.remove("ScheduleLineDeliveryTime");
                if( (value == null) || (!value.equals(getScheduleLineDeliveryTime())) ) {
                    setScheduleLineDeliveryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseRequisition") ) {
                final Object value = values.remove("PurchaseRequisition");
                if( (value == null) || (!value.equals(getPurchaseRequisition())) ) {
                    setPurchaseRequisition(((String) value));
                }
            }
            if( values.containsKey("PurchaseRequisitionItem") ) {
                final Object value = values.remove("PurchaseRequisitionItem");
                if( (value == null) || (!value.equals(getPurchaseRequisitionItem())) ) {
                    setPurchaseRequisitionItem(((String) value));
                }
            }
            if( values.containsKey("RoughGoodsReceiptQty") ) {
                final Object value = values.remove("RoughGoodsReceiptQty");
                if( (value == null) || (!value.equals(getRoughGoodsReceiptQty())) ) {
                    setRoughGoodsReceiptQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ScheduleLineIsFixed") ) {
                final Object value = values.remove("ScheduleLineIsFixed");
                if( (value == null) || (!value.equals(getScheduleLineIsFixed())) ) {
                    setScheduleLineIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("NoOfRemindersOfScheduleLine") ) {
                final Object value = values.remove("NoOfRemindersOfScheduleLine");
                if( (value == null) || (!value.equals(getNoOfRemindersOfScheduleLine())) ) {
                    setNoOfRemindersOfScheduleLine(((BigDecimal) value));
                }
            }
            if( values.containsKey("PrevDelivQtyOfScheduleLine") ) {
                final Object value = values.remove("PrevDelivQtyOfScheduleLine");
                if( (value == null) || (!value.equals(getPrevDelivQtyOfScheduleLine())) ) {
                    setPrevDelivQtyOfScheduleLine(((BigDecimal) value));
                }
            }
            if( values.containsKey("SourceOfCreation") ) {
                final Object value = values.remove("SourceOfCreation");
                if( (value == null) || (!value.equals(getSourceOfCreation())) ) {
                    setSourceOfCreation(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SchedgAgrmtSubcontrgCompTP") ) {
                final Object value = (values).remove("to_SchedgAgrmtSubcontrgCompTP");
                if( value instanceof Iterable ) {
                    if( toSchedgAgrmtSubcontrgCompTP == null ) {
                        toSchedgAgrmtSubcontrgCompTP = Lists.newArrayList();
                    } else {
                        toSchedgAgrmtSubcontrgCompTP = Lists.newArrayList(toSchedgAgrmtSubcontrgCompTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SchedgAgrmtSubcontrgComp entity;
                        if( toSchedgAgrmtSubcontrgCompTP.size() > i ) {
                            entity = toSchedgAgrmtSubcontrgCompTP.get(i);
                        } else {
                            entity = new SchedgAgrmtSubcontrgComp();
                            toSchedgAgrmtSubcontrgCompTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SchAgrmtSchLineField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchAgrmtSchLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchAgrmtSchLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchAgrmtSchLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSchedgAgrmtSubcontrgCompTP != null ) {
            (values).put("to_SchedgAgrmtSubcontrgCompTP", toSchedgAgrmtSubcontrgCompTP);
        }
        return values;
    }

    /**
     * Fetches the <b>SchedgAgrmtSubcontrgComp</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SchedgAgrmtSubcontrgComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtSubcontrgComp> fetchSchedgAgrmtSubcontrgCompTP()
    {
        return fetchFieldAsList("to_SchedgAgrmtSubcontrgCompTP", SchedgAgrmtSubcontrgComp.class);
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtSubcontrgComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> of a queried <b>SchAgrmtSchLine</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SchedgAgrmtSubcontrgComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SchedgAgrmtSubcontrgComp> getSchedgAgrmtSubcontrgCompTPOrFetch()
    {
        if( toSchedgAgrmtSubcontrgCompTP == null ) {
            toSchedgAgrmtSubcontrgCompTP = fetchSchedgAgrmtSubcontrgCompTP();
        }
        return toSchedgAgrmtSubcontrgCompTP;
    }

    /**
     * Retrieval of associated <b>SchedgAgrmtSubcontrgComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b>.
     * <p>
     * If the navigation property for an entity <b>SchAgrmtSchLine</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> is already loaded, the
     *         result will contain the <b>SchedgAgrmtSubcontrgComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SchedgAgrmtSubcontrgComp>> getSchedgAgrmtSubcontrgCompTPIfPresent()
    {
        return Option.of(toSchedgAgrmtSubcontrgCompTP);
    }

    /**
     * Overwrites the list of associated <b>SchedgAgrmtSubcontrgComp</b> entities for the loaded navigation property
     * <b>to_SchedgAgrmtSubcontrgCompTP</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> of a queried <b>SchAgrmtSchLine</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SchedgAgrmtSubcontrgComp</b> entities.
     */
    public void setSchedgAgrmtSubcontrgCompTP( @Nonnull final List<SchedgAgrmtSubcontrgComp> value )
    {
        if( toSchedgAgrmtSubcontrgCompTP == null ) {
            toSchedgAgrmtSubcontrgCompTP = Lists.newArrayList();
        }
        toSchedgAgrmtSubcontrgCompTP.clear();
        toSchedgAgrmtSubcontrgCompTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SchedgAgrmtSubcontrgComp</b> entities. This corresponds to the OData
     * navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b>.
     * <p>
     * If the navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> of a queried <b>SchAgrmtSchLine</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SchedgAgrmtSubcontrgComp</b> entities.
     */
    public void addSchedgAgrmtSubcontrgCompTP( SchedgAgrmtSubcontrgComp... entity )
    {
        if( toSchedgAgrmtSubcontrgCompTP == null ) {
            toSchedgAgrmtSubcontrgCompTP = Lists.newArrayList();
        }
        toSchedgAgrmtSubcontrgCompTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SchAgrmtSchLine instances.
     *
     */
    public final static class SchAgrmtSchLineBuilder
    {

        private List<SchedgAgrmtSubcontrgComp> toSchedgAgrmtSubcontrgCompTP = Lists.newArrayList();

        private SchAgrmtSchLine.SchAgrmtSchLineBuilder toSchedgAgrmtSubcontrgCompTP(
            final List<SchedgAgrmtSubcontrgComp> value )
        {
            toSchedgAgrmtSubcontrgCompTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SchedgAgrmtSubcontrgCompTP</b> for <b>SchAgrmtSchLine</b> to multiple
         * <b>SchedgAgrmtSubcontrgComp</b>.
         *
         * @param value
         *            The SchedgAgrmtSubcontrgComps to build this SchAgrmtSchLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SchAgrmtSchLine.SchAgrmtSchLineBuilder schedgAgrmtSubcontrgCompTP( SchedgAgrmtSubcontrgComp... value )
        {
            return toSchedgAgrmtSubcontrgCompTP(Lists.newArrayList(value));
        }

    }

}
