/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtDeliveryAddressField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchedgAgrmtDeliveryAddressSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Delivery Address
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchedgAgrmtDeliveryAddressType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchedgAgrmtDeliveryAddress extends VdmEntity<SchedgAgrmtDeliveryAddress>
{

    /**
     * Selector for all available fields of SchedgAgrmtDeliveryAddress.
     *
     */
    public final static SchedgAgrmtDeliveryAddressSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> SCHEDULING_AGREEMENT =
        new SchedgAgrmtDeliveryAddressField<String>("SchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @return Item Number of Purchasing Document
     */
    @Key
    @SerializedName( "SchedulingAgreementItem" )
    @JsonProperty( "SchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementItem" )
    private String schedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> SCHEDULING_AGREEMENT_ITEM =
        new SchedgAgrmtDeliveryAddressField<String>("SchedulingAgreementItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @return Manual address number in purchasing document item
     */
    @SerializedName( "DeliveryAddressID" )
    @JsonProperty( "DeliveryAddressID" )
    @Nullable
    @ODataField( odataName = "DeliveryAddressID" )
    private String deliveryAddressID;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryAddressID</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> DELIVERY_ADDRESS_ID =
        new SchedgAgrmtDeliveryAddressField<String>("DeliveryAddressID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     *
     * @return Purchase Requisition Address Type
     */
    @SerializedName( "AddressType" )
    @JsonProperty( "AddressType" )
    @Nullable
    @ODataField( odataName = "AddressType" )
    private String addressType;
    /**
     * Use with available fluent helpers to apply the <b>AddressType</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> ADDRESS_TYPE =
        new SchedgAgrmtDeliveryAddressField<String>("AddressType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDeliveryAddressType</b>
     * </p>
     *
     * @return Purchasing Delivery Address Type
     */
    @SerializedName( "PurchasingDeliveryAddressType" )
    @JsonProperty( "PurchasingDeliveryAddressType" )
    @Nullable
    @ODataField( odataName = "PurchasingDeliveryAddressType" )
    private String purchasingDeliveryAddressType;
    /**
     * Use with available fluent helpers to apply the <b>PurchasingDeliveryAddressType</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> PURCHASING_DELIVERY_ADDRESS_TYPE =
        new SchedgAgrmtDeliveryAddressField<String>("PurchasingDeliveryAddressType");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @return Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    @SerializedName( "FullName" )
    @JsonProperty( "FullName" )
    @Nullable
    @ODataField( odataName = "FullName" )
    private String fullName;
    /**
     * Use with available fluent helpers to apply the <b>FullName</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> FULL_NAME =
        new SchedgAgrmtDeliveryAddressField<String>("FullName");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> STREET_NAME =
        new SchedgAgrmtDeliveryAddressField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> HOUSE_NUMBER =
        new SchedgAgrmtDeliveryAddressField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> POSTAL_CODE =
        new SchedgAgrmtDeliveryAddressField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> CITY_NAME =
        new SchedgAgrmtDeliveryAddressField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobileNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "MobileNumber" )
    @JsonProperty( "MobileNumber" )
    @Nullable
    @ODataField( odataName = "MobileNumber" )
    private String mobileNumber;
    /**
     * Use with available fluent helpers to apply the <b>MobileNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> MOBILE_NUMBER =
        new SchedgAgrmtDeliveryAddressField<String>("MobileNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> REGION =
        new SchedgAgrmtDeliveryAddressField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> COUNTRY =
        new SchedgAgrmtDeliveryAddressField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> EMAIL_ADDRESS =
        new SchedgAgrmtDeliveryAddressField<String>("EmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> PLANT =
        new SchedgAgrmtDeliveryAddressField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> CORRESPONDENCE_LANGUAGE =
        new SchedgAgrmtDeliveryAddressField<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> PHONE_NUMBER =
        new SchedgAgrmtDeliveryAddressField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @return First Fax No.: Area Code + Number
     */
    @SerializedName( "FaxNumber" )
    @JsonProperty( "FaxNumber" )
    @Nullable
    @ODataField( odataName = "FaxNumber" )
    private String faxNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> FAX_NUMBER =
        new SchedgAgrmtDeliveryAddressField<String>("FaxNumber");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @return First Fax No.: Area Code + Number
     */
    @SerializedName( "AddressFaxNumber" )
    @JsonProperty( "AddressFaxNumber" )
    @Nullable
    @ODataField( odataName = "AddressFaxNumber" )
    private String addressFaxNumber;
    /**
     * Use with available fluent helpers to apply the <b>AddressFaxNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtDeliveryAddressField<String> ADDRESS_FAX_NUMBER =
        new SchedgAgrmtDeliveryAddressField<String>("AddressFaxNumber");

    @Nonnull
    @Override
    public Class<SchedgAgrmtDeliveryAddress> getType()
    {
        return SchedgAgrmtDeliveryAddress.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @param schedulingAgreementItem
     *            Item Number of Purchasing Document
     */
    public void setSchedulingAgreementItem( @Nullable final String schedulingAgreementItem )
    {
        rememberChangedField("SchedulingAgreementItem", this.schedulingAgreementItem);
        this.schedulingAgreementItem = schedulingAgreementItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryAddressID</b>
     * </p>
     *
     * @param deliveryAddressID
     *            Manual address number in purchasing document item
     */
    public void setDeliveryAddressID( @Nullable final String deliveryAddressID )
    {
        rememberChangedField("DeliveryAddressID", this.deliveryAddressID);
        this.deliveryAddressID = deliveryAddressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressType</b>
     * </p>
     *
     * @param addressType
     *            Purchase Requisition Address Type
     */
    public void setAddressType( @Nullable final String addressType )
    {
        rememberChangedField("AddressType", this.addressType);
        this.addressType = addressType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingDeliveryAddressType</b>
     * </p>
     *
     * @param purchasingDeliveryAddressType
     *            Purchasing Delivery Address Type
     */
    public void setPurchasingDeliveryAddressType( @Nullable final String purchasingDeliveryAddressType )
    {
        rememberChangedField("PurchasingDeliveryAddressType", this.purchasingDeliveryAddressType);
        this.purchasingDeliveryAddressType = purchasingDeliveryAddressType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FullName</b>
     * </p>
     *
     * @param fullName
     *            Full name of a party (Bus. Partner, Org. Unit, Doc. address)
     */
    public void setFullName( @Nullable final String fullName )
    {
        rememberChangedField("FullName", this.fullName);
        this.fullName = fullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobileNumber</b>
     * </p>
     *
     * @param mobileNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setMobileNumber( @Nullable final String mobileNumber )
    {
        rememberChangedField("MobileNumber", this.mobileNumber);
        this.mobileNumber = mobileNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Language Key
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumber</b>
     * </p>
     *
     * @param faxNumber
     *            First Fax No.: Area Code + Number
     */
    public void setFaxNumber( @Nullable final String faxNumber )
    {
        rememberChangedField("FaxNumber", this.faxNumber);
        this.faxNumber = faxNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AddressFaxNumber</b>
     * </p>
     *
     * @param addressFaxNumber
     *            First Fax No.: Area Code + Number
     */
    public void setAddressFaxNumber( @Nullable final String addressFaxNumber )
    {
        rememberChangedField("AddressFaxNumber", this.addressFaxNumber);
        this.addressFaxNumber = addressFaxNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchedgAgrmtDeliveryAddress";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        result.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        values.put("DeliveryAddressID", getDeliveryAddressID());
        values.put("AddressType", getAddressType());
        values.put("PurchasingDeliveryAddressType", getPurchasingDeliveryAddressType());
        values.put("FullName", getFullName());
        values.put("StreetName", getStreetName());
        values.put("HouseNumber", getHouseNumber());
        values.put("PostalCode", getPostalCode());
        values.put("CityName", getCityName());
        values.put("MobileNumber", getMobileNumber());
        values.put("Region", getRegion());
        values.put("Country", getCountry());
        values.put("EmailAddress", getEmailAddress());
        values.put("Plant", getPlant());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("FaxNumber", getFaxNumber());
        values.put("AddressFaxNumber", getAddressFaxNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementItem") ) {
                final Object value = values.remove("SchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSchedulingAgreementItem())) ) {
                    setSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("DeliveryAddressID") ) {
                final Object value = values.remove("DeliveryAddressID");
                if( (value == null) || (!value.equals(getDeliveryAddressID())) ) {
                    setDeliveryAddressID(((String) value));
                }
            }
            if( values.containsKey("AddressType") ) {
                final Object value = values.remove("AddressType");
                if( (value == null) || (!value.equals(getAddressType())) ) {
                    setAddressType(((String) value));
                }
            }
            if( values.containsKey("PurchasingDeliveryAddressType") ) {
                final Object value = values.remove("PurchasingDeliveryAddressType");
                if( (value == null) || (!value.equals(getPurchasingDeliveryAddressType())) ) {
                    setPurchasingDeliveryAddressType(((String) value));
                }
            }
            if( values.containsKey("FullName") ) {
                final Object value = values.remove("FullName");
                if( (value == null) || (!value.equals(getFullName())) ) {
                    setFullName(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("MobileNumber") ) {
                final Object value = values.remove("MobileNumber");
                if( (value == null) || (!value.equals(getMobileNumber())) ) {
                    setMobileNumber(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumber") ) {
                final Object value = values.remove("FaxNumber");
                if( (value == null) || (!value.equals(getFaxNumber())) ) {
                    setFaxNumber(((String) value));
                }
            }
            if( values.containsKey("AddressFaxNumber") ) {
                final Object value = values.remove("AddressFaxNumber");
                if( (value == null) || (!value.equals(getAddressFaxNumber())) ) {
                    setAddressFaxNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SchedgAgrmtDeliveryAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SchedgAgrmtDeliveryAddressField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchedgAgrmtDeliveryAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchedgAgrmtDeliveryAddressField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

}
