/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtHdrNotesField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchedgAgrmtHdrNotesSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Header Notes
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchedgAgrmtHdrNotesType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchedgAgrmtHdrNotes extends VdmEntity<SchedgAgrmtHdrNotes>
{

    /**
     * Selector for all available fields of SchedgAgrmtHdrNotes.
     *
     */
    public final static SchedgAgrmtHdrNotesSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> LANGUAGE = new SchedgAgrmtHdrNotesField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DocumentText</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "DocumentText" )
    @JsonProperty( "DocumentText" )
    @Nullable
    @ODataField( odataName = "DocumentText" )
    private String documentText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentText</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> DOCUMENT_TEXT =
        new SchedgAgrmtHdrNotesField<String>("DocumentText");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @return Texts: application object
     */
    @Key
    @SerializedName( "TechnicalObjectType" )
    @JsonProperty( "TechnicalObjectType" )
    @Nullable
    @ODataField( odataName = "TechnicalObjectType" )
    private String technicalObjectType;
    /**
     * Use with available fluent helpers to apply the <b>TechnicalObjectType</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> TECHNICAL_OBJECT_TYPE =
        new SchedgAgrmtHdrNotesField<String>("TechnicalObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ArchObjectNumber</b>
     * </p>
     *
     * @return Name
     */
    @Key
    @SerializedName( "ArchObjectNumber" )
    @JsonProperty( "ArchObjectNumber" )
    @Nullable
    @ODataField( odataName = "ArchObjectNumber" )
    private String archObjectNumber;
    /**
     * Use with available fluent helpers to apply the <b>ArchObjectNumber</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> ARCH_OBJECT_NUMBER =
        new SchedgAgrmtHdrNotesField<String>("ArchObjectNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document Number
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> SCHEDULING_AGREEMENT =
        new SchedgAgrmtHdrNotesField<String>("SchedulingAgreement");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoteDescription</b>
     * </p>
     *
     * @return Long Text
     */
    @SerializedName( "NoteDescription" )
    @JsonProperty( "NoteDescription" )
    @Nullable
    @ODataField( odataName = "NoteDescription" )
    private String noteDescription;
    /**
     * Use with available fluent helpers to apply the <b>NoteDescription</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> NOTE_DESCRIPTION =
        new SchedgAgrmtHdrNotesField<String>("NoteDescription");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedIndicator</b>
     * </p>
     *
     * @return "Fixed" Indicator for Texts
     */
    @SerializedName( "FixedIndicator" )
    @JsonProperty( "FixedIndicator" )
    @Nullable
    @ODataField( odataName = "FixedIndicator" )
    private String fixedIndicator;
    /**
     * Use with available fluent helpers to apply the <b>FixedIndicator</b> field to query operations.
     *
     */
    public final static SchedgAgrmtHdrNotesField<String> FIXED_INDICATOR =
        new SchedgAgrmtHdrNotesField<String>("FixedIndicator");

    @Nonnull
    @Override
    public Class<SchedgAgrmtHdrNotes> getType()
    {
        return SchedgAgrmtHdrNotes.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DocumentText</b>
     * </p>
     *
     * @param documentText
     *            Text ID
     */
    public void setDocumentText( @Nullable final String documentText )
    {
        rememberChangedField("DocumentText", this.documentText);
        this.documentText = documentText;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TechnicalObjectType</b>
     * </p>
     *
     * @param technicalObjectType
     *            Texts: application object
     */
    public void setTechnicalObjectType( @Nullable final String technicalObjectType )
    {
        rememberChangedField("TechnicalObjectType", this.technicalObjectType);
        this.technicalObjectType = technicalObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>ArchObjectNumber</b>
     * </p>
     *
     * @param archObjectNumber
     *            Name
     */
    public void setArchObjectNumber( @Nullable final String archObjectNumber )
    {
        rememberChangedField("ArchObjectNumber", this.archObjectNumber);
        this.archObjectNumber = archObjectNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document Number
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>NoteDescription</b>
     * </p>
     *
     * @param noteDescription
     *            Long Text
     */
    public void setNoteDescription( @Nullable final String noteDescription )
    {
        rememberChangedField("NoteDescription", this.noteDescription);
        this.noteDescription = noteDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>FixedIndicator</b>
     * </p>
     *
     * @param fixedIndicator
     *            "Fixed" Indicator for Texts
     */
    public void setFixedIndicator( @Nullable final String fixedIndicator )
    {
        rememberChangedField("FixedIndicator", this.fixedIndicator);
        this.fixedIndicator = fixedIndicator;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchedgAgrmtHdrNotes";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("DocumentText", getDocumentText());
        result.put("TechnicalObjectType", getTechnicalObjectType());
        result.put("ArchObjectNumber", getArchObjectNumber());
        result.put("SchedulingAgreement", getSchedulingAgreement());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("DocumentText", getDocumentText());
        values.put("TechnicalObjectType", getTechnicalObjectType());
        values.put("ArchObjectNumber", getArchObjectNumber());
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("NoteDescription", getNoteDescription());
        values.put("FixedIndicator", getFixedIndicator());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DocumentText") ) {
                final Object value = values.remove("DocumentText");
                if( (value == null) || (!value.equals(getDocumentText())) ) {
                    setDocumentText(((String) value));
                }
            }
            if( values.containsKey("TechnicalObjectType") ) {
                final Object value = values.remove("TechnicalObjectType");
                if( (value == null) || (!value.equals(getTechnicalObjectType())) ) {
                    setTechnicalObjectType(((String) value));
                }
            }
            if( values.containsKey("ArchObjectNumber") ) {
                final Object value = values.remove("ArchObjectNumber");
                if( (value == null) || (!value.equals(getArchObjectNumber())) ) {
                    setArchObjectNumber(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("NoteDescription") ) {
                final Object value = values.remove("NoteDescription");
                if( (value == null) || (!value.equals(getNoteDescription())) ) {
                    setNoteDescription(((String) value));
                }
            }
            if( values.containsKey("FixedIndicator") ) {
                final Object value = values.remove("FixedIndicator");
                if( (value == null) || (!value.equals(getFixedIndicator())) ) {
                    setFixedIndicator(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SchedgAgrmtHdrNotesField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchedgAgrmtHdrNotesField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchedgAgrmtHdrNotesField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchedgAgrmtHdrNotesField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

}
