/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchedgAgrmtItmNotesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
 * SchedgAgrmtItmNotes} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SchedgAgrmtItmNotesByKeyFluentHelper
    extends
    FluentHelperByKey<SchedgAgrmtItmNotesByKeyFluentHelper, SchedgAgrmtItmNotes, SchedgAgrmtItmNotesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SchedgAgrmtItmNotes}
     * @param technicalObjectType
     *            Texts: application object
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SchedgAgrmtItmNotes}
     * @param documentText
     *            Text ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param archObjectNumber
     *            Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public SchedgAgrmtItmNotesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String documentText,
        final String technicalObjectType,
        final String archObjectNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("DocumentText", documentText);
        this.key.put("TechnicalObjectType", technicalObjectType);
        this.key.put("ArchObjectNumber", archObjectNumber);
    }

    @Override
    @Nonnull
    protected Class<SchedgAgrmtItmNotes> getEntityClass()
    {
        return SchedgAgrmtItmNotes.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
