/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtSubcontrgCompField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchedgAgrmtSubcontrgCompSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Subcontracting Components
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SchedgAgrmtSubcontrgCompType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SchedgAgrmtSubcontrgComp extends VdmEntity<SchedgAgrmtSubcontrgComp>
{

    /**
     * Selector for all available fields of SchedgAgrmtSubcontrgComp.
     *
     */
    public final static SchedgAgrmtSubcontrgCompSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @return Purchasing Document
     */
    @Key
    @SerializedName( "SchedulingAgreement" )
    @JsonProperty( "SchedulingAgreement" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreement" )
    private String schedulingAgreement;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreement</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> SCHEDULING_AGREEMENT =
        new SchedgAgrmtSubcontrgCompField<String>("SchedulingAgreement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @return Purchasing Document Item
     */
    @Key
    @SerializedName( "SchedulingAgreementItem" )
    @JsonProperty( "SchedulingAgreementItem" )
    @Nullable
    @ODataField( odataName = "SchedulingAgreementItem" )
    private String schedulingAgreementItem;
    /**
     * Use with available fluent helpers to apply the <b>SchedulingAgreementItem</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> SCHEDULING_AGREEMENT_ITEM =
        new SchedgAgrmtSubcontrgCompField<String>("SchedulingAgreementItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Delivery Schedule Line Counter
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> SCHEDULE_LINE =
        new SchedgAgrmtSubcontrgCompField<String>("ScheduleLine");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> RESERVATION_ITEM =
        new SchedgAgrmtSubcontrgCompField<String>("ReservationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @return Reservation Record Type
     */
    @Key
    @SerializedName( "RecordType" )
    @JsonProperty( "RecordType" )
    @Nullable
    @ODataField( odataName = "RecordType" )
    private String recordType;
    /**
     * Use with available fluent helpers to apply the <b>RecordType</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> RECORD_TYPE =
        new SchedgAgrmtSubcontrgCompField<String>("RecordType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> RESERVATION =
        new SchedgAgrmtSubcontrgCompField<String>("Reservation");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> MATERIAL =
        new SchedgAgrmtSubcontrgCompField<String>("Material");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "RequirementDate" )
    @JsonProperty( "RequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requirementDate;
    /**
     * Use with available fluent helpers to apply the <b>RequirementDate</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<LocalDateTime> REQUIREMENT_DATE =
        new SchedgAgrmtSubcontrgCompField<LocalDateTime>("RequirementDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTime</b>
     * </p>
     *
     * @return Material Component Requirement Time
     */
    @SerializedName( "RequirementTime" )
    @JsonProperty( "RequirementTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "RequirementTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime requirementTime;
    /**
     * Use with available fluent helpers to apply the <b>RequirementTime</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<LocalTime> REQUIREMENT_TIME =
        new SchedgAgrmtSubcontrgCompField<LocalTime>("RequirementTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> PLANT =
        new SchedgAgrmtSubcontrgCompField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @return Quantity in Unit of Entry
     */
    @SerializedName( "QuantityInEntryUnit" )
    @JsonProperty( "QuantityInEntryUnit" )
    @Nullable
    @ODataField( odataName = "QuantityInEntryUnit" )
    private BigDecimal quantityInEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityInEntryUnit</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<BigDecimal> QUANTITY_IN_ENTRY_UNIT =
        new SchedgAgrmtSubcontrgCompField<BigDecimal>("QuantityInEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @return Unit of entry
     */
    @SerializedName( "EntryUnit" )
    @JsonProperty( "EntryUnit" )
    @Nullable
    @ODataField( odataName = "EntryUnit" )
    private String entryUnit;
    /**
     * Use with available fluent helpers to apply the <b>EntryUnit</b> field to query operations.
     *
     */
    public final static SchedgAgrmtSubcontrgCompField<String> ENTRY_UNIT =
        new SchedgAgrmtSubcontrgCompField<String>("EntryUnit");

    @Nonnull
    @Override
    public Class<SchedgAgrmtSubcontrgComp> getType()
    {
        return SchedgAgrmtSubcontrgComp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreement</b>
     * </p>
     *
     * @param schedulingAgreement
     *            Purchasing Document
     */
    public void setSchedulingAgreement( @Nullable final String schedulingAgreement )
    {
        rememberChangedField("SchedulingAgreement", this.schedulingAgreement);
        this.schedulingAgreement = schedulingAgreement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SchedulingAgreementItem</b>
     * </p>
     *
     * @param schedulingAgreementItem
     *            Purchasing Document Item
     */
    public void setSchedulingAgreementItem( @Nullable final String schedulingAgreementItem )
    {
        rememberChangedField("SchedulingAgreementItem", this.schedulingAgreementItem);
        this.schedulingAgreementItem = schedulingAgreementItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Delivery Schedule Line Counter
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecordType</b>
     * </p>
     *
     * @param recordType
     *            Reservation Record Type
     */
    public void setRecordType( @Nullable final String recordType )
    {
        rememberChangedField("RecordType", this.recordType);
        this.recordType = recordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementDate</b>
     * </p>
     *
     * @param requirementDate
     *            Material Component Requirement Date
     */
    public void setRequirementDate( @Nullable final LocalDateTime requirementDate )
    {
        rememberChangedField("RequirementDate", this.requirementDate);
        this.requirementDate = requirementDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequirementTime</b>
     * </p>
     *
     * @param requirementTime
     *            Material Component Requirement Time
     */
    public void setRequirementTime( @Nullable final LocalTime requirementTime )
    {
        rememberChangedField("RequirementTime", this.requirementTime);
        this.requirementTime = requirementTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityInEntryUnit</b>
     * </p>
     *
     * @param quantityInEntryUnit
     *            Quantity in Unit of Entry
     */
    public void setQuantityInEntryUnit( @Nullable final BigDecimal quantityInEntryUnit )
    {
        rememberChangedField("QuantityInEntryUnit", this.quantityInEntryUnit);
        this.quantityInEntryUnit = quantityInEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EntryUnit</b>
     * </p>
     *
     * @param entryUnit
     *            Unit of entry
     */
    public void setEntryUnit( @Nullable final String entryUnit )
    {
        rememberChangedField("EntryUnit", this.entryUnit);
        this.entryUnit = entryUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SchedgAgrmtSubcontrgComp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SchedulingAgreement", getSchedulingAgreement());
        result.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        result.put("ScheduleLine", getScheduleLine());
        result.put("ReservationItem", getReservationItem());
        result.put("RecordType", getRecordType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SchedulingAgreement", getSchedulingAgreement());
        values.put("SchedulingAgreementItem", getSchedulingAgreementItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("ReservationItem", getReservationItem());
        values.put("RecordType", getRecordType());
        values.put("Reservation", getReservation());
        values.put("Material", getMaterial());
        values.put("RequirementDate", getRequirementDate());
        values.put("RequirementTime", getRequirementTime());
        values.put("Plant", getPlant());
        values.put("QuantityInEntryUnit", getQuantityInEntryUnit());
        values.put("EntryUnit", getEntryUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SchedulingAgreement") ) {
                final Object value = values.remove("SchedulingAgreement");
                if( (value == null) || (!value.equals(getSchedulingAgreement())) ) {
                    setSchedulingAgreement(((String) value));
                }
            }
            if( values.containsKey("SchedulingAgreementItem") ) {
                final Object value = values.remove("SchedulingAgreementItem");
                if( (value == null) || (!value.equals(getSchedulingAgreementItem())) ) {
                    setSchedulingAgreementItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("RecordType") ) {
                final Object value = values.remove("RecordType");
                if( (value == null) || (!value.equals(getRecordType())) ) {
                    setRecordType(((String) value));
                }
            }
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("RequirementDate") ) {
                final Object value = values.remove("RequirementDate");
                if( (value == null) || (!value.equals(getRequirementDate())) ) {
                    setRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RequirementTime") ) {
                final Object value = values.remove("RequirementTime");
                if( (value == null) || (!value.equals(getRequirementTime())) ) {
                    setRequirementTime(((LocalTime) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("QuantityInEntryUnit") ) {
                final Object value = values.remove("QuantityInEntryUnit");
                if( (value == null) || (!value.equals(getQuantityInEntryUnit())) ) {
                    setQuantityInEntryUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("EntryUnit") ) {
                final Object value = values.remove("EntryUnit");
                if( (value == null) || (!value.equals(getEntryUnit())) ) {
                    setEntryUnit(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SchedgAgrmtSubcontrgCompField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SchedgAgrmtSubcontrgCompField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SchedgAgrmtSubcontrgCompField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SchedgAgrmtSubcontrgCompField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

}
