/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
 * SchedgAgrmtSubcontrgComp} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SchedgAgrmtSubcontrgCompDeleteFluentHelper
    extends
    FluentHelperDelete<SchedgAgrmtSubcontrgCompDeleteFluentHelper, SchedgAgrmtSubcontrgComp>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final SchedgAgrmtSubcontrgComp entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SchedgAgrmtSubcontrgComp to delete from the endpoint.
     */
    public SchedgAgrmtSubcontrgCompDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SchedgAgrmtSubcontrgComp entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SchedgAgrmtSubcontrgComp getEntity()
    {
        return entity;
    }

}
