/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SchedulingAgreementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService SchedulingAgreementService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSchedulingAgreementServiceBatch
    extends
    BatchFluentHelperBasic<SchedulingAgreementServiceBatch, SchedulingAgreementServiceBatchChangeSet>
    implements
    SchedulingAgreementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSchedulingAgreementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSchedulingAgreementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSchedulingAgreementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSchedulingAgreementServiceBatchChangeSet(this, service);
    }

}
