/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp;

/**
 * Implementation of the {@link SchedulingAgreementServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService SchedulingAgreementService}.
 *
 */
public class DefaultSchedulingAgreementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SchedulingAgreementServiceBatch, SchedulingAgreementServiceBatchChangeSet>
    implements
    SchedulingAgreementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService service;

    @SuppressWarnings( "deprecation" )
    DefaultSchedulingAgreementServiceBatchChangeSet(
        @Nonnull final DefaultSchedulingAgreementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSchedulingAgreementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt )
    {
        return addRequestCreate(service::createSchAgrmtAcCnt, schAgrmtAcCnt);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt )
    {
        return addRequestUpdate(service::updateSchAgrmtAcCnt, schAgrmtAcCnt);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader )
    {
        return addRequestCreate(service::createSchAgrmtHeader, schAgrmtHeader);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader )
    {
        return addRequestUpdate(service::updateSchAgrmtHeader, schAgrmtHeader);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem )
    {
        return addRequestCreate(service::createSchAgrmtItem, schAgrmtItem);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem )
    {
        return addRequestUpdate(service::updateSchAgrmtItem, schAgrmtItem);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchAgrmtSchLine(
        @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return addRequestCreate(service::createSchAgrmtSchLine, schAgrmtSchLine);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchAgrmtSchLine(
        @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return addRequestUpdate(service::updateSchAgrmtSchLine, schAgrmtSchLine);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet deleteSchAgrmtSchLine(
        @Nonnull final SchAgrmtSchLine schAgrmtSchLine )
    {
        return addRequestDelete(service::deleteSchAgrmtSchLine, schAgrmtSchLine);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchedgAgrmtDeliveryAddress(
        @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress )
    {
        return addRequestCreate(service::createSchedgAgrmtDeliveryAddress, schedgAgrmtDeliveryAddress);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchedgAgrmtDeliveryAddress(
        @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress )
    {
        return addRequestUpdate(service::updateSchedgAgrmtDeliveryAddress, schedgAgrmtDeliveryAddress);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return addRequestCreate(service::createSchedgAgrmtHdrNotes, schedgAgrmtHdrNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return addRequestUpdate(service::updateSchedgAgrmtHdrNotes, schedgAgrmtHdrNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet deleteSchedgAgrmtHdrNotes(
        @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes )
    {
        return addRequestDelete(service::deleteSchedgAgrmtHdrNotes, schedgAgrmtHdrNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet createSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return addRequestCreate(service::createSchedgAgrmtItmNotes, schedgAgrmtItmNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return addRequestUpdate(service::updateSchedgAgrmtItmNotes, schedgAgrmtItmNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet deleteSchedgAgrmtItmNotes(
        @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes )
    {
        return addRequestDelete(service::deleteSchedgAgrmtItmNotes, schedgAgrmtItmNotes);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet updateSchedgAgrmtSubcontrgComp(
        @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp )
    {
        return addRequestUpdate(service::updateSchedgAgrmtSubcontrgComp, schedgAgrmtSubcontrgComp);
    }

    @Nonnull
    @Override
    public SchedulingAgreementServiceBatchChangeSet deleteSchedgAgrmtSubcontrgComp(
        @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp )
    {
        return addRequestDelete(service::deleteSchedgAgrmtSubcontrgComp, schedgAgrmtSubcontrgComp);
    }

}
