/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SchedulingAgreementService
 * SchedulingAgreementService}.
 *
 */
public interface SchedulingAgreementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SchedulingAgreementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SchedulingAgreementServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtAcCnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *            SchAgrmtAcCnt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet createSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     * SchAgrmtAcCnt} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtAcCnt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt
     *            SchAgrmtAcCnt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet updateSchAgrmtAcCnt( @Nonnull final SchAgrmtAcCnt schAgrmtAcCnt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *            SchAgrmtHeader} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet createSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     * SchAgrmtHeader} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtHeader
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader
     *            SchAgrmtHeader} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet updateSchAgrmtHeader( @Nonnull final SchAgrmtHeader schAgrmtHeader );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     *            SchAgrmtItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet createSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     * SchAgrmtItem} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtItem
     *            SchAgrmtItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet updateSchAgrmtItem( @Nonnull final SchAgrmtItem schAgrmtItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet createSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     * SchAgrmtSchLine} entity and save it to the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet updateSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine SchAgrmtSchLine}
     * entity in the S/4HANA system.
     *
     * @param schAgrmtSchLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtSchLine
     *            SchAgrmtSchLine} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet deleteSchAgrmtSchLine( @Nonnull final SchAgrmtSchLine schAgrmtSchLine );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtDeliveryAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *            SchedgAgrmtDeliveryAddress} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        createSchedgAgrmtDeliveryAddress( @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     * SchedgAgrmtDeliveryAddress} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtDeliveryAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
     *            SchedgAgrmtDeliveryAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        updateSchedgAgrmtDeliveryAddress( @Nonnull final SchedgAgrmtDeliveryAddress schedgAgrmtDeliveryAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        createSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        updateSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     * SchedgAgrmtHdrNotes} entity in the S/4HANA system.
     *
     * @param schedgAgrmtHdrNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
     *            SchedgAgrmtHdrNotes} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        deleteSchedgAgrmtHdrNotes( @Nonnull final SchedgAgrmtHdrNotes schedgAgrmtHdrNotes );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        createSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        updateSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     * SchedgAgrmtItmNotes} entity in the S/4HANA system.
     *
     * @param schedgAgrmtItmNotes
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtItmNotes
     *            SchedgAgrmtItmNotes} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        deleteSchedgAgrmtItmNotes( @Nonnull final SchedgAgrmtItmNotes schedgAgrmtItmNotes );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity and save it to the S/4HANA system.
     *
     * @param schedgAgrmtSubcontrgComp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *            SchedgAgrmtSubcontrgComp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        updateSchedgAgrmtSubcontrgComp( @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     * SchedgAgrmtSubcontrgComp} entity in the S/4HANA system.
     *
     * @param schedgAgrmtSubcontrgComp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
     *            SchedgAgrmtSubcontrgComp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SchedulingAgreementServiceBatchChangeSet
        deleteSchedgAgrmtSubcontrgComp( @Nonnull final SchedgAgrmtSubcontrgComp schedgAgrmtSubcontrgComp );

}
