/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtHeaderSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtHeader SchAgrmtHeader} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SchAgrmtHeaderLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SchAgrmtHeaderLink<ObjectT>, SchAgrmtHeader, ObjectT>
    implements
    SchAgrmtHeaderSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SchAgrmtHeaderLink( final String fieldName )
    {
        super(fieldName);
    }

    private SchAgrmtHeaderLink( final EntityLink<SchAgrmtHeaderLink<ObjectT>, SchAgrmtHeader, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SchAgrmtHeaderLink<ObjectT> translateLinkType(
        final EntityLink<SchAgrmtHeaderLink<ObjectT>, SchAgrmtHeader, ObjectT> link )
    {
        return new SchAgrmtHeaderLink<ObjectT>(link);
    }

}
