/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable.SchAgrmtPartnerSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner SchAgrmtPartner} to
 * other entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains
 * methods to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class SchAgrmtPartnerLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<SchAgrmtPartnerLink<ObjectT>, SchAgrmtPartner, ObjectT>
    implements
    SchAgrmtPartnerSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public SchAgrmtPartnerLink( final String fieldName )
    {
        super(fieldName);
    }

    private SchAgrmtPartnerLink( final EntityLink<SchAgrmtPartnerLink<ObjectT>, SchAgrmtPartner, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected SchAgrmtPartnerLink<ObjectT> translateLinkType(
        final EntityLink<SchAgrmtPartnerLink<ObjectT>, SchAgrmtPartner, ObjectT> link )
    {
        return new SchAgrmtPartnerLink<ObjectT>(link);
    }

}
