/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt SchAgrmtAcCnt}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtAcCntField
 * SchAgrmtAcCntField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtAcCntLink
 * SchAgrmtAcCntLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#ACCOUNT_ASSIGNMENT_NUMBER
 * ACCOUNT_ASSIGNMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SCHEDULING_AGREEMENT_ITEM
 * SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SCHEDULING_AGREEMENT
 * SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#MASTER_FIXED_ASSET
 * MASTER_FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PROJECT_NETWORK
 * PROJECT_NETWORK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#QUANTITY
 * QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT
 * MULTIPLE_ACCT_ASSGMT_DISTR_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#DOCUMENT_CURRENCY
 * DOCUMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PURG_DOC_NET_AMOUNT
 * PURG_DOC_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#IS_DELETED
 * IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SALES_ORDER_SCHEDULE_LINE
 * SALES_ORDER_SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#FIXED_ASSET
 * FIXED_ASSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#ORDER_ID
 * ORDER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#COST_OBJECT
 * COST_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PROFITABILITY_SEGMENT
 * PROFITABILITY_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PROJECT_NETWORK_INTERNAL_ID
 * PROJECT_NETWORK_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#IS_FINALLY_INVOICED
 * IS_FINALLY_INVOICED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#REAL_ESTATE_OBJECT
 * REAL_ESTATE_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#NETWORK_ACTIVITY_INTERNAL_ID
 * NETWORK_ACTIVITY_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#PARTNER_ACCOUNT_NUMBER
 * PARTNER_ACCOUNT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#JOINT_VENTURE_RECOVERY_CODE
 * JOINT_VENTURE_RECOVERY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#SETTLEMENT_REFERENCE_DATE
 * SETTLEMENT_REFERENCE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#ORDER_INTERNAL_ID
 * ORDER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#TAX_CODE
 * TAX_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#COST_CTR_ACTIVITY_TYPE
 * COST_CTR_ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#BUSINESS_PROCESS
 * BUSINESS_PROCESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtAcCnt#VALIDITY_DATE
 * VALIDITY_DATE}</li>
 * </ul>
 *
 */
public interface SchAgrmtAcCntSelectable extends EntitySelectable<SchAgrmtAcCnt>
{

}
