/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner SchAgrmtPartner}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchAgrmtPartnerField
 * SchAgrmtPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchAgrmtPartnerLink
 * SchAgrmtPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#SCHEDULING_AGREEMENT
 * SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#SCHEDULING_AGREEMENT_ITEM
 * SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#PURCHASING_ORGANIZATION
 * PURCHASING_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#SUPPLIER_SUBRANGE
 * SUPPLIER_SUBRANGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#PARTNER_COUNTER
 * PARTNER_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchAgrmtPartner#DEFAULT_PARTNER
 * DEFAULT_PARTNER}</li>
 * </ul>
 *
 */
public interface SchAgrmtPartnerSelectable extends EntitySelectable<SchAgrmtPartner>
{

}
