/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress
 * SchedgAgrmtDeliveryAddress}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtDeliveryAddressField
 * SchedgAgrmtDeliveryAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchedgAgrmtDeliveryAddressLink
 * SchedgAgrmtDeliveryAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#SCHEDULING_AGREEMENT
 * SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#SCHEDULING_AGREEMENT_ITEM
 * SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#DELIVERY_ADDRESS_ID
 * DELIVERY_ADDRESS_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#ADDRESS_TYPE
 * ADDRESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#PURCHASING_DELIVERY_ADDRESS_TYPE
 * PURCHASING_DELIVERY_ADDRESS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#FULL_NAME
 * FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#MOBILE_NUMBER
 * MOBILE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#FAX_NUMBER
 * FAX_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtDeliveryAddress#ADDRESS_FAX_NUMBER
 * ADDRESS_FAX_NUMBER}</li>
 * </ul>
 *
 */
public interface SchedgAgrmtDeliveryAddressSelectable extends EntitySelectable<SchedgAgrmtDeliveryAddress>
{

}
