/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes
 * SchedgAgrmtHdrNotes}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtHdrNotesField
 * SchedgAgrmtHdrNotesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchedgAgrmtHdrNotesLink
 * SchedgAgrmtHdrNotesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#DOCUMENT_TEXT
 * DOCUMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#TECHNICAL_OBJECT_TYPE
 * TECHNICAL_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#ARCH_OBJECT_NUMBER
 * ARCH_OBJECT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#SCHEDULING_AGREEMENT
 * SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#NOTE_DESCRIPTION
 * NOTE_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtHdrNotes#FIXED_INDICATOR
 * FIXED_INDICATOR}</li>
 * </ul>
 *
 */
public interface SchedgAgrmtHdrNotesSelectable extends EntitySelectable<SchedgAgrmtHdrNotes>
{

}
