/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp
 * SchedgAgrmtSubcontrgComp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.field.SchedgAgrmtSubcontrgCompField
 * SchedgAgrmtSubcontrgCompField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.link.SchedgAgrmtSubcontrgCompLink
 * SchedgAgrmtSubcontrgCompLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#SCHEDULING_AGREEMENT
 * SCHEDULING_AGREEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#SCHEDULING_AGREEMENT_ITEM
 * SCHEDULING_AGREEMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#RECORD_TYPE
 * RECORD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#REQUIREMENT_DATE
 * REQUIREMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#REQUIREMENT_TIME
 * REQUIREMENT_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#QUANTITY_IN_ENTRY_UNIT
 * QUANTITY_IN_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.schedulingagreement.SchedgAgrmtSubcontrgComp#ENTRY_UNIT
 * ENTRY_UNIT}</li>
 * </ul>
 *
 */
public interface SchedgAgrmtSubcontrgCompSelectable extends EntitySelectable<SchedgAgrmtSubcontrgComp>
{

}
