/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SegmentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService SegmentService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSegmentServiceBatch
    extends
    BatchFluentHelperBasic<SegmentServiceBatch, SegmentServiceBatchChangeSet>
    implements
    SegmentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSegmentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSegmentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSegmentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSegmentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSegmentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SegmentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSegmentServiceBatchChangeSet(this, service);
    }

}
