/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SegmentServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService SegmentService}.
 *
 */
public class DefaultSegmentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SegmentServiceBatch, SegmentServiceBatchChangeSet>
    implements
    SegmentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService service;

    @SuppressWarnings( "deprecation" )
    DefaultSegmentServiceBatchChangeSet(
        @Nonnull final DefaultSegmentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SegmentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSegmentServiceBatchChangeSet getThis()
    {
        return this;
    }

}
