/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.Segment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.Segment Segment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.field.SegmentField SegmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.link.SegmentLink SegmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.Segment#SEGMENT SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.segment.Segment#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface SegmentSelectable extends EntitySelectable<Segment>
{

}
