/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.selectable.SEPAMandateSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
 * SEPAMandate} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SEPAMandateByKeyFluentHelper
    extends
    FluentHelperByKey<SEPAMandateByKeyFluentHelper, SEPAMandate, SEPAMandateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
     * SEPAMandate} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SEPAMandate}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SEPAMandate}
     * @param creditor
     *            Creditor Identification Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandate
     *            Unique Reference to Mandate for each Payee
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     */
    public SEPAMandateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String creditor,
        final String sEPAMandate )
    {
        super(servicePath, entityCollection);
        this.key.put("Creditor", creditor);
        this.key.put("SEPAMandate", sEPAMandate);
    }

    @Override
    @Nonnull
    protected Class<SEPAMandate> getEntityClass()
    {
        return SEPAMandate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
