/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.field.SEPAMandateUsageField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.selectable.SEPAMandateUsageSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * SEPA Mandate Usage
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SEPAMandateUsage</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SEPAMandateUsage extends VdmEntity<SEPAMandateUsage>
{

    /**
     * Selector for all available fields of SEPAMandateUsage.
     *
     */
    public final static SEPAMandateUsageSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateApplication</b>
     * </p>
     *
     * @return Application
     */
    @SerializedName( "SEPAMandateApplication" )
    @JsonProperty( "SEPAMandateApplication" )
    @Nullable
    @ODataField( odataName = "SEPAMandateApplication" )
    private String sEPAMandateApplication;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateApplication</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<String> SEPA_MANDATE_APPLICATION =
        new SEPAMandateUsageField<String>("SEPAMandateApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @return Creditor ID
     */
    @Key
    @SerializedName( "Creditor" )
    @JsonProperty( "Creditor" )
    @Nullable
    @ODataField( odataName = "Creditor" )
    private String creditor;
    /**
     * Use with available fluent helpers to apply the <b>Creditor</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<String> CREDITOR = new SEPAMandateUsageField<String>("Creditor");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Mandate Refeference
     */
    @Key
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<String> SEPA_MANDATE = new SEPAMandateUsageField<String>("SEPAMandate");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUseDate</b>
     * </p>
     *
     * @return Date
     */
    @Key
    @SerializedName( "SEPAMandateUseDate" )
    @JsonProperty( "SEPAMandateUseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SEPAMandateUseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime sEPAMandateUseDate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateUseDate</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<LocalDateTime> SEPA_MANDATE_USE_DATE =
        new SEPAMandateUsageField<LocalDateTime>("SEPAMandateUseDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUseObjectType</b>
     * </p>
     *
     * @return Object Type
     */
    @Key
    @SerializedName( "SEPAMandateUseObjectType" )
    @JsonProperty( "SEPAMandateUseObjectType" )
    @Nullable
    @ODataField( odataName = "SEPAMandateUseObjectType" )
    private String sEPAMandateUseObjectType;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateUseObjectType</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<String> SEPA_MANDATE_USE_OBJECT_TYPE =
        new SEPAMandateUsageField<String>("SEPAMandateUseObjectType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUsePaymentDoc</b>
     * </p>
     *
     * @return Key
     */
    @Key
    @SerializedName( "SEPAMandateUsePaymentDoc" )
    @JsonProperty( "SEPAMandateUsePaymentDoc" )
    @Nullable
    @ODataField( odataName = "SEPAMandateUsePaymentDoc" )
    private String sEPAMandateUsePaymentDoc;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandateUsePaymentDoc</b> field to query operations.
     *
     */
    public final static SEPAMandateUsageField<String> SEPA_MANDATE_USE_PAYMENT_DOC =
        new SEPAMandateUsageField<String>("SEPAMandateUsePaymentDoc");

    @Nonnull
    @Override
    public Class<SEPAMandateUsage> getType()
    {
        return SEPAMandateUsage.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateApplication</b>
     * </p>
     *
     * @param sEPAMandateApplication
     *            Application
     */
    public void setSEPAMandateApplication( @Nullable final String sEPAMandateApplication )
    {
        rememberChangedField("SEPAMandateApplication", this.sEPAMandateApplication);
        this.sEPAMandateApplication = sEPAMandateApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>Creditor</b>
     * </p>
     *
     * @param creditor
     *            Creditor ID
     */
    public void setCreditor( @Nullable final String creditor )
    {
        rememberChangedField("Creditor", this.creditor);
        this.creditor = creditor;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Mandate Refeference
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUseDate</b>
     * </p>
     *
     * @param sEPAMandateUseDate
     *            Date
     */
    public void setSEPAMandateUseDate( @Nullable final LocalDateTime sEPAMandateUseDate )
    {
        rememberChangedField("SEPAMandateUseDate", this.sEPAMandateUseDate);
        this.sEPAMandateUseDate = sEPAMandateUseDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUseObjectType</b>
     * </p>
     *
     * @param sEPAMandateUseObjectType
     *            Object Type
     */
    public void setSEPAMandateUseObjectType( @Nullable final String sEPAMandateUseObjectType )
    {
        rememberChangedField("SEPAMandateUseObjectType", this.sEPAMandateUseObjectType);
        this.sEPAMandateUseObjectType = sEPAMandateUseObjectType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandateUsePaymentDoc</b>
     * </p>
     *
     * @param sEPAMandateUsePaymentDoc
     *            Key
     */
    public void setSEPAMandateUsePaymentDoc( @Nullable final String sEPAMandateUsePaymentDoc )
    {
        rememberChangedField("SEPAMandateUsePaymentDoc", this.sEPAMandateUsePaymentDoc);
        this.sEPAMandateUsePaymentDoc = sEPAMandateUsePaymentDoc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SEPAMandateUsageSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Creditor", getCreditor());
        result.put("SEPAMandate", getSEPAMandate());
        result.put("SEPAMandateUseDate", getSEPAMandateUseDate());
        result.put("SEPAMandateUseObjectType", getSEPAMandateUseObjectType());
        result.put("SEPAMandateUsePaymentDoc", getSEPAMandateUsePaymentDoc());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SEPAMandateApplication", getSEPAMandateApplication());
        values.put("Creditor", getCreditor());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SEPAMandateUseDate", getSEPAMandateUseDate());
        values.put("SEPAMandateUseObjectType", getSEPAMandateUseObjectType());
        values.put("SEPAMandateUsePaymentDoc", getSEPAMandateUsePaymentDoc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SEPAMandateApplication") ) {
                final Object value = values.remove("SEPAMandateApplication");
                if( (value == null) || (!value.equals(getSEPAMandateApplication())) ) {
                    setSEPAMandateApplication(((String) value));
                }
            }
            if( values.containsKey("Creditor") ) {
                final Object value = values.remove("Creditor");
                if( (value == null) || (!value.equals(getCreditor())) ) {
                    setCreditor(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateUseDate") ) {
                final Object value = values.remove("SEPAMandateUseDate");
                if( (value == null) || (!value.equals(getSEPAMandateUseDate())) ) {
                    setSEPAMandateUseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SEPAMandateUseObjectType") ) {
                final Object value = values.remove("SEPAMandateUseObjectType");
                if( (value == null) || (!value.equals(getSEPAMandateUseObjectType())) ) {
                    setSEPAMandateUseObjectType(((String) value));
                }
            }
            if( values.containsKey("SEPAMandateUsePaymentDoc") ) {
                final Object value = values.remove("SEPAMandateUsePaymentDoc");
                if( (value == null) || (!value.equals(getSEPAMandateUsePaymentDoc())) ) {
                    setSEPAMandateUsePaymentDoc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SEPAMandateUsageField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SEPAMandateUsageField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SEPAMandateUsageField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SEPAMandateUsageField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SepaMandateManageInAccountsReceivableService.DEFAULT_SERVICE_PATH);
    }

}
