/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.selectable.SEPAMandateUsageSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage
 * SEPAMandateUsage} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class SEPAMandateUsageByKeyFluentHelper
    extends
    FluentHelperByKey<SEPAMandateUsageByKeyFluentHelper, SEPAMandateUsage, SEPAMandateUsageSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage
     * SEPAMandateUsage} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SEPAMandateUsage}
     * @param sEPAMandateUsePaymentDoc
     *            Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 70
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SEPAMandateUsage}
     * @param sEPAMandateUseObjectType
     *            Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param creditor
     *            Creditor ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandate
     *            Mandate Refeference
     *            <p>
     *            Constraints: Not nullable, Maximum length: 35
     *            </p>
     * @param sEPAMandateUseDate
     *            Date
     *            <p>
     *            Constraints: Not nullable, Precision: 7
     *            </p>
     */
    public SEPAMandateUsageByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String creditor,
        final String sEPAMandate,
        final LocalDateTime sEPAMandateUseDate,
        final String sEPAMandateUseObjectType,
        final String sEPAMandateUsePaymentDoc )
    {
        super(servicePath, entityCollection);
        this.key.put("Creditor", creditor);
        this.key.put("SEPAMandate", sEPAMandate);
        this.key.put("SEPAMandateUseDate", sEPAMandateUseDate);
        this.key.put("SEPAMandateUseObjectType", sEPAMandateUseObjectType);
        this.key.put("SEPAMandateUsePaymentDoc", sEPAMandateUsePaymentDoc);
    }

    @Override
    @Nonnull
    protected Class<SEPAMandateUsage> getEntityClass()
    {
        return SEPAMandateUsage.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
