/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage;

/**
 * Implementation of the {@link SepaMandateManageInAccountsReceivableServiceBatchChangeSet} interface, enabling you to
 * combine multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SepaMandateManageInAccountsReceivableService
 * SepaMandateManageInAccountsReceivableService}.
 *
 */
public class DefaultSepaMandateManageInAccountsReceivableServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SepaMandateManageInAccountsReceivableServiceBatch, SepaMandateManageInAccountsReceivableServiceBatchChangeSet>
    implements
    SepaMandateManageInAccountsReceivableServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SepaMandateManageInAccountsReceivableService service;

    @SuppressWarnings( "deprecation" )
    DefaultSepaMandateManageInAccountsReceivableServiceBatchChangeSet(
        @Nonnull final DefaultSepaMandateManageInAccountsReceivableServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SepaMandateManageInAccountsReceivableService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSepaMandateManageInAccountsReceivableServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SepaMandateManageInAccountsReceivableServiceBatchChangeSet createSEPAMandate(
        @Nonnull final SEPAMandate sEPAMandate )
    {
        return addRequestCreate(service::createSEPAMandate, sEPAMandate);
    }

    @Nonnull
    @Override
    public SepaMandateManageInAccountsReceivableServiceBatchChangeSet updateSEPAMandate(
        @Nonnull final SEPAMandate sEPAMandate )
    {
        return addRequestUpdate(service::updateSEPAMandate, sEPAMandate);
    }

    @Nonnull
    @Override
    public SepaMandateManageInAccountsReceivableServiceBatchChangeSet createSEPAMandateUsage(
        @Nonnull final SEPAMandateUsage sEPAMandateUsage )
    {
        return addRequestCreate(service::createSEPAMandateUsage, sEPAMandateUsage);
    }

}
