/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SepaMandateManageInAccountsReceivableService
 * SepaMandateManageInAccountsReceivableService}.
 *
 */
public interface SepaMandateManageInAccountsReceivableServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SepaMandateManageInAccountsReceivableServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SepaMandateManageInAccountsReceivableServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
     * SEPAMandate} entity and save it to the S/4HANA system.
     *
     * @param sEPAMandate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
     *            SEPAMandate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SepaMandateManageInAccountsReceivableServiceBatchChangeSet
        createSEPAMandate( @Nonnull final SEPAMandate sEPAMandate );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
     * SEPAMandate} entity and save it to the S/4HANA system.
     *
     * @param sEPAMandate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandate
     *            SEPAMandate} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SepaMandateManageInAccountsReceivableServiceBatchChangeSet
        updateSEPAMandate( @Nonnull final SEPAMandate sEPAMandate );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage
     * SEPAMandateUsage} entity and save it to the S/4HANA system.
     *
     * @param sEPAMandateUsage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.sepamandatemanageinaccountsreceivable.SEPAMandateUsage
     *            SEPAMandateUsage} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SepaMandateManageInAccountsReceivableServiceBatchChangeSet
        createSEPAMandateUsage( @Nonnull final SEPAMandateUsage sEPAMandateUsage );

}
