/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfItemUserStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
 * ServiceConfItemUserStatus} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ServiceConfItemUserStatusByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceConfItemUserStatusByKeyFluentHelper, ServiceConfItemUserStatus, ServiceConfItemUserStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceConfItemUserStatus}
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceConfItemUserStatus}
     * @param srvcConfItemUserStatus
     *            Object Status
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public ServiceConfItemUserStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcConfItemUserStatus )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("ServiceConfirmationItem", serviceConfirmationItem);
        this.key.put("SrvcConfItemUserStatus", srvcConfItemUserStatus);
    }

    @Override
    @Nonnull
    protected Class<ServiceConfItemUserStatus> getEntityClass()
    {
        return ServiceConfItemUserStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
