/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfPersonRespField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfPersonRespSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Employee Resp. for Service Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceConfPersonRespType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceConfPersonResp extends VdmEntity<ServiceConfPersonResp>
{

    /**
     * Selector for all available fields of ServiceConfPersonResp.
     *
     */
    public final static ServiceConfPersonRespSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static ServiceConfPersonRespField<String> SERVICE_CONFIRMATION =
        new ServiceConfPersonRespField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceConfPersonRespField<String> PERSON_RESPONSIBLE =
        new ServiceConfPersonRespField<String>("PersonResponsible");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @return Main Partner (For Ambiguous Partner Functions)
     */
    @SerializedName( "CustMgmtPartnerIsMainPartner" )
    @JsonProperty( "CustMgmtPartnerIsMainPartner" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CustMgmtPartnerIsMainPartner" )
    private Boolean custMgmtPartnerIsMainPartner;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtPartnerIsMainPartner</b> field to query operations.
     *
     */
    public final static ServiceConfPersonRespField<Boolean> CUST_MGMT_PARTNER_IS_MAIN_PARTNER =
        new ServiceConfPersonRespField<Boolean>("CustMgmtPartnerIsMainPartner");

    @Nonnull
    @Override
    public Class<ServiceConfPersonResp> getType()
    {
        return ServiceConfPersonResp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Business Partner Number
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @param custMgmtPartnerIsMainPartner
     *            Main Partner (For Ambiguous Partner Functions)
     */
    public void setCustMgmtPartnerIsMainPartner( @Nullable final Boolean custMgmtPartnerIsMainPartner )
    {
        rememberChangedField("CustMgmtPartnerIsMainPartner", this.custMgmtPartnerIsMainPartner);
        this.custMgmtPartnerIsMainPartner = custMgmtPartnerIsMainPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceConfPersonResp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("PersonResponsible", getPersonResponsible());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("CustMgmtPartnerIsMainPartner", getCustMgmtPartnerIsMainPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("CustMgmtPartnerIsMainPartner") ) {
                final Object value = values.remove("CustMgmtPartnerIsMainPartner");
                if( (value == null) || (!value.equals(getCustMgmtPartnerIsMainPartner())) ) {
                    setCustMgmtPartnerIsMainPartner(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceConfPersonRespField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceConfPersonRespField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceConfPersonRespField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceConfPersonRespField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

}
