/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfRefObjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfRefObjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Reference Objects of Srvc Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceConfRefObjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceConfRefObject extends VdmEntity<ServiceConfRefObject>
{

    /**
     * Selector for all available fields of ServiceConfRefObject.
     *
     */
    public final static ServiceConfRefObjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static ServiceConfRefObjectField<String> SERVICE_CONFIRMATION =
        new ServiceConfRefObjectField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @Key
    @SerializedName( "ServiceReferenceEquipment" )
    @JsonProperty( "ServiceReferenceEquipment" )
    @Nullable
    @ODataField( odataName = "ServiceReferenceEquipment" )
    private String serviceReferenceEquipment;
    /**
     * Use with available fluent helpers to apply the <b>ServiceReferenceEquipment</b> field to query operations.
     *
     */
    public final static ServiceConfRefObjectField<String> SERVICE_REFERENCE_EQUIPMENT =
        new ServiceConfRefObjectField<String>("ServiceReferenceEquipment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @Key
    @SerializedName( "ServiceRefFunctionalLocation" )
    @JsonProperty( "ServiceRefFunctionalLocation" )
    @Nullable
    @ODataField( odataName = "ServiceRefFunctionalLocation" )
    private String serviceRefFunctionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceRefFunctionalLocation</b> field to query operations.
     *
     */
    public final static ServiceConfRefObjectField<String> SERVICE_REF_FUNCTIONAL_LOCATION =
        new ServiceConfRefObjectField<String>("ServiceRefFunctionalLocation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @return Main Reference Object
     */
    @SerializedName( "SrvcRefObjIsMainObject" )
    @JsonProperty( "SrvcRefObjIsMainObject" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SrvcRefObjIsMainObject" )
    private Boolean srvcRefObjIsMainObject;
    /**
     * Use with available fluent helpers to apply the <b>SrvcRefObjIsMainObject</b> field to query operations.
     *
     */
    public final static ServiceConfRefObjectField<Boolean> SRVC_REF_OBJ_IS_MAIN_OBJECT =
        new ServiceConfRefObjectField<Boolean>("SrvcRefObjIsMainObject");

    @Nonnull
    @Override
    public Class<ServiceConfRefObject> getType()
    {
        return ServiceConfRefObject.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ServiceReferenceEquipment</b>
     * </p>
     *
     * @param serviceReferenceEquipment
     *            Equipment Number
     */
    public void setServiceReferenceEquipment( @Nullable final String serviceReferenceEquipment )
    {
        rememberChangedField("ServiceReferenceEquipment", this.serviceReferenceEquipment);
        this.serviceReferenceEquipment = serviceReferenceEquipment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceRefFunctionalLocation</b>
     * </p>
     *
     * @param serviceRefFunctionalLocation
     *            Functional Location
     */
    public void setServiceRefFunctionalLocation( @Nullable final String serviceRefFunctionalLocation )
    {
        rememberChangedField("ServiceRefFunctionalLocation", this.serviceRefFunctionalLocation);
        this.serviceRefFunctionalLocation = serviceRefFunctionalLocation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcRefObjIsMainObject</b>
     * </p>
     *
     * @param srvcRefObjIsMainObject
     *            Main Reference Object
     */
    public void setSrvcRefObjIsMainObject( @Nullable final Boolean srvcRefObjIsMainObject )
    {
        rememberChangedField("SrvcRefObjIsMainObject", this.srvcRefObjIsMainObject);
        this.srvcRefObjIsMainObject = srvcRefObjIsMainObject;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceConfRefObject";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        result.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("ServiceReferenceEquipment", getServiceReferenceEquipment());
        values.put("ServiceRefFunctionalLocation", getServiceRefFunctionalLocation());
        values.put("SrvcRefObjIsMainObject", getSrvcRefObjIsMainObject());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("ServiceReferenceEquipment") ) {
                final Object value = values.remove("ServiceReferenceEquipment");
                if( (value == null) || (!value.equals(getServiceReferenceEquipment())) ) {
                    setServiceReferenceEquipment(((String) value));
                }
            }
            if( values.containsKey("ServiceRefFunctionalLocation") ) {
                final Object value = values.remove("ServiceRefFunctionalLocation");
                if( (value == null) || (!value.equals(getServiceRefFunctionalLocation())) ) {
                    setServiceRefFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("SrvcRefObjIsMainObject") ) {
                final Object value = values.remove("SrvcRefObjIsMainObject");
                if( (value == null) || (!value.equals(getSrvcRefObjIsMainObject())) ) {
                    setSrvcRefObjIsMainObject(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceConfRefObjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceConfRefObjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceConfRefObjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceConfRefObjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

}
