/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfRefObjectSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
 * ServiceConfRefObject} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ServiceConfRefObjectByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceConfRefObjectByKeyFluentHelper, ServiceConfRefObject, ServiceConfRefObjectSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceConfRefObject}
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceConfRefObject}
     * @param serviceRefFunctionalLocation
     *            Functional Location
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param serviceReferenceEquipment
     *            Equipment Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 18
     *            </p>
     */
    public ServiceConfRefObjectByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceConfirmation,
        final String serviceReferenceEquipment,
        final String serviceRefFunctionalLocation )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("ServiceReferenceEquipment", serviceReferenceEquipment);
        this.key.put("ServiceRefFunctionalLocation", serviceRefFunctionalLocation);
    }

    @Override
    @Nonnull
    protected Class<ServiceConfRefObject> getEntityClass()
    {
        return ServiceConfRefObject.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
