/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfirmationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfirmationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfirmationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Confirmation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceConfirmationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceConfirmation extends VdmEntity<ServiceConfirmation>
{

    /**
     * Selector for all available fields of ServiceConfirmation.
     *
     */
    public final static ServiceConfirmationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_CONFIRMATION =
        new ServiceConfirmationField<String>("ServiceConfirmation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceConfirmationType" )
    @JsonProperty( "ServiceConfirmationType" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationType" )
    private String serviceConfirmationType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationType</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_CONFIRMATION_TYPE =
        new ServiceConfirmationField<String>("ServiceConfirmationType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceConfirmationUUID" )
    @JsonProperty( "ServiceConfirmationUUID" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationUUID" )
    private UUID serviceConfirmationUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationUUID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<UUID> SERVICE_CONFIRMATION_UUID =
        new ServiceConfirmationField<UUID>("ServiceConfirmationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "ServiceConfirmationDescription" )
    @JsonProperty( "ServiceConfirmationDescription" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationDescription" )
    private String serviceConfirmationDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationDescription</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_CONFIRMATION_DESCRIPTION =
        new ServiceConfirmationField<String>("ServiceConfirmationDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_OBJECT_TYPE =
        new ServiceConfirmationField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> LANGUAGE = new ServiceConfirmationField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @return Activity Priority
     */
    @SerializedName( "ServiceDocumentPriority" )
    @JsonProperty( "ServiceDocumentPriority" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentPriority" )
    private String serviceDocumentPriority;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentPriority</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_DOCUMENT_PRIORITY =
        new ServiceConfirmationField<String>("ServiceDocumentPriority");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @return Service Request Start Date
     */
    @SerializedName( "RequestedServiceStartDateTime" )
    @JsonProperty( "RequestedServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<ZonedDateTime> REQUESTED_SERVICE_START_DATE_TIME =
        new ServiceConfirmationField<ZonedDateTime>("RequestedServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @return Service Request Due Date
     */
    @SerializedName( "RequestedServiceEndDateTime" )
    @JsonProperty( "RequestedServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime requestedServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RequestedServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<ZonedDateTime> REQUESTED_SERVICE_END_DATE_TIME =
        new ServiceConfirmationField<ZonedDateTime>("RequestedServiceEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Sold-To Party's External Reference Number
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new ServiceConfirmationField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Reference Document Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new ServiceConfirmationField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsCompleted</b>
     * </p>
     *
     * @return The serviceConfirmationIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceConfirmationIsCompleted" )
    @JsonProperty( "ServiceConfirmationIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationIsCompleted" )
    private String serviceConfirmationIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_CONFIRMATION_IS_COMPLETED =
        new ServiceConfirmationField<String>("ServiceConfirmationIsCompleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsCanceled</b>
     * </p>
     *
     * @return Status Is Active
     */
    @SerializedName( "ServiceConfirmationIsCanceled" )
    @JsonProperty( "ServiceConfirmationIsCanceled" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ServiceConfirmationIsCanceled" )
    private Boolean serviceConfirmationIsCanceled;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationIsCanceled</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<Boolean> SERVICE_CONFIRMATION_IS_CANCELED =
        new ServiceConfirmationField<Boolean>("ServiceConfirmationIsCanceled");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_ORGANIZATION =
        new ServiceConfirmationField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> DISTRIBUTION_CHANNEL =
        new ServiceConfirmationField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> DIVISION = new ServiceConfirmationField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_OFFICE =
        new ServiceConfirmationField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_GROUP =
        new ServiceConfirmationField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SOLD_TO_PARTY =
        new ServiceConfirmationField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SHIP_TO_PARTY =
        new ServiceConfirmationField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> BILL_TO_PARTY =
        new ServiceConfirmationField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> PAYER_PARTY =
        new ServiceConfirmationField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> CONTACT_PERSON =
        new ServiceConfirmationField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceOrder" )
    @JsonProperty( "ReferenceServiceOrder" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceOrder" )
    private String referenceServiceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> REFERENCE_SERVICE_ORDER =
        new ServiceConfirmationField<String>("ReferenceServiceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsFinal</b>
     * </p>
     *
     * @return Final service confirmation for the related service order
     */
    @SerializedName( "ServiceConfirmationIsFinal" )
    @JsonProperty( "ServiceConfirmationIsFinal" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationIsFinal" )
    private String serviceConfirmationIsFinal;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationIsFinal</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_CONFIRMATION_IS_FINAL =
        new ServiceConfirmationField<String>("ServiceConfirmationIsFinal");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> TRANSACTION_CURRENCY =
        new ServiceConfirmationField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SHIPPING_CONDITION =
        new ServiceConfirmationField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceConfirmationField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceConfirmationField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceConfirmationField<String>("RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @return Sales Organization ID
     */
    @SerializedName( "SalesOrganizationOrgUnitID" )
    @JsonProperty( "SalesOrganizationOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesOrganizationOrgUnitID" )
    private String salesOrganizationOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_ORGANIZATION_ORG_UNIT_ID =
        new ServiceConfirmationField<String>("SalesOrganizationOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrganization</b>
     * </p>
     *
     * @return Service Organization
     */
    @SerializedName( "ServiceOrganization" )
    @JsonProperty( "ServiceOrganization" )
    @Nullable
    @ODataField( odataName = "ServiceOrganization" )
    private String serviceOrganization;
    /**
     * Use with available fluent helpers to apply the <b>ServiceOrganization</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SERVICE_ORGANIZATION =
        new ServiceConfirmationField<String>("ServiceOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOfficeOrgUnitID" )
    @JsonProperty( "SalesOfficeOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesOfficeOrgUnitID" )
    private String salesOfficeOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesOfficeOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_OFFICE_ORG_UNIT_ID =
        new ServiceConfirmationField<String>("SalesOfficeOrgUnitID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroupOrgUnitID" )
    @JsonProperty( "SalesGroupOrgUnitID" )
    @Nullable
    @ODataField( odataName = "SalesGroupOrgUnitID" )
    private String salesGroupOrgUnitID;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroupOrgUnitID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationField<String> SALES_GROUP_ORG_UNIT_ID =
        new ServiceConfirmationField<String>("SalesGroupOrgUnitID");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceConfirmation</b> to multiple <b>SrvcConfAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfAppointment> toAppointment;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceConfirmation</b> to multiple <b>SrvcConfDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfDuration> toDuration;
    /**
     * Navigation property <b>to_Item</b> for <b>ServiceConfirmation</b> to multiple <b>ServiceConfirmationItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfirmationItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceConfirmation</b> to multiple <b>SrvcConfPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfPartner> toPartner;
    /**
     * Navigation property <b>to_PersonResponsible</b> for <b>ServiceConfirmation</b> to multiple
     * <b>ServiceConfPersonResp</b>.
     *
     */
    @SerializedName( "to_PersonResponsible" )
    @JsonProperty( "to_PersonResponsible" )
    @ODataField( odataName = "to_PersonResponsible" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfPersonResp> toPersonResponsible;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceConfirmation</b> to multiple
     * <b>ServiceConfPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceConfirmation</b> to multiple
     * <b>ServiceConfRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceConfUserStatus</b> for <b>ServiceConfirmation</b> to multiple
     * <b>ServiceConfUserStatus</b>.
     *
     */
    @SerializedName( "to_ServiceConfUserStatus" )
    @JsonProperty( "to_ServiceConfUserStatus" )
    @ODataField( odataName = "to_ServiceConfUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfUserStatus> toServiceConfUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceConfirmation</b> to multiple <b>ServiceConfirmationText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfirmationText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<SrvcConfAppointment> TO_APPOINTMENT =
        new ServiceConfirmationLink<SrvcConfAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<SrvcConfDuration> TO_DURATION =
        new ServiceConfirmationLink<SrvcConfDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfirmationItem> TO_ITEM =
        new ServiceConfirmationLink<ServiceConfirmationItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<SrvcConfPartner> TO_PARTNER =
        new ServiceConfirmationLink<SrvcConfPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PersonResponsible</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfPersonResp> TO_PERSON_RESPONSIBLE =
        new ServiceConfirmationLink<ServiceConfPersonResp>("to_PersonResponsible");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfPriceElement> TO_PRICING_ELEMENT =
        new ServiceConfirmationLink<ServiceConfPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfRefObject> TO_REFERENCE_OBJECT =
        new ServiceConfirmationLink<ServiceConfRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceConfUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfUserStatus> TO_SERVICE_CONF_USER_STATUS =
        new ServiceConfirmationLink<ServiceConfUserStatus>("to_ServiceConfUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationLink<ServiceConfirmationText> TO_TEXT =
        new ServiceConfirmationLink<ServiceConfirmationText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceConfirmation> getType()
    {
        return ServiceConfirmation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationType</b>
     * </p>
     *
     * @param serviceConfirmationType
     *            Business Transaction Type
     */
    public void setServiceConfirmationType( @Nullable final String serviceConfirmationType )
    {
        rememberChangedField("ServiceConfirmationType", this.serviceConfirmationType);
        this.serviceConfirmationType = serviceConfirmationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationUUID</b>
     * </p>
     *
     * @param serviceConfirmationUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceConfirmationUUID( @Nullable final UUID serviceConfirmationUUID )
    {
        rememberChangedField("ServiceConfirmationUUID", this.serviceConfirmationUUID);
        this.serviceConfirmationUUID = serviceConfirmationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationDescription</b>
     * </p>
     *
     * @param serviceConfirmationDescription
     *            Transaction Description
     */
    public void setServiceConfirmationDescription( @Nullable final String serviceConfirmationDescription )
    {
        rememberChangedField("ServiceConfirmationDescription", this.serviceConfirmationDescription);
        this.serviceConfirmationDescription = serviceConfirmationDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentPriority</b>
     * </p>
     *
     * @param serviceDocumentPriority
     *            Activity Priority
     */
    public void setServiceDocumentPriority( @Nullable final String serviceDocumentPriority )
    {
        rememberChangedField("ServiceDocumentPriority", this.serviceDocumentPriority);
        this.serviceDocumentPriority = serviceDocumentPriority;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceStartDateTime</b>
     * </p>
     *
     * @param requestedServiceStartDateTime
     *            Service Request Start Date
     */
    public void setRequestedServiceStartDateTime( @Nullable final ZonedDateTime requestedServiceStartDateTime )
    {
        rememberChangedField("RequestedServiceStartDateTime", this.requestedServiceStartDateTime);
        this.requestedServiceStartDateTime = requestedServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedServiceEndDateTime</b>
     * </p>
     *
     * @param requestedServiceEndDateTime
     *            Service Request Due Date
     */
    public void setRequestedServiceEndDateTime( @Nullable final ZonedDateTime requestedServiceEndDateTime )
    {
        rememberChangedField("RequestedServiceEndDateTime", this.requestedServiceEndDateTime);
        this.requestedServiceEndDateTime = requestedServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Sold-To Party's External Reference Number
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Reference Document Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsCompleted</b>
     * </p>
     *
     * @param serviceConfirmationIsCompleted
     *            The serviceConfirmationIsCompleted to set.
     */
    public void setServiceConfirmationIsCompleted( @Nullable final String serviceConfirmationIsCompleted )
    {
        rememberChangedField("ServiceConfirmationIsCompleted", this.serviceConfirmationIsCompleted);
        this.serviceConfirmationIsCompleted = serviceConfirmationIsCompleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsCanceled</b>
     * </p>
     *
     * @param serviceConfirmationIsCanceled
     *            Status Is Active
     */
    public void setServiceConfirmationIsCanceled( @Nullable final Boolean serviceConfirmationIsCanceled )
    {
        rememberChangedField("ServiceConfirmationIsCanceled", this.serviceConfirmationIsCanceled);
        this.serviceConfirmationIsCanceled = serviceConfirmationIsCanceled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @param referenceServiceOrder
     *            Transaction ID
     */
    public void setReferenceServiceOrder( @Nullable final String referenceServiceOrder )
    {
        rememberChangedField("ReferenceServiceOrder", this.referenceServiceOrder);
        this.referenceServiceOrder = referenceServiceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationIsFinal</b>
     * </p>
     *
     * @param serviceConfirmationIsFinal
     *            Final service confirmation for the related service order
     */
    public void setServiceConfirmationIsFinal( @Nullable final String serviceConfirmationIsFinal )
    {
        rememberChangedField("ServiceConfirmationIsFinal", this.serviceConfirmationIsFinal);
        this.serviceConfirmationIsFinal = serviceConfirmationIsFinal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationOrgUnitID</b>
     * </p>
     *
     * @param salesOrganizationOrgUnitID
     *            Sales Organization ID
     */
    public void setSalesOrganizationOrgUnitID( @Nullable final String salesOrganizationOrgUnitID )
    {
        rememberChangedField("SalesOrganizationOrgUnitID", this.salesOrganizationOrgUnitID);
        this.salesOrganizationOrgUnitID = salesOrganizationOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>ServiceOrganization</b>
     * </p>
     *
     * @param serviceOrganization
     *            Service Organization
     */
    public void setServiceOrganization( @Nullable final String serviceOrganization )
    {
        rememberChangedField("ServiceOrganization", this.serviceOrganization);
        this.serviceOrganization = serviceOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesOfficeOrgUnitID</b>
     * </p>
     *
     * @param salesOfficeOrgUnitID
     *            Sales Office
     */
    public void setSalesOfficeOrgUnitID( @Nullable final String salesOfficeOrgUnitID )
    {
        rememberChangedField("SalesOfficeOrgUnitID", this.salesOfficeOrgUnitID);
        this.salesOfficeOrgUnitID = salesOfficeOrgUnitID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroupOrgUnitID</b>
     * </p>
     *
     * @param salesGroupOrgUnitID
     *            Sales Group
     */
    public void setSalesGroupOrgUnitID( @Nullable final String salesGroupOrgUnitID )
    {
        rememberChangedField("SalesGroupOrgUnitID", this.salesGroupOrgUnitID);
        this.salesGroupOrgUnitID = salesGroupOrgUnitID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceConfirmation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("ServiceConfirmationType", getServiceConfirmationType());
        values.put("ServiceConfirmationUUID", getServiceConfirmationUUID());
        values.put("ServiceConfirmationDescription", getServiceConfirmationDescription());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("Language", getLanguage());
        values.put("ServiceDocumentPriority", getServiceDocumentPriority());
        values.put("RequestedServiceStartDateTime", getRequestedServiceStartDateTime());
        values.put("RequestedServiceEndDateTime", getRequestedServiceEndDateTime());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("ServiceConfirmationIsCompleted", getServiceConfirmationIsCompleted());
        values.put("ServiceConfirmationIsCanceled", getServiceConfirmationIsCanceled());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ContactPerson", getContactPerson());
        values.put("ReferenceServiceOrder", getReferenceServiceOrder());
        values.put("ServiceConfirmationIsFinal", getServiceConfirmationIsFinal());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ShippingCondition", getShippingCondition());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("SalesOrganizationOrgUnitID", getSalesOrganizationOrgUnitID());
        values.put("ServiceOrganization", getServiceOrganization());
        values.put("SalesOfficeOrgUnitID", getSalesOfficeOrgUnitID());
        values.put("SalesGroupOrgUnitID", getSalesGroupOrgUnitID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationType") ) {
                final Object value = values.remove("ServiceConfirmationType");
                if( (value == null) || (!value.equals(getServiceConfirmationType())) ) {
                    setServiceConfirmationType(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationUUID") ) {
                final Object value = values.remove("ServiceConfirmationUUID");
                if( (value == null) || (!value.equals(getServiceConfirmationUUID())) ) {
                    setServiceConfirmationUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceConfirmationDescription") ) {
                final Object value = values.remove("ServiceConfirmationDescription");
                if( (value == null) || (!value.equals(getServiceConfirmationDescription())) ) {
                    setServiceConfirmationDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentPriority") ) {
                final Object value = values.remove("ServiceDocumentPriority");
                if( (value == null) || (!value.equals(getServiceDocumentPriority())) ) {
                    setServiceDocumentPriority(((String) value));
                }
            }
            if( values.containsKey("RequestedServiceStartDateTime") ) {
                final Object value = values.remove("RequestedServiceStartDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceStartDateTime())) ) {
                    setRequestedServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RequestedServiceEndDateTime") ) {
                final Object value = values.remove("RequestedServiceEndDateTime");
                if( (value == null) || (!value.equals(getRequestedServiceEndDateTime())) ) {
                    setRequestedServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServiceConfirmationIsCompleted") ) {
                final Object value = values.remove("ServiceConfirmationIsCompleted");
                if( (value == null) || (!value.equals(getServiceConfirmationIsCompleted())) ) {
                    setServiceConfirmationIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationIsCanceled") ) {
                final Object value = values.remove("ServiceConfirmationIsCanceled");
                if( (value == null) || (!value.equals(getServiceConfirmationIsCanceled())) ) {
                    setServiceConfirmationIsCanceled(((Boolean) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceOrder") ) {
                final Object value = values.remove("ReferenceServiceOrder");
                if( (value == null) || (!value.equals(getReferenceServiceOrder())) ) {
                    setReferenceServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationIsFinal") ) {
                final Object value = values.remove("ServiceConfirmationIsFinal");
                if( (value == null) || (!value.equals(getServiceConfirmationIsFinal())) ) {
                    setServiceConfirmationIsFinal(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
            if( values.containsKey("SalesOrganizationOrgUnitID") ) {
                final Object value = values.remove("SalesOrganizationOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOrganizationOrgUnitID())) ) {
                    setSalesOrganizationOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("ServiceOrganization") ) {
                final Object value = values.remove("ServiceOrganization");
                if( (value == null) || (!value.equals(getServiceOrganization())) ) {
                    setServiceOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOfficeOrgUnitID") ) {
                final Object value = values.remove("SalesOfficeOrgUnitID");
                if( (value == null) || (!value.equals(getSalesOfficeOrgUnitID())) ) {
                    setSalesOfficeOrgUnitID(((String) value));
                }
            }
            if( values.containsKey("SalesGroupOrgUnitID") ) {
                final Object value = values.remove("SalesGroupOrgUnitID");
                if( (value == null) || (!value.equals(getSalesGroupOrgUnitID())) ) {
                    setSalesGroupOrgUnitID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcConfAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcConfDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfirmationItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new ServiceConfirmationItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcConfPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PersonResponsible") ) {
                final Object value = (values).remove("to_PersonResponsible");
                if( value instanceof Iterable ) {
                    if( toPersonResponsible == null ) {
                        toPersonResponsible = Lists.newArrayList();
                    } else {
                        toPersonResponsible = Lists.newArrayList(toPersonResponsible);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfPersonResp entity;
                        if( toPersonResponsible.size() > i ) {
                            entity = toPersonResponsible.get(i);
                        } else {
                            entity = new ServiceConfPersonResp();
                            toPersonResponsible.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceConfPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceConfRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceConfUserStatus") ) {
                final Object value = (values).remove("to_ServiceConfUserStatus");
                if( value instanceof Iterable ) {
                    if( toServiceConfUserStatus == null ) {
                        toServiceConfUserStatus = Lists.newArrayList();
                    } else {
                        toServiceConfUserStatus = Lists.newArrayList(toServiceConfUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfUserStatus entity;
                        if( toServiceConfUserStatus.size() > i ) {
                            entity = toServiceConfUserStatus.get(i);
                        } else {
                            entity = new ServiceConfUserStatus();
                            toServiceConfUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfirmationText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceConfirmationText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceConfirmationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceConfirmationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceConfirmationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceConfirmationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPersonResponsible != null ) {
            (values).put("to_PersonResponsible", toPersonResponsible);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceConfUserStatus != null ) {
            (values).put("to_ServiceConfUserStatus", toServiceConfUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcConfAppointment</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfAppointment</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcConfAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcConfAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcConfAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcConfAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcConfAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfAppointment</b> entities.
     */
    public void addAppointment( SrvcConfAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcConfDuration</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfDuration</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcConfDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfDuration</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcConfDuration</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcConfDuration</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SrvcConfDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcConfDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfDuration</b> entities. This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfDuration</b> entities.
     */
    public void addDuration( SrvcConfDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfirmationItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfirmationItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", ServiceConfirmationItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfirmationItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>ServiceConfirmationItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfirmationItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfirmationItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfirmationItem</b> entities.
     */
    public void setItem( @Nonnull final List<ServiceConfirmationItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfirmationItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfirmationItem</b> entities.
     */
    public void addItem( ServiceConfirmationItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcConfPartner</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcConfPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcConfPartner</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcConfPartner</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SrvcConfPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcConfPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfPartner</b> entities. This corresponds to the OData navigation
     * property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfPartner</b> entities.
     */
    public void addPartner( SrvcConfPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfPersonResp</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PersonResponsible</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfPersonResp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfPersonResp> fetchPersonResponsible()
    {
        return fetchFieldAsList("to_PersonResponsible", ServiceConfPersonResp.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfPersonResp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfPersonResp> getPersonResponsibleOrFetch()
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = fetchPersonResponsible();
        }
        return toPersonResponsible;
    }

    /**
     * Retrieval of associated <b>ServiceConfPersonResp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PersonResponsible</b> is already loaded, the result will
     *         contain the <b>ServiceConfPersonResp</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfPersonResp>> getPersonResponsibleIfPresent()
    {
        return Option.of(toPersonResponsible);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfPersonResp</b> entities for the loaded navigation property
     * <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfPersonResp</b> entities.
     */
    public void setPersonResponsible( @Nonnull final List<ServiceConfPersonResp> value )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.clear();
        toPersonResponsible.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfPersonResp</b> entities. This corresponds to the OData
     * navigation property <b>to_PersonResponsible</b>.
     * <p>
     * If the navigation property <b>to_PersonResponsible</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfPersonResp</b> entities.
     */
    public void addPersonResponsible( ServiceConfPersonResp... entity )
    {
        if( toPersonResponsible == null ) {
            toPersonResponsible = Lists.newArrayList();
        }
        toPersonResponsible.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfPriceElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceConfPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceConfPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceConfPriceElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceConfPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfPriceElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfPriceElement</b> entities.
     */
    public void addPricingElement( ServiceConfPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfRefObject</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceConfRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceConfRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceConfRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceConfRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfRefObject</b> entities.
     */
    public void addReferenceObject( ServiceConfRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfUserStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ServiceConfUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfUserStatus> fetchServiceConfUserStatus()
    {
        return fetchFieldAsList("to_ServiceConfUserStatus", ServiceConfUserStatus.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceConfUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceConfUserStatus</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfUserStatus> getServiceConfUserStatusOrFetch()
    {
        if( toServiceConfUserStatus == null ) {
            toServiceConfUserStatus = fetchServiceConfUserStatus();
        }
        return toServiceConfUserStatus;
    }

    /**
     * Retrieval of associated <b>ServiceConfUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ServiceConfUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceConfUserStatus</b> is already loaded, the result
     *         will contain the <b>ServiceConfUserStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfUserStatus>> getServiceConfUserStatusIfPresent()
    {
        return Option.of(toServiceConfUserStatus);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfUserStatus</b> entities for the loaded navigation property
     * <b>to_ServiceConfUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceConfUserStatus</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfUserStatus</b> entities.
     */
    public void setServiceConfUserStatus( @Nonnull final List<ServiceConfUserStatus> value )
    {
        if( toServiceConfUserStatus == null ) {
            toServiceConfUserStatus = Lists.newArrayList();
        }
        toServiceConfUserStatus.clear();
        toServiceConfUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_ServiceConfUserStatus</b>.
     * <p>
     * If the navigation property <b>to_ServiceConfUserStatus</b> of a queried <b>ServiceConfirmation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfUserStatus</b> entities.
     */
    public void addServiceConfUserStatus( ServiceConfUserStatus... entity )
    {
        if( toServiceConfUserStatus == null ) {
            toServiceConfUserStatus = Lists.newArrayList();
        }
        toServiceConfUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfirmationText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfirmationText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceConfirmationText.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfirmationText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceConfirmationText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfirmationText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfirmationText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfirmationText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceConfirmationText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfirmationText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfirmationText</b> entities.
     */
    public void addText( ServiceConfirmationText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceConfirmation instances.
     *
     */
    public final static class ServiceConfirmationBuilder
    {

        private List<SrvcConfAppointment> toAppointment = Lists.newArrayList();
        private List<SrvcConfDuration> toDuration = Lists.newArrayList();
        private List<ServiceConfirmationItem> toItem = Lists.newArrayList();
        private List<SrvcConfPartner> toPartner = Lists.newArrayList();
        private List<ServiceConfPersonResp> toPersonResponsible = Lists.newArrayList();
        private List<ServiceConfPriceElement> toPricingElement = Lists.newArrayList();
        private List<ServiceConfRefObject> toReferenceObject = Lists.newArrayList();
        private List<ServiceConfUserStatus> toServiceConfUserStatus = Lists.newArrayList();
        private List<ServiceConfirmationText> toText = Lists.newArrayList();

        private ServiceConfirmation.ServiceConfirmationBuilder toAppointment( final List<SrvcConfAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceConfirmation</b> to multiple
         * <b>SrvcConfAppointment</b>.
         *
         * @param value
         *            The SrvcConfAppointments to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder appointment( SrvcConfAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toDuration( final List<SrvcConfDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceConfirmation</b> to multiple <b>SrvcConfDuration</b>.
         *
         * @param value
         *            The SrvcConfDurations to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder duration( SrvcConfDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toItem( final List<ServiceConfirmationItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>ServiceConfirmation</b> to multiple <b>ServiceConfirmationItem</b>.
         *
         * @param value
         *            The ServiceConfirmationItems to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder item( ServiceConfirmationItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toPartner( final List<SrvcConfPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceConfirmation</b> to multiple <b>SrvcConfPartner</b>.
         *
         * @param value
         *            The SrvcConfPartners to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder partner( SrvcConfPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toPersonResponsible(
            final List<ServiceConfPersonResp> value )
        {
            toPersonResponsible.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PersonResponsible</b> for <b>ServiceConfirmation</b> to multiple
         * <b>ServiceConfPersonResp</b>.
         *
         * @param value
         *            The ServiceConfPersonResps to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder personResponsible( ServiceConfPersonResp... value )
        {
            return toPersonResponsible(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toPricingElement(
            final List<ServiceConfPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceConfirmation</b> to multiple
         * <b>ServiceConfPriceElement</b>.
         *
         * @param value
         *            The ServiceConfPriceElements to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder pricingElement( ServiceConfPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toReferenceObject(
            final List<ServiceConfRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceConfirmation</b> to multiple
         * <b>ServiceConfRefObject</b>.
         *
         * @param value
         *            The ServiceConfRefObjects to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder referenceObject( ServiceConfRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toServiceConfUserStatus(
            final List<ServiceConfUserStatus> value )
        {
            toServiceConfUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ServiceConfUserStatus</b> for <b>ServiceConfirmation</b> to multiple
         * <b>ServiceConfUserStatus</b>.
         *
         * @param value
         *            The ServiceConfUserStatuss to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder serviceConfUserStatus( ServiceConfUserStatus... value )
        {
            return toServiceConfUserStatus(Lists.newArrayList(value));
        }

        private ServiceConfirmation.ServiceConfirmationBuilder toText( final List<ServiceConfirmationText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceConfirmation</b> to multiple <b>ServiceConfirmationText</b>.
         *
         * @param value
         *            The ServiceConfirmationTexts to build this ServiceConfirmation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmation.ServiceConfirmationBuilder text( ServiceConfirmationText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
