/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfirmationItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfirmationItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfirmationItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfirmationItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Confirmation Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceConfirmationItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceConfirmationItem extends VdmEntity<ServiceConfirmationItem>
{

    /**
     * Selector for all available fields of ServiceConfirmationItem.
     *
     */
    public final static ServiceConfirmationItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_CONFIRMATION =
        new ServiceConfirmationItemField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceConfirmationItem" )
    @JsonProperty( "ServiceConfirmationItem" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationItem" )
    private String serviceConfirmationItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_CONFIRMATION_ITEM =
        new ServiceConfirmationItemField<String>("ServiceConfirmationItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItemUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "ServiceConfirmationItemUUID" )
    @JsonProperty( "ServiceConfirmationItemUUID" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationItemUUID" )
    private UUID serviceConfirmationItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationItemUUID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<UUID> SERVICE_CONFIRMATION_ITEM_UUID =
        new ServiceConfirmationItemField<UUID>("ServiceConfirmationItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ServiceConfItemDescription" )
    @JsonProperty( "ServiceConfItemDescription" )
    @Nullable
    @ODataField( odataName = "ServiceConfItemDescription" )
    private String serviceConfItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfItemDescription</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_CONF_ITEM_DESCRIPTION =
        new ServiceConfirmationItemField<String>("ServiceConfItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @return Business Trans. Cat.
     */
    @SerializedName( "ServiceObjectType" )
    @JsonProperty( "ServiceObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceObjectType" )
    private String serviceObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceObjectType</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_OBJECT_TYPE =
        new ServiceConfirmationItemField<String>("ServiceObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @return CRM Item Object Type
     */
    @SerializedName( "ServiceDocumentItemObjectType" )
    @JsonProperty( "ServiceDocumentItemObjectType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemObjectType" )
    private String serviceDocumentItemObjectType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemObjectType</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_DOCUMENT_ITEM_OBJECT_TYPE =
        new ServiceConfirmationItemField<String>("ServiceDocumentItemObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> LANGUAGE =
        new ServiceConfirmationItemField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> PRODUCT =
        new ServiceConfirmationItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<BigDecimal> QUANTITY =
        new ServiceConfirmationItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> QUANTITY_UNIT =
        new ServiceConfirmationItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDuration</b>
     * </p>
     *
     * @return Confirmed Duration
     */
    @SerializedName( "ActualServiceDuration" )
    @JsonProperty( "ActualServiceDuration" )
    @Nullable
    @ODataField( odataName = "ActualServiceDuration" )
    private BigDecimal actualServiceDuration;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceDuration</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<BigDecimal> ACTUAL_SERVICE_DURATION =
        new ServiceConfirmationItemField<BigDecimal>("ActualServiceDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDurationUnit</b>
     * </p>
     *
     * @return Time Unit for Confirmed Duration
     */
    @SerializedName( "ActualServiceDurationUnit" )
    @JsonProperty( "ActualServiceDurationUnit" )
    @Nullable
    @ODataField( odataName = "ActualServiceDurationUnit" )
    private String actualServiceDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> ACTUAL_SERVICE_DURATION_UNIT =
        new ServiceConfirmationItemField<String>("ActualServiceDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "ServiceConfItemCategory" )
    @JsonProperty( "ServiceConfItemCategory" )
    @Nullable
    @ODataField( odataName = "ServiceConfItemCategory" )
    private String serviceConfItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfItemCategory</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_CONF_ITEM_CATEGORY =
        new ServiceConfirmationItemField<String>("ServiceConfItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemIsCompleted</b>
     * </p>
     *
     * @return The serviceConfItemIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceConfItemIsCompleted" )
    @JsonProperty( "ServiceConfItemIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceConfItemIsCompleted" )
    private String serviceConfItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfItemIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_CONF_ITEM_IS_COMPLETED =
        new ServiceConfirmationItemField<String>("ServiceConfItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingServiceEmployee</b>
     * </p>
     *
     * @return Executing Service Employee
     */
    @SerializedName( "ExecutingServiceEmployee" )
    @JsonProperty( "ExecutingServiceEmployee" )
    @Nullable
    @ODataField( odataName = "ExecutingServiceEmployee" )
    private String executingServiceEmployee;
    /**
     * Use with available fluent helpers to apply the <b>ExecutingServiceEmployee</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> EXECUTING_SERVICE_EMPLOYEE =
        new ServiceConfirmationItemField<String>("ExecutingServiceEmployee");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @return Partner Number
     */
    @SerializedName( "ServicePerformer" )
    @JsonProperty( "ServicePerformer" )
    @Nullable
    @ODataField( odataName = "ServicePerformer" )
    private String servicePerformer;
    /**
     * Use with available fluent helpers to apply the <b>ServicePerformer</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SERVICE_PERFORMER =
        new ServiceConfirmationItemField<String>("ServicePerformer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> BILLABLE_CONTROL =
        new ServiceConfirmationItemField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceOrder" )
    @JsonProperty( "ReferenceServiceOrder" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceOrder" )
    private String referenceServiceOrder;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceOrder</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> REFERENCE_SERVICE_ORDER =
        new ServiceConfirmationItemField<String>("ReferenceServiceOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrderItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceOrderItem" )
    @JsonProperty( "ReferenceServiceOrderItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceOrderItem" )
    private String referenceServiceOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceOrderItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> REFERENCE_SERVICE_ORDER_ITEM =
        new ServiceConfirmationItemField<String>("ReferenceServiceOrderItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefSrvcOrdItemIsUnplanned</b>
     * </p>
     *
     * @return Unplanned Item
     */
    @SerializedName( "RefSrvcOrdItemIsUnplanned" )
    @JsonProperty( "RefSrvcOrdItemIsUnplanned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RefSrvcOrdItemIsUnplanned" )
    private Boolean refSrvcOrdItemIsUnplanned;
    /**
     * Use with available fluent helpers to apply the <b>RefSrvcOrdItemIsUnplanned</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<Boolean> REF_SRVC_ORD_ITEM_IS_UNPLANNED =
        new ServiceConfirmationItemField<Boolean>("RefSrvcOrdItemIsUnplanned");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> REFERENCE_SERVICE_CONTRACT =
        new ServiceConfirmationItemField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ReferenceServiceContractItem" )
    @JsonProperty( "ReferenceServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContractItem" )
    private String referenceServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> REFERENCE_SERVICE_CONTRACT_ITEM =
        new ServiceConfirmationItemField<String>("ReferenceServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SHIPPING_CONDITION =
        new ServiceConfirmationItemField<String>("ShippingCondition");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceConfItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "ParentServiceConfItem" )
    @JsonProperty( "ParentServiceConfItem" )
    @Nullable
    @ODataField( odataName = "ParentServiceConfItem" )
    private String parentServiceConfItem;
    /**
     * Use with available fluent helpers to apply the <b>ParentServiceConfItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> PARENT_SERVICE_CONF_ITEM =
        new ServiceConfirmationItemField<String>("ParentServiceConfItem");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceStartDateTime</b>
     * </p>
     *
     * @return Service Actual Start Date
     */
    @SerializedName( "ActualServiceStartDateTime" )
    @JsonProperty( "ActualServiceStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualServiceStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime actualServiceStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<ZonedDateTime> ACTUAL_SERVICE_START_DATE_TIME =
        new ServiceConfirmationItemField<ZonedDateTime>("ActualServiceStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceEndDateTime</b>
     * </p>
     *
     * @return Service Actual End Date
     */
    @SerializedName( "ActualServiceEndDateTime" )
    @JsonProperty( "ActualServiceEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualServiceEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime actualServiceEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ActualServiceEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<ZonedDateTime> ACTUAL_SERVICE_END_DATE_TIME =
        new ServiceConfirmationItemField<ZonedDateTime>("ActualServiceEndDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Service Rendered Date
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new ServiceConfirmationItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceConfirmationItem</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "FSMServiceConfirmationItem" )
    @JsonProperty( "FSMServiceConfirmationItem" )
    @Nullable
    @ODataField( odataName = "FSMServiceConfirmationItem" )
    private String fSMServiceConfirmationItem;
    /**
     * Use with available fluent helpers to apply the <b>FSMServiceConfirmationItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> FSM_SERVICE_CONFIRMATION_ITEM =
        new ServiceConfirmationItemField<String>("FSMServiceConfirmationItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmPartReferenceItem" )
    @JsonProperty( "SrvcDocItmPartReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmPartReferenceItem" )
    private String srvcDocItmPartReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmPartReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SRVC_DOC_ITM_PART_REFERENCE_ITEM =
        new ServiceConfirmationItemField<String>("SrvcDocItmPartReferenceItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcDocItmApptReferenceItem" )
    @JsonProperty( "SrvcDocItmApptReferenceItem" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptReferenceItem" )
    private String srvcDocItmApptReferenceItem;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptReferenceItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SRVC_DOC_ITM_APPT_REFERENCE_ITEM =
        new ServiceConfirmationItemField<String>("SrvcDocItmApptReferenceItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @return GUID of a CRM Order Object
     */
    @SerializedName( "SrvcDocItmApptRefObjectUUID" )
    @JsonProperty( "SrvcDocItmApptRefObjectUUID" )
    @Nullable
    @ODataField( odataName = "SrvcDocItmApptRefObjectUUID" )
    private UUID srvcDocItmApptRefObjectUUID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocItmApptRefObjectUUID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<UUID> SRVC_DOC_ITM_APPT_REF_OBJECT_UUID =
        new ServiceConfirmationItemField<UUID>("SrvcDocItmApptRefObjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @return Overtime Category
     */
    @SerializedName( "TimeSheetOvertimeCategory" )
    @JsonProperty( "TimeSheetOvertimeCategory" )
    @Nullable
    @ODataField( odataName = "TimeSheetOvertimeCategory" )
    private String timeSheetOvertimeCategory;
    /**
     * Use with available fluent helpers to apply the <b>TimeSheetOvertimeCategory</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> TIME_SHEET_OVERTIME_CATEGORY =
        new ServiceConfirmationItemField<String>("TimeSheetOvertimeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @return Service Team (Responsibility Management)
     */
    @SerializedName( "RespyMgmtServiceTeam" )
    @JsonProperty( "RespyMgmtServiceTeam" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeam" )
    private String respyMgmtServiceTeam;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeam</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> RESPY_MGMT_SERVICE_TEAM =
        new ServiceConfirmationItemField<String>("RespyMgmtServiceTeam");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @return Name
     */
    @SerializedName( "RespyMgmtServiceTeamName" )
    @JsonProperty( "RespyMgmtServiceTeamName" )
    @Nullable
    @ODataField( odataName = "RespyMgmtServiceTeamName" )
    private String respyMgmtServiceTeamName;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtServiceTeamName</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> RESPY_MGMT_SERVICE_TEAM_NAME =
        new ServiceConfirmationItemField<String>("RespyMgmtServiceTeamName");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>SrvcConfItmCndnRateAmount</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "SrvcConfItmCndnRateAmount" )
    @JsonProperty( "SrvcConfItmCndnRateAmount" )
    @Nullable
    @ODataField( odataName = "SrvcConfItmCndnRateAmount" )
    private BigDecimal srvcConfItmCndnRateAmount;
    /**
     * Use with available fluent helpers to apply the <b>SrvcConfItmCndnRateAmount</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<BigDecimal> SRVC_CONF_ITM_CNDN_RATE_AMOUNT =
        new ServiceConfirmationItemField<BigDecimal>("SrvcConfItmCndnRateAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcConfItmCndnRateCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "SrvcConfItmCndnRateCurrency" )
    @JsonProperty( "SrvcConfItmCndnRateCurrency" )
    @Nullable
    @ODataField( odataName = "SrvcConfItmCndnRateCurrency" )
    private String srvcConfItmCndnRateCurrency;
    /**
     * Use with available fluent helpers to apply the <b>SrvcConfItmCndnRateCurrency</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SRVC_CONF_ITM_CNDN_RATE_CURRENCY =
        new ServiceConfirmationItemField<String>("SrvcConfItmCndnRateCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @return Global Team ID in Responsibility Mgmt.
     */
    @SerializedName( "RespyMgmtGlobalTeamID" )
    @JsonProperty( "RespyMgmtGlobalTeamID" )
    @Nullable
    @ODataField( odataName = "RespyMgmtGlobalTeamID" )
    private String respyMgmtGlobalTeamID;
    /**
     * Use with available fluent helpers to apply the <b>RespyMgmtGlobalTeamID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> RESPY_MGMT_GLOBAL_TEAM_ID =
        new ServiceConfirmationItemField<String>("RespyMgmtGlobalTeamID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment
     */
    @SerializedName( "PaymentTerms" )
    @JsonProperty( "PaymentTerms" )
    @Nullable
    @ODataField( odataName = "PaymentTerms" )
    private String paymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>PaymentTerms</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> PAYMENT_TERMS =
        new ServiceConfirmationItemField<String>("PaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> PAYMENT_METHOD =
        new ServiceConfirmationItemField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @return Unique Reference to Mandate per Payment Recipient
     */
    @SerializedName( "SEPAMandate" )
    @JsonProperty( "SEPAMandate" )
    @Nullable
    @ODataField( odataName = "SEPAMandate" )
    private String sEPAMandate;
    /**
     * Use with available fluent helpers to apply the <b>SEPAMandate</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SEPA_MANDATE =
        new ServiceConfirmationItemField<String>("SEPAMandate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @return Indicator for SEPA-Relevant Transactions
     */
    @SerializedName( "SrvcSEPAMandateRelevance" )
    @JsonProperty( "SrvcSEPAMandateRelevance" )
    @Nullable
    @ODataField( odataName = "SrvcSEPAMandateRelevance" )
    private String srvcSEPAMandateRelevance;
    /**
     * Use with available fluent helpers to apply the <b>SrvcSEPAMandateRelevance</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> SRVC_SEPA_MANDATE_RELEVANCE =
        new ServiceConfirmationItemField<String>("SrvcSEPAMandateRelevance");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new ServiceConfirmationItemField<String>("WBSElementExternalID");
    /**
     * Navigation property <b>to_Appointment</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>SrvcConfItemAppointment</b>.
     *
     */
    @SerializedName( "to_Appointment" )
    @JsonProperty( "to_Appointment" )
    @ODataField( odataName = "to_Appointment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfItemAppointment> toAppointment;
    /**
     * Navigation property <b>to_Duration</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>SrvcConfItemDuration</b>.
     *
     */
    @SerializedName( "to_Duration" )
    @JsonProperty( "to_Duration" )
    @ODataField( odataName = "to_Duration" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfItemDuration> toDuration;
    /**
     * Navigation property <b>to_Partner</b> for <b>ServiceConfirmationItem</b> to multiple <b>SrvcConfItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcConfItemPartner> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>ServiceConfItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfItemPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ReferenceObject</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>ServiceConfItmRefObject</b>.
     *
     */
    @SerializedName( "to_ReferenceObject" )
    @JsonProperty( "to_ReferenceObject" )
    @ODataField( odataName = "to_ReferenceObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfItmRefObject> toReferenceObject;
    /**
     * Navigation property <b>to_ServiceConfirmation</b> for <b>ServiceConfirmationItem</b> to single
     * <b>ServiceConfirmation</b>.
     *
     */
    @SerializedName( "to_ServiceConfirmation" )
    @JsonProperty( "to_ServiceConfirmation" )
    @ODataField( odataName = "to_ServiceConfirmation" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceConfirmation toServiceConfirmation;
    /**
     * Navigation property <b>to_SrvcConfItemUserStatus</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>ServiceConfItemUserStatus</b>.
     *
     */
    @SerializedName( "to_SrvcConfItemUserStatus" )
    @JsonProperty( "to_SrvcConfItemUserStatus" )
    @ODataField( odataName = "to_SrvcConfItemUserStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfItemUserStatus> toSrvcConfItemUserStatus;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceConfirmationItem</b> to multiple
     * <b>ServiceConfirmationItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceConfirmationItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Appointment</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<SrvcConfItemAppointment> TO_APPOINTMENT =
        new ServiceConfirmationItemLink<SrvcConfItemAppointment>("to_Appointment");
    /**
     * Use with available fluent helpers to apply the <b>to_Duration</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<SrvcConfItemDuration> TO_DURATION =
        new ServiceConfirmationItemLink<SrvcConfItemDuration>("to_Duration");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<SrvcConfItemPartner> TO_PARTNER =
        new ServiceConfirmationItemLink<SrvcConfItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<ServiceConfItemPriceElement> TO_PRICING_ELEMENT =
        new ServiceConfirmationItemLink<ServiceConfItemPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ReferenceObject</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<ServiceConfItmRefObject> TO_REFERENCE_OBJECT =
        new ServiceConfirmationItemLink<ServiceConfItmRefObject>("to_ReferenceObject");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceConfirmation</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceConfirmationItemOneToOneLink<ServiceConfirmation> TO_SERVICE_CONFIRMATION =
        new ServiceConfirmationItemOneToOneLink<ServiceConfirmation>("to_ServiceConfirmation");
    /**
     * Use with available fluent helpers to apply the <b>to_SrvcConfItemUserStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceConfirmationItemLink<ServiceConfItemUserStatus> TO_SRVC_CONF_ITEM_USER_STATUS =
        new ServiceConfirmationItemLink<ServiceConfItemUserStatus>("to_SrvcConfItemUserStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceConfirmationItemLink<ServiceConfirmationItemText> TO_TEXT =
        new ServiceConfirmationItemLink<ServiceConfirmationItemText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceConfirmationItem> getType()
    {
        return ServiceConfirmationItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     */
    public void setServiceConfirmationItem( @Nullable final String serviceConfirmationItem )
    {
        rememberChangedField("ServiceConfirmationItem", this.serviceConfirmationItem);
        this.serviceConfirmationItem = serviceConfirmationItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItemUUID</b>
     * </p>
     *
     * @param serviceConfirmationItemUUID
     *            GUID of a CRM Order Object
     */
    public void setServiceConfirmationItemUUID( @Nullable final UUID serviceConfirmationItemUUID )
    {
        rememberChangedField("ServiceConfirmationItemUUID", this.serviceConfirmationItemUUID);
        this.serviceConfirmationItemUUID = serviceConfirmationItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemDescription</b>
     * </p>
     *
     * @param serviceConfItemDescription
     *            Product Description
     */
    public void setServiceConfItemDescription( @Nullable final String serviceConfItemDescription )
    {
        rememberChangedField("ServiceConfItemDescription", this.serviceConfItemDescription);
        this.serviceConfItemDescription = serviceConfItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceObjectType</b>
     * </p>
     *
     * @param serviceObjectType
     *            Business Trans. Cat.
     */
    public void setServiceObjectType( @Nullable final String serviceObjectType )
    {
        rememberChangedField("ServiceObjectType", this.serviceObjectType);
        this.serviceObjectType = serviceObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemObjectType</b>
     * </p>
     *
     * @param serviceDocumentItemObjectType
     *            CRM Item Object Type
     */
    public void setServiceDocumentItemObjectType( @Nullable final String serviceDocumentItemObjectType )
    {
        rememberChangedField("ServiceDocumentItemObjectType", this.serviceDocumentItemObjectType);
        this.serviceDocumentItemObjectType = serviceDocumentItemObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 7, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDuration</b>
     * </p>
     *
     * @param actualServiceDuration
     *            Confirmed Duration
     */
    public void setActualServiceDuration( @Nullable final BigDecimal actualServiceDuration )
    {
        rememberChangedField("ActualServiceDuration", this.actualServiceDuration);
        this.actualServiceDuration = actualServiceDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceDurationUnit</b>
     * </p>
     *
     * @param actualServiceDurationUnit
     *            Time Unit for Confirmed Duration
     */
    public void setActualServiceDurationUnit( @Nullable final String actualServiceDurationUnit )
    {
        rememberChangedField("ActualServiceDurationUnit", this.actualServiceDurationUnit);
        this.actualServiceDurationUnit = actualServiceDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemCategory</b>
     * </p>
     *
     * @param serviceConfItemCategory
     *            Item Category
     */
    public void setServiceConfItemCategory( @Nullable final String serviceConfItemCategory )
    {
        rememberChangedField("ServiceConfItemCategory", this.serviceConfItemCategory);
        this.serviceConfItemCategory = serviceConfItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfItemIsCompleted</b>
     * </p>
     *
     * @param serviceConfItemIsCompleted
     *            The serviceConfItemIsCompleted to set.
     */
    public void setServiceConfItemIsCompleted( @Nullable final String serviceConfItemIsCompleted )
    {
        rememberChangedField("ServiceConfItemIsCompleted", this.serviceConfItemIsCompleted);
        this.serviceConfItemIsCompleted = serviceConfItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ExecutingServiceEmployee</b>
     * </p>
     *
     * @param executingServiceEmployee
     *            Executing Service Employee
     */
    public void setExecutingServiceEmployee( @Nullable final String executingServiceEmployee )
    {
        rememberChangedField("ExecutingServiceEmployee", this.executingServiceEmployee);
        this.executingServiceEmployee = executingServiceEmployee;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>ServicePerformer</b>
     * </p>
     *
     * @param servicePerformer
     *            Partner Number
     */
    public void setServicePerformer( @Nullable final String servicePerformer )
    {
        rememberChangedField("ServicePerformer", this.servicePerformer);
        this.servicePerformer = servicePerformer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Accounting Indicator
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrder</b>
     * </p>
     *
     * @param referenceServiceOrder
     *            Transaction ID
     */
    public void setReferenceServiceOrder( @Nullable final String referenceServiceOrder )
    {
        rememberChangedField("ReferenceServiceOrder", this.referenceServiceOrder);
        this.referenceServiceOrder = referenceServiceOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceOrderItem</b>
     * </p>
     *
     * @param referenceServiceOrderItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceOrderItem( @Nullable final String referenceServiceOrderItem )
    {
        rememberChangedField("ReferenceServiceOrderItem", this.referenceServiceOrderItem);
        this.referenceServiceOrderItem = referenceServiceOrderItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RefSrvcOrdItemIsUnplanned</b>
     * </p>
     *
     * @param refSrvcOrdItemIsUnplanned
     *            Unplanned Item
     */
    public void setRefSrvcOrdItemIsUnplanned( @Nullable final Boolean refSrvcOrdItemIsUnplanned )
    {
        rememberChangedField("RefSrvcOrdItemIsUnplanned", this.refSrvcOrdItemIsUnplanned);
        this.refSrvcOrdItemIsUnplanned = refSrvcOrdItemIsUnplanned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            Transaction ID
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @param referenceServiceContractItem
     *            Shortened Item Number in Document
     */
    public void setReferenceServiceContractItem( @Nullable final String referenceServiceContractItem )
    {
        rememberChangedField("ReferenceServiceContractItem", this.referenceServiceContractItem);
        this.referenceServiceContractItem = referenceServiceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ParentServiceConfItem</b>
     * </p>
     *
     * @param parentServiceConfItem
     *            Shortened Item Number in Document
     */
    public void setParentServiceConfItem( @Nullable final String parentServiceConfItem )
    {
        rememberChangedField("ParentServiceConfItem", this.parentServiceConfItem);
        this.parentServiceConfItem = parentServiceConfItem;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceStartDateTime</b>
     * </p>
     *
     * @param actualServiceStartDateTime
     *            Service Actual Start Date
     */
    public void setActualServiceStartDateTime( @Nullable final ZonedDateTime actualServiceStartDateTime )
    {
        rememberChangedField("ActualServiceStartDateTime", this.actualServiceStartDateTime);
        this.actualServiceStartDateTime = actualServiceStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualServiceEndDateTime</b>
     * </p>
     *
     * @param actualServiceEndDateTime
     *            Service Actual End Date
     */
    public void setActualServiceEndDateTime( @Nullable final ZonedDateTime actualServiceEndDateTime )
    {
        rememberChangedField("ActualServiceEndDateTime", this.actualServiceEndDateTime);
        this.actualServiceEndDateTime = actualServiceEndDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Service Rendered Date
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>FSMServiceConfirmationItem</b>
     * </p>
     *
     * @param fSMServiceConfirmationItem
     *            External Reference Number
     */
    public void setFSMServiceConfirmationItem( @Nullable final String fSMServiceConfirmationItem )
    {
        rememberChangedField("FSMServiceConfirmationItem", this.fSMServiceConfirmationItem);
        this.fSMServiceConfirmationItem = fSMServiceConfirmationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmPartReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmPartReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmPartReferenceItem( @Nullable final String srvcDocItmPartReferenceItem )
    {
        rememberChangedField("SrvcDocItmPartReferenceItem", this.srvcDocItmPartReferenceItem);
        this.srvcDocItmPartReferenceItem = srvcDocItmPartReferenceItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptReferenceItem</b>
     * </p>
     *
     * @param srvcDocItmApptReferenceItem
     *            Shortened Item Number in Document
     */
    public void setSrvcDocItmApptReferenceItem( @Nullable final String srvcDocItmApptReferenceItem )
    {
        rememberChangedField("SrvcDocItmApptReferenceItem", this.srvcDocItmApptReferenceItem);
        this.srvcDocItmApptReferenceItem = srvcDocItmApptReferenceItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocItmApptRefObjectUUID</b>
     * </p>
     *
     * @param srvcDocItmApptRefObjectUUID
     *            GUID of a CRM Order Object
     */
    public void setSrvcDocItmApptRefObjectUUID( @Nullable final UUID srvcDocItmApptRefObjectUUID )
    {
        rememberChangedField("SrvcDocItmApptRefObjectUUID", this.srvcDocItmApptRefObjectUUID);
        this.srvcDocItmApptRefObjectUUID = srvcDocItmApptRefObjectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>TimeSheetOvertimeCategory</b>
     * </p>
     *
     * @param timeSheetOvertimeCategory
     *            Overtime Category
     */
    public void setTimeSheetOvertimeCategory( @Nullable final String timeSheetOvertimeCategory )
    {
        rememberChangedField("TimeSheetOvertimeCategory", this.timeSheetOvertimeCategory);
        this.timeSheetOvertimeCategory = timeSheetOvertimeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeam</b>
     * </p>
     *
     * @param respyMgmtServiceTeam
     *            Service Team (Responsibility Management)
     */
    public void setRespyMgmtServiceTeam( @Nullable final String respyMgmtServiceTeam )
    {
        rememberChangedField("RespyMgmtServiceTeam", this.respyMgmtServiceTeam);
        this.respyMgmtServiceTeam = respyMgmtServiceTeam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtServiceTeamName</b>
     * </p>
     *
     * @param respyMgmtServiceTeamName
     *            Name
     */
    public void setRespyMgmtServiceTeamName( @Nullable final String respyMgmtServiceTeamName )
    {
        rememberChangedField("RespyMgmtServiceTeamName", this.respyMgmtServiceTeamName);
        this.respyMgmtServiceTeamName = respyMgmtServiceTeamName;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>SrvcConfItmCndnRateAmount</b>
     * </p>
     *
     * @param srvcConfItmCndnRateAmount
     *            Condition Amount or Percentage
     */
    public void setSrvcConfItmCndnRateAmount( @Nullable final BigDecimal srvcConfItmCndnRateAmount )
    {
        rememberChangedField("SrvcConfItmCndnRateAmount", this.srvcConfItmCndnRateAmount);
        this.srvcConfItmCndnRateAmount = srvcConfItmCndnRateAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>SrvcConfItmCndnRateCurrency</b>
     * </p>
     *
     * @param srvcConfItmCndnRateCurrency
     *            Currency Key
     */
    public void setSrvcConfItmCndnRateCurrency( @Nullable final String srvcConfItmCndnRateCurrency )
    {
        rememberChangedField("SrvcConfItmCndnRateCurrency", this.srvcConfItmCndnRateCurrency);
        this.srvcConfItmCndnRateCurrency = srvcConfItmCndnRateCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>RespyMgmtGlobalTeamID</b>
     * </p>
     *
     * @param respyMgmtGlobalTeamID
     *            Global Team ID in Responsibility Mgmt.
     */
    public void setRespyMgmtGlobalTeamID( @Nullable final String respyMgmtGlobalTeamID )
    {
        rememberChangedField("RespyMgmtGlobalTeamID", this.respyMgmtGlobalTeamID);
        this.respyMgmtGlobalTeamID = respyMgmtGlobalTeamID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentTerms</b>
     * </p>
     *
     * @param paymentTerms
     *            Terms of Payment
     */
    public void setPaymentTerms( @Nullable final String paymentTerms )
    {
        rememberChangedField("PaymentTerms", this.paymentTerms);
        this.paymentTerms = paymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>SEPAMandate</b>
     * </p>
     *
     * @param sEPAMandate
     *            Unique Reference to Mandate per Payment Recipient
     */
    public void setSEPAMandate( @Nullable final String sEPAMandate )
    {
        rememberChangedField("SEPAMandate", this.sEPAMandate);
        this.sEPAMandate = sEPAMandate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcSEPAMandateRelevance</b>
     * </p>
     *
     * @param srvcSEPAMandateRelevance
     *            Indicator for SEPA-Relevant Transactions
     */
    public void setSrvcSEPAMandateRelevance( @Nullable final String srvcSEPAMandateRelevance )
    {
        rememberChangedField("SrvcSEPAMandateRelevance", this.srvcSEPAMandateRelevance);
        this.srvcSEPAMandateRelevance = srvcSEPAMandateRelevance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceConfirmationItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("ServiceConfirmationItem", getServiceConfirmationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("ServiceConfirmationItem", getServiceConfirmationItem());
        values.put("ServiceConfirmationItemUUID", getServiceConfirmationItemUUID());
        values.put("ServiceConfItemDescription", getServiceConfItemDescription());
        values.put("ServiceObjectType", getServiceObjectType());
        values.put("ServiceDocumentItemObjectType", getServiceDocumentItemObjectType());
        values.put("Language", getLanguage());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("ActualServiceDuration", getActualServiceDuration());
        values.put("ActualServiceDurationUnit", getActualServiceDurationUnit());
        values.put("ServiceConfItemCategory", getServiceConfItemCategory());
        values.put("ServiceConfItemIsCompleted", getServiceConfItemIsCompleted());
        values.put("ExecutingServiceEmployee", getExecutingServiceEmployee());
        values.put("ServicePerformer", getServicePerformer());
        values.put("BillableControl", getBillableControl());
        values.put("ReferenceServiceOrder", getReferenceServiceOrder());
        values.put("ReferenceServiceOrderItem", getReferenceServiceOrderItem());
        values.put("RefSrvcOrdItemIsUnplanned", getRefSrvcOrdItemIsUnplanned());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("ReferenceServiceContractItem", getReferenceServiceContractItem());
        values.put("ShippingCondition", getShippingCondition());
        values.put("ParentServiceConfItem", getParentServiceConfItem());
        values.put("ActualServiceStartDateTime", getActualServiceStartDateTime());
        values.put("ActualServiceEndDateTime", getActualServiceEndDateTime());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        values.put("FSMServiceConfirmationItem", getFSMServiceConfirmationItem());
        values.put("SrvcDocItmPartReferenceItem", getSrvcDocItmPartReferenceItem());
        values.put("SrvcDocItmApptReferenceItem", getSrvcDocItmApptReferenceItem());
        values.put("SrvcDocItmApptRefObjectUUID", getSrvcDocItmApptRefObjectUUID());
        values.put("TimeSheetOvertimeCategory", getTimeSheetOvertimeCategory());
        values.put("RespyMgmtServiceTeam", getRespyMgmtServiceTeam());
        values.put("RespyMgmtServiceTeamName", getRespyMgmtServiceTeamName());
        values.put("SrvcConfItmCndnRateAmount", getSrvcConfItmCndnRateAmount());
        values.put("SrvcConfItmCndnRateCurrency", getSrvcConfItmCndnRateCurrency());
        values.put("RespyMgmtGlobalTeamID", getRespyMgmtGlobalTeamID());
        values.put("PaymentTerms", getPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("SEPAMandate", getSEPAMandate());
        values.put("SrvcSEPAMandateRelevance", getSrvcSEPAMandateRelevance());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationItem") ) {
                final Object value = values.remove("ServiceConfirmationItem");
                if( (value == null) || (!value.equals(getServiceConfirmationItem())) ) {
                    setServiceConfirmationItem(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationItemUUID") ) {
                final Object value = values.remove("ServiceConfirmationItemUUID");
                if( (value == null) || (!value.equals(getServiceConfirmationItemUUID())) ) {
                    setServiceConfirmationItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ServiceConfItemDescription") ) {
                final Object value = values.remove("ServiceConfItemDescription");
                if( (value == null) || (!value.equals(getServiceConfItemDescription())) ) {
                    setServiceConfItemDescription(((String) value));
                }
            }
            if( values.containsKey("ServiceObjectType") ) {
                final Object value = values.remove("ServiceObjectType");
                if( (value == null) || (!value.equals(getServiceObjectType())) ) {
                    setServiceObjectType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemObjectType") ) {
                final Object value = values.remove("ServiceDocumentItemObjectType");
                if( (value == null) || (!value.equals(getServiceDocumentItemObjectType())) ) {
                    setServiceDocumentItemObjectType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ActualServiceDuration") ) {
                final Object value = values.remove("ActualServiceDuration");
                if( (value == null) || (!value.equals(getActualServiceDuration())) ) {
                    setActualServiceDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualServiceDurationUnit") ) {
                final Object value = values.remove("ActualServiceDurationUnit");
                if( (value == null) || (!value.equals(getActualServiceDurationUnit())) ) {
                    setActualServiceDurationUnit(((String) value));
                }
            }
            if( values.containsKey("ServiceConfItemCategory") ) {
                final Object value = values.remove("ServiceConfItemCategory");
                if( (value == null) || (!value.equals(getServiceConfItemCategory())) ) {
                    setServiceConfItemCategory(((String) value));
                }
            }
            if( values.containsKey("ServiceConfItemIsCompleted") ) {
                final Object value = values.remove("ServiceConfItemIsCompleted");
                if( (value == null) || (!value.equals(getServiceConfItemIsCompleted())) ) {
                    setServiceConfItemIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ExecutingServiceEmployee") ) {
                final Object value = values.remove("ExecutingServiceEmployee");
                if( (value == null) || (!value.equals(getExecutingServiceEmployee())) ) {
                    setExecutingServiceEmployee(((String) value));
                }
            }
            if( values.containsKey("ServicePerformer") ) {
                final Object value = values.remove("ServicePerformer");
                if( (value == null) || (!value.equals(getServicePerformer())) ) {
                    setServicePerformer(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceOrder") ) {
                final Object value = values.remove("ReferenceServiceOrder");
                if( (value == null) || (!value.equals(getReferenceServiceOrder())) ) {
                    setReferenceServiceOrder(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceOrderItem") ) {
                final Object value = values.remove("ReferenceServiceOrderItem");
                if( (value == null) || (!value.equals(getReferenceServiceOrderItem())) ) {
                    setReferenceServiceOrderItem(((String) value));
                }
            }
            if( values.containsKey("RefSrvcOrdItemIsUnplanned") ) {
                final Object value = values.remove("RefSrvcOrdItemIsUnplanned");
                if( (value == null) || (!value.equals(getRefSrvcOrdItemIsUnplanned())) ) {
                    setRefSrvcOrdItemIsUnplanned(((Boolean) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContractItem") ) {
                final Object value = values.remove("ReferenceServiceContractItem");
                if( (value == null) || (!value.equals(getReferenceServiceContractItem())) ) {
                    setReferenceServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("ParentServiceConfItem") ) {
                final Object value = values.remove("ParentServiceConfItem");
                if( (value == null) || (!value.equals(getParentServiceConfItem())) ) {
                    setParentServiceConfItem(((String) value));
                }
            }
            if( values.containsKey("ActualServiceStartDateTime") ) {
                final Object value = values.remove("ActualServiceStartDateTime");
                if( (value == null) || (!value.equals(getActualServiceStartDateTime())) ) {
                    setActualServiceStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ActualServiceEndDateTime") ) {
                final Object value = values.remove("ActualServiceEndDateTime");
                if( (value == null) || (!value.equals(getActualServiceEndDateTime())) ) {
                    setActualServiceEndDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FSMServiceConfirmationItem") ) {
                final Object value = values.remove("FSMServiceConfirmationItem");
                if( (value == null) || (!value.equals(getFSMServiceConfirmationItem())) ) {
                    setFSMServiceConfirmationItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmPartReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmPartReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmPartReferenceItem())) ) {
                    setSrvcDocItmPartReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptReferenceItem") ) {
                final Object value = values.remove("SrvcDocItmApptReferenceItem");
                if( (value == null) || (!value.equals(getSrvcDocItmApptReferenceItem())) ) {
                    setSrvcDocItmApptReferenceItem(((String) value));
                }
            }
            if( values.containsKey("SrvcDocItmApptRefObjectUUID") ) {
                final Object value = values.remove("SrvcDocItmApptRefObjectUUID");
                if( (value == null) || (!value.equals(getSrvcDocItmApptRefObjectUUID())) ) {
                    setSrvcDocItmApptRefObjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("TimeSheetOvertimeCategory") ) {
                final Object value = values.remove("TimeSheetOvertimeCategory");
                if( (value == null) || (!value.equals(getTimeSheetOvertimeCategory())) ) {
                    setTimeSheetOvertimeCategory(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeam") ) {
                final Object value = values.remove("RespyMgmtServiceTeam");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeam())) ) {
                    setRespyMgmtServiceTeam(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtServiceTeamName") ) {
                final Object value = values.remove("RespyMgmtServiceTeamName");
                if( (value == null) || (!value.equals(getRespyMgmtServiceTeamName())) ) {
                    setRespyMgmtServiceTeamName(((String) value));
                }
            }
            if( values.containsKey("SrvcConfItmCndnRateAmount") ) {
                final Object value = values.remove("SrvcConfItmCndnRateAmount");
                if( (value == null) || (!value.equals(getSrvcConfItmCndnRateAmount())) ) {
                    setSrvcConfItmCndnRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcConfItmCndnRateCurrency") ) {
                final Object value = values.remove("SrvcConfItmCndnRateCurrency");
                if( (value == null) || (!value.equals(getSrvcConfItmCndnRateCurrency())) ) {
                    setSrvcConfItmCndnRateCurrency(((String) value));
                }
            }
            if( values.containsKey("RespyMgmtGlobalTeamID") ) {
                final Object value = values.remove("RespyMgmtGlobalTeamID");
                if( (value == null) || (!value.equals(getRespyMgmtGlobalTeamID())) ) {
                    setRespyMgmtGlobalTeamID(((String) value));
                }
            }
            if( values.containsKey("PaymentTerms") ) {
                final Object value = values.remove("PaymentTerms");
                if( (value == null) || (!value.equals(getPaymentTerms())) ) {
                    setPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("SEPAMandate") ) {
                final Object value = values.remove("SEPAMandate");
                if( (value == null) || (!value.equals(getSEPAMandate())) ) {
                    setSEPAMandate(((String) value));
                }
            }
            if( values.containsKey("SrvcSEPAMandateRelevance") ) {
                final Object value = values.remove("SrvcSEPAMandateRelevance");
                if( (value == null) || (!value.equals(getSrvcSEPAMandateRelevance())) ) {
                    setSrvcSEPAMandateRelevance(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Appointment") ) {
                final Object value = (values).remove("to_Appointment");
                if( value instanceof Iterable ) {
                    if( toAppointment == null ) {
                        toAppointment = Lists.newArrayList();
                    } else {
                        toAppointment = Lists.newArrayList(toAppointment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfItemAppointment entity;
                        if( toAppointment.size() > i ) {
                            entity = toAppointment.get(i);
                        } else {
                            entity = new SrvcConfItemAppointment();
                            toAppointment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Duration") ) {
                final Object value = (values).remove("to_Duration");
                if( value instanceof Iterable ) {
                    if( toDuration == null ) {
                        toDuration = Lists.newArrayList();
                    } else {
                        toDuration = Lists.newArrayList(toDuration);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfItemDuration entity;
                        if( toDuration.size() > i ) {
                            entity = toDuration.get(i);
                        } else {
                            entity = new SrvcConfItemDuration();
                            toDuration.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcConfItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SrvcConfItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfItemPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceConfItemPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReferenceObject") ) {
                final Object value = (values).remove("to_ReferenceObject");
                if( value instanceof Iterable ) {
                    if( toReferenceObject == null ) {
                        toReferenceObject = Lists.newArrayList();
                    } else {
                        toReferenceObject = Lists.newArrayList(toReferenceObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfItmRefObject entity;
                        if( toReferenceObject.size() > i ) {
                            entity = toReferenceObject.get(i);
                        } else {
                            entity = new ServiceConfItmRefObject();
                            toReferenceObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceConfirmation") ) {
                final Object value = (values).remove("to_ServiceConfirmation");
                if( value instanceof Map ) {
                    if( toServiceConfirmation == null ) {
                        toServiceConfirmation = new ServiceConfirmation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceConfirmation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SrvcConfItemUserStatus") ) {
                final Object value = (values).remove("to_SrvcConfItemUserStatus");
                if( value instanceof Iterable ) {
                    if( toSrvcConfItemUserStatus == null ) {
                        toSrvcConfItemUserStatus = Lists.newArrayList();
                    } else {
                        toSrvcConfItemUserStatus = Lists.newArrayList(toSrvcConfItemUserStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfItemUserStatus entity;
                        if( toSrvcConfItemUserStatus.size() > i ) {
                            entity = toSrvcConfItemUserStatus.get(i);
                        } else {
                            entity = new ServiceConfItemUserStatus();
                            toSrvcConfItemUserStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceConfirmationItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceConfirmationItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceConfirmationItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceConfirmationItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceConfirmationItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceConfirmationItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAppointment != null ) {
            (values).put("to_Appointment", toAppointment);
        }
        if( toDuration != null ) {
            (values).put("to_Duration", toDuration);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toReferenceObject != null ) {
            (values).put("to_ReferenceObject", toReferenceObject);
        }
        if( toServiceConfirmation != null ) {
            (values).put("to_ServiceConfirmation", toServiceConfirmation);
        }
        if( toSrvcConfItemUserStatus != null ) {
            (values).put("to_SrvcConfItemUserStatus", toSrvcConfItemUserStatus);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcConfItemAppointment</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Appointment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfItemAppointment</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemAppointment> fetchAppointment()
    {
        return fetchFieldAsList("to_Appointment", SrvcConfItemAppointment.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfItemAppointment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemAppointment> getAppointmentOrFetch()
    {
        if( toAppointment == null ) {
            toAppointment = fetchAppointment();
        }
        return toAppointment;
    }

    /**
     * Retrieval of associated <b>SrvcConfItemAppointment</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Appointment</b> is already loaded, the result will
     *         contain the <b>SrvcConfItemAppointment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcConfItemAppointment>> getAppointmentIfPresent()
    {
        return Option.of(toAppointment);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfItemAppointment</b> entities for the loaded navigation property
     * <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfItemAppointment</b> entities.
     */
    public void setAppointment( @Nonnull final List<SrvcConfItemAppointment> value )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.clear();
        toAppointment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfItemAppointment</b> entities. This corresponds to the OData
     * navigation property <b>to_Appointment</b>.
     * <p>
     * If the navigation property <b>to_Appointment</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfItemAppointment</b> entities.
     */
    public void addAppointment( SrvcConfItemAppointment... entity )
    {
        if( toAppointment == null ) {
            toAppointment = Lists.newArrayList();
        }
        toAppointment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcConfItemDuration</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Duration</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfItemDuration</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemDuration> fetchDuration()
    {
        return fetchFieldAsList("to_Duration", SrvcConfItemDuration.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfItemDuration</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemDuration> getDurationOrFetch()
    {
        if( toDuration == null ) {
            toDuration = fetchDuration();
        }
        return toDuration;
    }

    /**
     * Retrieval of associated <b>SrvcConfItemDuration</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Duration</b> is already loaded, the result will contain
     *         the <b>SrvcConfItemDuration</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcConfItemDuration>> getDurationIfPresent()
    {
        return Option.of(toDuration);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfItemDuration</b> entities for the loaded navigation property
     * <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfItemDuration</b> entities.
     */
    public void setDuration( @Nonnull final List<SrvcConfItemDuration> value )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.clear();
        toDuration.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfItemDuration</b> entities. This corresponds to the OData
     * navigation property <b>to_Duration</b>.
     * <p>
     * If the navigation property <b>to_Duration</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfItemDuration</b> entities.
     */
    public void addDuration( SrvcConfItemDuration... entity )
    {
        if( toDuration == null ) {
            toDuration = Lists.newArrayList();
        }
        toDuration.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcConfItemPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcConfItemPartner</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SrvcConfItemPartner.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcConfItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SrvcConfItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SrvcConfItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcConfItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SrvcConfItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcConfItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SrvcConfItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcConfItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcConfItemPartner</b> entities.
     */
    public void addPartner( SrvcConfItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItemPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceConfItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItemPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceConfItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceConfItemPriceElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfItemPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfItemPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceConfItemPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfItemPriceElement</b> entities.
     */
    public void addPricingElement( ServiceConfItemPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfItmRefObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReferenceObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfItmRefObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItmRefObject> fetchReferenceObject()
    {
        return fetchFieldAsList("to_ReferenceObject", ServiceConfItmRefObject.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfItmRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfItmRefObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItmRefObject> getReferenceObjectOrFetch()
    {
        if( toReferenceObject == null ) {
            toReferenceObject = fetchReferenceObject();
        }
        return toReferenceObject;
    }

    /**
     * Retrieval of associated <b>ServiceConfItmRefObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReferenceObject</b> is already loaded, the result will
     *         contain the <b>ServiceConfItmRefObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfItmRefObject>> getReferenceObjectIfPresent()
    {
        return Option.of(toReferenceObject);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfItmRefObject</b> entities for the loaded navigation property
     * <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfItmRefObject</b> entities.
     */
    public void setReferenceObject( @Nonnull final List<ServiceConfItmRefObject> value )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.clear();
        toReferenceObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfItmRefObject</b> entities. This corresponds to the OData
     * navigation property <b>to_ReferenceObject</b>.
     * <p>
     * If the navigation property <b>to_ReferenceObject</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfItmRefObject</b> entities.
     */
    public void addReferenceObject( ServiceConfItmRefObject... entity )
    {
        if( toReferenceObject == null ) {
            toReferenceObject = Lists.newArrayList();
        }
        toReferenceObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfirmation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceConfirmation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceConfirmation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceConfirmation fetchServiceConfirmation()
    {
        return fetchFieldAsSingle("to_ServiceConfirmation", ServiceConfirmation.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfirmation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceConfirmation</b>.
     * <p>
     * If the navigation property <b>to_ServiceConfirmation</b> of a queried <b>ServiceConfirmationItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfirmation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceConfirmation getServiceConfirmationOrFetch()
    {
        if( toServiceConfirmation == null ) {
            toServiceConfirmation = fetchServiceConfirmation();
        }
        return toServiceConfirmation;
    }

    /**
     * Retrieval of associated <b>ServiceConfirmation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceConfirmation</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceConfirmation</b> is already loaded, the result
     *         will contain the <b>ServiceConfirmation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceConfirmation> getServiceConfirmationIfPresent()
    {
        return Option.of(toServiceConfirmation);
    }

    /**
     * Overwrites the associated <b>ServiceConfirmation</b> entity for the loaded navigation property
     * <b>to_ServiceConfirmation</b>.
     *
     * @param value
     *            New <b>ServiceConfirmation</b> entity.
     */
    public void setServiceConfirmation( final ServiceConfirmation value )
    {
        toServiceConfirmation = value;
    }

    /**
     * Fetches the <b>ServiceConfItemUserStatus</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SrvcConfItemUserStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfItemUserStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItemUserStatus> fetchSrvcConfItemUserStatus()
    {
        return fetchFieldAsList("to_SrvcConfItemUserStatus", ServiceConfItemUserStatus.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcConfItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcConfItemUserStatus</b> of a queried <b>ServiceConfirmationItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfItemUserStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfItemUserStatus> getSrvcConfItemUserStatusOrFetch()
    {
        if( toSrvcConfItemUserStatus == null ) {
            toSrvcConfItemUserStatus = fetchSrvcConfItemUserStatus();
        }
        return toSrvcConfItemUserStatus;
    }

    /**
     * Retrieval of associated <b>ServiceConfItemUserStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SrvcConfItemUserStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SrvcConfItemUserStatus</b> is already loaded, the result
     *         will contain the <b>ServiceConfItemUserStatus</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfItemUserStatus>> getSrvcConfItemUserStatusIfPresent()
    {
        return Option.of(toSrvcConfItemUserStatus);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfItemUserStatus</b> entities for the loaded navigation property
     * <b>to_SrvcConfItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcConfItemUserStatus</b> of a queried <b>ServiceConfirmationItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfItemUserStatus</b> entities.
     */
    public void setSrvcConfItemUserStatus( @Nonnull final List<ServiceConfItemUserStatus> value )
    {
        if( toSrvcConfItemUserStatus == null ) {
            toSrvcConfItemUserStatus = Lists.newArrayList();
        }
        toSrvcConfItemUserStatus.clear();
        toSrvcConfItemUserStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfItemUserStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_SrvcConfItemUserStatus</b>.
     * <p>
     * If the navigation property <b>to_SrvcConfItemUserStatus</b> of a queried <b>ServiceConfirmationItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfItemUserStatus</b> entities.
     */
    public void addSrvcConfItemUserStatus( ServiceConfItemUserStatus... entity )
    {
        if( toSrvcConfItemUserStatus == null ) {
            toSrvcConfItemUserStatus = Lists.newArrayList();
        }
        toSrvcConfItemUserStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceConfirmationItemText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceConfirmationItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceConfirmationItemText.class);
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceConfirmationItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceConfirmationItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceConfirmationItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceConfirmationItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceConfirmationItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceConfirmationItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceConfirmationItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceConfirmationItemText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceConfirmationItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceConfirmationItemText</b> entities. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceConfirmationItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceConfirmationItemText</b> entities.
     */
    public void addText( ServiceConfirmationItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceConfirmationItem instances.
     *
     */
    public final static class ServiceConfirmationItemBuilder
    {

        private List<SrvcConfItemAppointment> toAppointment = Lists.newArrayList();
        private List<SrvcConfItemDuration> toDuration = Lists.newArrayList();
        private List<SrvcConfItemPartner> toPartner = Lists.newArrayList();
        private List<ServiceConfItemPriceElement> toPricingElement = Lists.newArrayList();
        private List<ServiceConfItmRefObject> toReferenceObject = Lists.newArrayList();
        private ServiceConfirmation toServiceConfirmation;
        private String serviceConfirmation = null;
        private List<ServiceConfItemUserStatus> toSrvcConfItemUserStatus = Lists.newArrayList();
        private List<ServiceConfirmationItemText> toText = Lists.newArrayList();

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toAppointment(
            final List<SrvcConfItemAppointment> value )
        {
            toAppointment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Appointment</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>SrvcConfItemAppointment</b>.
         *
         * @param value
         *            The SrvcConfItemAppointments to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder appointment( SrvcConfItemAppointment... value )
        {
            return toAppointment(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toDuration(
            final List<SrvcConfItemDuration> value )
        {
            toDuration.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Duration</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>SrvcConfItemDuration</b>.
         *
         * @param value
         *            The SrvcConfItemDurations to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder duration( SrvcConfItemDuration... value )
        {
            return toDuration(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toPartner(
            final List<SrvcConfItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>SrvcConfItemPartner</b>.
         *
         * @param value
         *            The SrvcConfItemPartners to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder partner( SrvcConfItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toPricingElement(
            final List<ServiceConfItemPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>ServiceConfItemPriceElement</b>.
         *
         * @param value
         *            The ServiceConfItemPriceElements to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder pricingElement(
            ServiceConfItemPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toReferenceObject(
            final List<ServiceConfItmRefObject> value )
        {
            toReferenceObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReferenceObject</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>ServiceConfItmRefObject</b>.
         *
         * @param value
         *            The ServiceConfItmRefObjects to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder referenceObject(
            ServiceConfItmRefObject... value )
        {
            return toReferenceObject(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toServiceConfirmation(
            final ServiceConfirmation value )
        {
            toServiceConfirmation = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceConfirmation</b> for <b>ServiceConfirmationItem</b> to single
         * <b>ServiceConfirmation</b>.
         *
         * @param value
         *            The ServiceConfirmation to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder serviceConfirmation(
            final ServiceConfirmation value )
        {
            return toServiceConfirmation(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
         * </p>
         *
         * @param value
         *            The serviceConfirmation to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder serviceConfirmation( final String value )
        {
            serviceConfirmation = value;
            return this;
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toSrvcConfItemUserStatus(
            final List<ServiceConfItemUserStatus> value )
        {
            toSrvcConfItemUserStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SrvcConfItemUserStatus</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>ServiceConfItemUserStatus</b>.
         *
         * @param value
         *            The ServiceConfItemUserStatuss to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder srvcConfItemUserStatus(
            ServiceConfItemUserStatus... value )
        {
            return toSrvcConfItemUserStatus(Lists.newArrayList(value));
        }

        private ServiceConfirmationItem.ServiceConfirmationItemBuilder toText(
            final List<ServiceConfirmationItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceConfirmationItem</b> to multiple
         * <b>ServiceConfirmationItemText</b>.
         *
         * @param value
         *            The ServiceConfirmationItemTexts to build this ServiceConfirmationItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceConfirmationItem.ServiceConfirmationItemBuilder text( ServiceConfirmationItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
