/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfirmationItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.ServiceConfirmationItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Text of Service Confirmation Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceConfirmationItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceConfirmationItemText extends VdmEntity<ServiceConfirmationItemText>
{

    /**
     * Selector for all available fields of ServiceConfirmationItemText.
     *
     */
    public final static ServiceConfirmationItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemTextField<String> SERVICE_CONFIRMATION =
        new ServiceConfirmationItemTextField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceConfirmationItem" )
    @JsonProperty( "ServiceConfirmationItem" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationItem" )
    private String serviceConfirmationItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationItem</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemTextField<String> SERVICE_CONFIRMATION_ITEM =
        new ServiceConfirmationItemTextField<String>("ServiceConfirmationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemTextField<String> LANGUAGE =
        new ServiceConfirmationItemTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemTextField<String> LONG_TEXT_ID =
        new ServiceConfirmationItemTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static ServiceConfirmationItemTextField<String> LONG_TEXT =
        new ServiceConfirmationItemTextField<String>("LongText");

    @Nonnull
    @Override
    public Class<ServiceConfirmationItemText> getType()
    {
        return ServiceConfirmationItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     */
    public void setServiceConfirmationItem( @Nullable final String serviceConfirmationItem )
    {
        rememberChangedField("ServiceConfirmationItem", this.serviceConfirmationItem);
        this.serviceConfirmationItem = serviceConfirmationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceConfirmationItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("ServiceConfirmationItem", getServiceConfirmationItem());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("ServiceConfirmationItem", getServiceConfirmationItem());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationItem") ) {
                final Object value = values.remove("ServiceConfirmationItem");
                if( (value == null) || (!value.equals(getServiceConfirmationItem())) ) {
                    setServiceConfirmationItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ServiceConfirmationItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ServiceConfirmationItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceConfirmationItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceConfirmationItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

}
