/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.SrvcConfAppointmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.SrvcConfAppointmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Service Confirmation Appointment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcConfAppointmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcConfAppointment extends VdmEntity<SrvcConfAppointment>
{

    /**
     * Selector for all available fields of SrvcConfAppointment.
     *
     */
    public final static SrvcConfAppointmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static SrvcConfAppointmentField<String> SERVICE_CONFIRMATION =
        new SrvcConfAppointmentField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocAppointmentType</b>
     * </p>
     *
     * @return Technical Date Type Name
     */
    @Key
    @SerializedName( "SrvcDocAppointmentType" )
    @JsonProperty( "SrvcDocAppointmentType" )
    @Nullable
    @ODataField( odataName = "SrvcDocAppointmentType" )
    private String srvcDocAppointmentType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocAppointmentType</b> field to query operations.
     *
     */
    public final static SrvcConfAppointmentField<String> SRVC_DOC_APPOINTMENT_TYPE =
        new SrvcConfAppointmentField<String>("SrvcDocAppointmentType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptStartDateTime</b>
     * </p>
     *
     * @return Time Stamp (UTC) of Start Time of Appointment
     */
    @SerializedName( "SrvcDocApptStartDateTime" )
    @JsonProperty( "SrvcDocApptStartDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocApptStartDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocApptStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocApptStartDateTime</b> field to query operations.
     *
     */
    public final static SrvcConfAppointmentField<ZonedDateTime> SRVC_DOC_APPT_START_DATE_TIME =
        new SrvcConfAppointmentField<ZonedDateTime>("SrvcDocApptStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptEndDateTime</b>
     * </p>
     *
     * @return Time stamp of end of appointment
     */
    @SerializedName( "SrvcDocApptEndDateTime" )
    @JsonProperty( "SrvcDocApptEndDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "SrvcDocApptEndDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime srvcDocApptEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcDocApptEndDateTime</b> field to query operations.
     *
     */
    public final static SrvcConfAppointmentField<ZonedDateTime> SRVC_DOC_APPT_END_DATE_TIME =
        new SrvcConfAppointmentField<ZonedDateTime>("SrvcDocApptEndDateTime");

    @Nonnull
    @Override
    public Class<SrvcConfAppointment> getType()
    {
        return SrvcConfAppointment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocAppointmentType</b>
     * </p>
     *
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     */
    public void setSrvcDocAppointmentType( @Nullable final String srvcDocAppointmentType )
    {
        rememberChangedField("SrvcDocAppointmentType", this.srvcDocAppointmentType);
        this.srvcDocAppointmentType = srvcDocAppointmentType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptStartDateTime</b>
     * </p>
     *
     * @param srvcDocApptStartDateTime
     *            Time Stamp (UTC) of Start Time of Appointment
     */
    public void setSrvcDocApptStartDateTime( @Nullable final ZonedDateTime srvcDocApptStartDateTime )
    {
        rememberChangedField("SrvcDocApptStartDateTime", this.srvcDocApptStartDateTime);
        this.srvcDocApptStartDateTime = srvcDocApptStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcDocApptEndDateTime</b>
     * </p>
     *
     * @param srvcDocApptEndDateTime
     *            Time stamp of end of appointment
     */
    public void setSrvcDocApptEndDateTime( @Nullable final ZonedDateTime srvcDocApptEndDateTime )
    {
        rememberChangedField("SrvcDocApptEndDateTime", this.srvcDocApptEndDateTime);
        this.srvcDocApptEndDateTime = srvcDocApptEndDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcConfAppointment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("SrvcDocAppointmentType", getSrvcDocAppointmentType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("SrvcDocAppointmentType", getSrvcDocAppointmentType());
        values.put("SrvcDocApptStartDateTime", getSrvcDocApptStartDateTime());
        values.put("SrvcDocApptEndDateTime", getSrvcDocApptEndDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("SrvcDocAppointmentType") ) {
                final Object value = values.remove("SrvcDocAppointmentType");
                if( (value == null) || (!value.equals(getSrvcDocAppointmentType())) ) {
                    setSrvcDocAppointmentType(((String) value));
                }
            }
            if( values.containsKey("SrvcDocApptStartDateTime") ) {
                final Object value = values.remove("SrvcDocApptStartDateTime");
                if( (value == null) || (!value.equals(getSrvcDocApptStartDateTime())) ) {
                    setSrvcDocApptStartDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("SrvcDocApptEndDateTime") ) {
                final Object value = values.remove("SrvcDocApptEndDateTime");
                if( (value == null) || (!value.equals(getSrvcDocApptEndDateTime())) ) {
                    setSrvcDocApptEndDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcConfAppointmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcConfAppointmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcConfAppointmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcConfAppointmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

}
