/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.SrvcConfItemAppointmentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
 * SrvcConfItemAppointment} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SrvcConfItemAppointmentByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcConfItemAppointmentByKeyFluentHelper, SrvcConfItemAppointment, SrvcConfItemAppointmentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcConfItemAppointment}
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param srvcDocAppointmentType
     *            Technical Date Type Name
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcConfItemAppointment}
     */
    public SrvcConfItemAppointmentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocAppointmentType )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("ServiceConfirmationItem", serviceConfirmationItem);
        this.key.put("SrvcDocAppointmentType", srvcDocAppointmentType);
    }

    @Override
    @Nonnull
    protected Class<SrvcConfItemAppointment> getEntityClass()
    {
        return SrvcConfItemAppointment.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
