/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.SrvcConfItemDurationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
 * SrvcConfItemDuration} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SrvcConfItemDurationByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcConfItemDurationByKeyFluentHelper, SrvcConfItemDuration, SrvcConfItemDurationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcConfItemDuration}
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcConfItemDuration}
     * @param srvcDocDurationType
     *            Name for Type of Time Duration
     *            <p>
     *            Constraints: Not nullable, Maximum length: 12
     *            </p>
     */
    public SrvcConfItemDurationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceConfirmation,
        final String serviceConfirmationItem,
        final String srvcDocDurationType )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("ServiceConfirmationItem", serviceConfirmationItem);
        this.key.put("SrvcDocDurationType", srvcDocDurationType);
    }

    @Override
    @Nonnull
    protected Class<SrvcConfItemDuration> getEntityClass()
    {
        return SrvcConfItemDuration.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
