/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.SrvcConfItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.SrvcConfItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.SrvcConfItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Confirmation Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcConfItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcConfItemPartner extends VdmEntity<SrvcConfItemPartner>
{

    /**
     * Selector for all available fields of SrvcConfItemPartner.
     *
     */
    public final static SrvcConfItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceConfirmation" )
    @JsonProperty( "ServiceConfirmation" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmation" )
    private String serviceConfirmation;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmation</b> field to query operations.
     *
     */
    public final static SrvcConfItemPartnerField<String> SERVICE_CONFIRMATION =
        new SrvcConfItemPartnerField<String>("ServiceConfirmation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceConfirmationItem" )
    @JsonProperty( "ServiceConfirmationItem" )
    @Nullable
    @ODataField( odataName = "ServiceConfirmationItem" )
    private String serviceConfirmationItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceConfirmationItem</b> field to query operations.
     *
     */
    public final static SrvcConfItemPartnerField<String> SERVICE_CONFIRMATION_ITEM =
        new SrvcConfItemPartnerField<String>("ServiceConfirmationItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerFunction</b>
     * </p>
     *
     * @return The custMgmtPartnerFunction contained in this entity.
     */
    @Key
    @SerializedName( "CustMgmtPartnerFunction" )
    @JsonProperty( "CustMgmtPartnerFunction" )
    @Nullable
    @ODataField( odataName = "CustMgmtPartnerFunction" )
    private String custMgmtPartnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtPartnerFunction</b> field to query operations.
     *
     */
    public final static SrvcConfItemPartnerField<String> CUST_MGMT_PARTNER_FUNCTION =
        new SrvcConfItemPartnerField<String>("CustMgmtPartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtBusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "CustMgmtBusinessPartner" )
    @JsonProperty( "CustMgmtBusinessPartner" )
    @Nullable
    @ODataField( odataName = "CustMgmtBusinessPartner" )
    private String custMgmtBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtBusinessPartner</b> field to query operations.
     *
     */
    public final static SrvcConfItemPartnerField<String> CUST_MGMT_BUSINESS_PARTNER =
        new SrvcConfItemPartnerField<String>("CustMgmtBusinessPartner");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @return Main Partner (For Ambiguous Partner Functions)
     */
    @SerializedName( "CustMgmtPartnerIsMainPartner" )
    @JsonProperty( "CustMgmtPartnerIsMainPartner" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CustMgmtPartnerIsMainPartner" )
    private Boolean custMgmtPartnerIsMainPartner;
    /**
     * Use with available fluent helpers to apply the <b>CustMgmtPartnerIsMainPartner</b> field to query operations.
     *
     */
    public final static SrvcConfItemPartnerField<Boolean> CUST_MGMT_PARTNER_IS_MAIN_PARTNER =
        new SrvcConfItemPartnerField<Boolean>("CustMgmtPartnerIsMainPartner");
    /**
     * Navigation property <b>to_Address</b> for <b>SrvcConfItemPartner</b> to single <b>SrvcConfItmPartnerAddress</b>.
     *
     */
    @SerializedName( "to_Address" )
    @JsonProperty( "to_Address" )
    @ODataField( odataName = "to_Address" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SrvcConfItmPartnerAddress toAddress;
    /**
     * Use with available fluent helpers to apply the <b>to_Address</b> navigation property to query operations.
     *
     */
    public final static SrvcConfItemPartnerOneToOneLink<SrvcConfItmPartnerAddress> TO_ADDRESS =
        new SrvcConfItemPartnerOneToOneLink<SrvcConfItmPartnerAddress>("to_Address");

    @Nonnull
    @Override
    public Class<SrvcConfItemPartner> getType()
    {
        return SrvcConfItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmation</b>
     * </p>
     *
     * @param serviceConfirmation
     *            Transaction ID
     */
    public void setServiceConfirmation( @Nullable final String serviceConfirmation )
    {
        rememberChangedField("ServiceConfirmation", this.serviceConfirmation);
        this.serviceConfirmation = serviceConfirmation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceConfirmationItem</b>
     * </p>
     *
     * @param serviceConfirmationItem
     *            Shortened Item Number in Document
     */
    public void setServiceConfirmationItem( @Nullable final String serviceConfirmationItem )
    {
        rememberChangedField("ServiceConfirmationItem", this.serviceConfirmationItem);
        this.serviceConfirmationItem = serviceConfirmationItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerFunction</b>
     * </p>
     *
     * @param custMgmtPartnerFunction
     *            The custMgmtPartnerFunction to set.
     */
    public void setCustMgmtPartnerFunction( @Nullable final String custMgmtPartnerFunction )
    {
        rememberChangedField("CustMgmtPartnerFunction", this.custMgmtPartnerFunction);
        this.custMgmtPartnerFunction = custMgmtPartnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtBusinessPartner</b>
     * </p>
     *
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     */
    public void setCustMgmtBusinessPartner( @Nullable final String custMgmtBusinessPartner )
    {
        rememberChangedField("CustMgmtBusinessPartner", this.custMgmtBusinessPartner);
        this.custMgmtBusinessPartner = custMgmtBusinessPartner;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CustMgmtPartnerIsMainPartner</b>
     * </p>
     *
     * @param custMgmtPartnerIsMainPartner
     *            Main Partner (For Ambiguous Partner Functions)
     */
    public void setCustMgmtPartnerIsMainPartner( @Nullable final Boolean custMgmtPartnerIsMainPartner )
    {
        rememberChangedField("CustMgmtPartnerIsMainPartner", this.custMgmtPartnerIsMainPartner);
        this.custMgmtPartnerIsMainPartner = custMgmtPartnerIsMainPartner;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcConfItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceConfirmation", getServiceConfirmation());
        result.put("ServiceConfirmationItem", getServiceConfirmationItem());
        result.put("CustMgmtPartnerFunction", getCustMgmtPartnerFunction());
        result.put("CustMgmtBusinessPartner", getCustMgmtBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceConfirmation", getServiceConfirmation());
        values.put("ServiceConfirmationItem", getServiceConfirmationItem());
        values.put("CustMgmtPartnerFunction", getCustMgmtPartnerFunction());
        values.put("CustMgmtBusinessPartner", getCustMgmtBusinessPartner());
        values.put("CustMgmtPartnerIsMainPartner", getCustMgmtPartnerIsMainPartner());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceConfirmation") ) {
                final Object value = values.remove("ServiceConfirmation");
                if( (value == null) || (!value.equals(getServiceConfirmation())) ) {
                    setServiceConfirmation(((String) value));
                }
            }
            if( values.containsKey("ServiceConfirmationItem") ) {
                final Object value = values.remove("ServiceConfirmationItem");
                if( (value == null) || (!value.equals(getServiceConfirmationItem())) ) {
                    setServiceConfirmationItem(((String) value));
                }
            }
            if( values.containsKey("CustMgmtPartnerFunction") ) {
                final Object value = values.remove("CustMgmtPartnerFunction");
                if( (value == null) || (!value.equals(getCustMgmtPartnerFunction())) ) {
                    setCustMgmtPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("CustMgmtBusinessPartner") ) {
                final Object value = values.remove("CustMgmtBusinessPartner");
                if( (value == null) || (!value.equals(getCustMgmtBusinessPartner())) ) {
                    setCustMgmtBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("CustMgmtPartnerIsMainPartner") ) {
                final Object value = values.remove("CustMgmtPartnerIsMainPartner");
                if( (value == null) || (!value.equals(getCustMgmtPartnerIsMainPartner())) ) {
                    setCustMgmtPartnerIsMainPartner(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Address") ) {
                final Object value = (values).remove("to_Address");
                if( value instanceof Map ) {
                    if( toAddress == null ) {
                        toAddress = new SrvcConfItmPartnerAddress();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toAddress.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SrvcConfItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SrvcConfItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcConfItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcConfItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAddress != null ) {
            (values).put("to_Address", toAddress);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcConfItmPartnerAddress</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Address</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SrvcConfItmPartnerAddress</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SrvcConfItmPartnerAddress fetchAddress()
    {
        return fetchFieldAsSingle("to_Address", SrvcConfItmPartnerAddress.class);
    }

    /**
     * Retrieval of associated <b>SrvcConfItmPartnerAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>SrvcConfItemPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcConfItmPartnerAddress</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SrvcConfItmPartnerAddress getAddressOrFetch()
    {
        if( toAddress == null ) {
            toAddress = fetchAddress();
        }
        return toAddress;
    }

    /**
     * Retrieval of associated <b>SrvcConfItmPartnerAddress</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcConfItemPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Address</b> is already loaded, the result will contain
     *         the <b>SrvcConfItmPartnerAddress</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SrvcConfItmPartnerAddress> getAddressIfPresent()
    {
        return Option.of(toAddress);
    }

    /**
     * Overwrites the associated <b>SrvcConfItmPartnerAddress</b> entity for the loaded navigation property
     * <b>to_Address</b>.
     *
     * @param value
     *            New <b>SrvcConfItmPartnerAddress</b> entity.
     */
    public void setAddress( final SrvcConfItmPartnerAddress value )
    {
        toAddress = value;
    }

    /**
     * Helper class to allow for fluent creation of SrvcConfItemPartner instances.
     *
     */
    public final static class SrvcConfItemPartnerBuilder
    {

        private SrvcConfItmPartnerAddress toAddress;

        private SrvcConfItemPartner.SrvcConfItemPartnerBuilder toAddress( final SrvcConfItmPartnerAddress value )
        {
            toAddress = value;
            return this;
        }

        /**
         * Navigation property <b>to_Address</b> for <b>SrvcConfItemPartner</b> to single
         * <b>SrvcConfItmPartnerAddress</b>.
         *
         * @param value
         *            The SrvcConfItmPartnerAddress to build this SrvcConfItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcConfItemPartner.SrvcConfItemPartnerBuilder address( final SrvcConfItmPartnerAddress value )
        {
            return toAddress(value);
        }

    }

}
