/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable.SrvcConfPartnerAddressSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
 * SrvcConfPartnerAddress} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SrvcConfPartnerAddressByKeyFluentHelper
    extends
    FluentHelperByKey<SrvcConfPartnerAddressByKeyFluentHelper, SrvcConfPartnerAddress, SrvcConfPartnerAddressSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     * SrvcConfPartnerAddress} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SrvcConfPartnerAddress}
     * @param custMgmtBusinessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param serviceConfirmation
     *            Transaction ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param custMgmtPartnerFunction
     *
     * @param servicePath
     *            Service path to be used to fetch a single {@code SrvcConfPartnerAddress}
     */
    public SrvcConfPartnerAddressByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String serviceConfirmation,
        final String custMgmtPartnerFunction,
        final String custMgmtBusinessPartner )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceConfirmation", serviceConfirmation);
        this.key.put("CustMgmtPartnerFunction", custMgmtPartnerFunction);
        this.key.put("CustMgmtBusinessPartner", custMgmtBusinessPartner);
    }

    @Override
    @Nonnull
    protected Class<SrvcConfPartnerAddress> getEntityClass()
    {
        return SrvcConfPartnerAddress.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
