/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress;

/**
 * Implementation of the {@link ServiceConfirmationServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService ServiceConfirmationService}.
 *
 */
public class DefaultServiceConfirmationServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ServiceConfirmationServiceBatch, ServiceConfirmationServiceBatchChangeSet>
    implements
    ServiceConfirmationServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService service;

    @SuppressWarnings( "deprecation" )
    DefaultServiceConfirmationServiceBatchChangeSet(
        @Nonnull final DefaultServiceConfirmationServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultServiceConfirmationServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfirmation(
        @Nonnull final ServiceConfirmation serviceConfirmation )
    {
        return addRequestCreate(service::createServiceConfirmation, serviceConfirmation);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfirmation(
        @Nonnull final ServiceConfirmation serviceConfirmation )
    {
        return addRequestUpdate(service::updateServiceConfirmation, serviceConfirmation);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return addRequestCreate(service::createServiceConfirmationItem, serviceConfirmationItem);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return addRequestUpdate(service::updateServiceConfirmationItem, serviceConfirmationItem);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfirmationItem(
        @Nonnull final ServiceConfirmationItem serviceConfirmationItem )
    {
        return addRequestDelete(service::deleteServiceConfirmationItem, serviceConfirmationItem);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return addRequestCreate(service::createServiceConfirmationItemText, serviceConfirmationItemText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return addRequestUpdate(service::updateServiceConfirmationItemText, serviceConfirmationItemText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfirmationItemText(
        @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText )
    {
        return addRequestDelete(service::deleteServiceConfirmationItemText, serviceConfirmationItemText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return addRequestCreate(service::createServiceConfirmationText, serviceConfirmationText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return addRequestUpdate(service::updateServiceConfirmationText, serviceConfirmationText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfirmationText(
        @Nonnull final ServiceConfirmationText serviceConfirmationText )
    {
        return addRequestDelete(service::deleteServiceConfirmationText, serviceConfirmationText);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfItemPriceElement(
        @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement )
    {
        return addRequestCreate(service::createServiceConfItemPriceElement, serviceConfItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfItemPriceElement(
        @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement )
    {
        return addRequestUpdate(service::updateServiceConfItemPriceElement, serviceConfItemPriceElement);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfItemUserStatus(
        @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus )
    {
        return addRequestCreate(service::createServiceConfItemUserStatus, serviceConfItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfItemUserStatus(
        @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus )
    {
        return addRequestDelete(service::deleteServiceConfItemUserStatus, serviceConfItemUserStatus);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfItmRefObject(
        @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject )
    {
        return addRequestCreate(service::createServiceConfItmRefObject, serviceConfItmRefObject);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfItmRefObject(
        @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject )
    {
        return addRequestDelete(service::deleteServiceConfItmRefObject, serviceConfItmRefObject);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return addRequestCreate(service::createServiceConfPersonResp, serviceConfPersonResp);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return addRequestUpdate(service::updateServiceConfPersonResp, serviceConfPersonResp);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfPersonResp(
        @Nonnull final ServiceConfPersonResp serviceConfPersonResp )
    {
        return addRequestDelete(service::deleteServiceConfPersonResp, serviceConfPersonResp);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfPriceElement(
        @Nonnull final ServiceConfPriceElement serviceConfPriceElement )
    {
        return addRequestCreate(service::createServiceConfPriceElement, serviceConfPriceElement);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateServiceConfPriceElement(
        @Nonnull final ServiceConfPriceElement serviceConfPriceElement )
    {
        return addRequestUpdate(service::updateServiceConfPriceElement, serviceConfPriceElement);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfRefObject(
        @Nonnull final ServiceConfRefObject serviceConfRefObject )
    {
        return addRequestCreate(service::createServiceConfRefObject, serviceConfRefObject);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfRefObject(
        @Nonnull final ServiceConfRefObject serviceConfRefObject )
    {
        return addRequestDelete(service::deleteServiceConfRefObject, serviceConfRefObject);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createServiceConfUserStatus(
        @Nonnull final ServiceConfUserStatus serviceConfUserStatus )
    {
        return addRequestCreate(service::createServiceConfUserStatus, serviceConfUserStatus);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteServiceConfUserStatus(
        @Nonnull final ServiceConfUserStatus serviceConfUserStatus )
    {
        return addRequestDelete(service::deleteServiceConfUserStatus, serviceConfUserStatus);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfAppointment(
        @Nonnull final SrvcConfAppointment srvcConfAppointment )
    {
        return addRequestCreate(service::createSrvcConfAppointment, srvcConfAppointment);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfAppointment(
        @Nonnull final SrvcConfAppointment srvcConfAppointment )
    {
        return addRequestUpdate(service::updateSrvcConfAppointment, srvcConfAppointment);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfDuration(
        @Nonnull final SrvcConfDuration srvcConfDuration )
    {
        return addRequestCreate(service::createSrvcConfDuration, srvcConfDuration);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfDuration(
        @Nonnull final SrvcConfDuration srvcConfDuration )
    {
        return addRequestUpdate(service::updateSrvcConfDuration, srvcConfDuration);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfItemAppointment(
        @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment )
    {
        return addRequestCreate(service::createSrvcConfItemAppointment, srvcConfItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfItemAppointment(
        @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment )
    {
        return addRequestUpdate(service::updateSrvcConfItemAppointment, srvcConfItemAppointment);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfItemDuration(
        @Nonnull final SrvcConfItemDuration srvcConfItemDuration )
    {
        return addRequestCreate(service::createSrvcConfItemDuration, srvcConfItemDuration);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfItemDuration(
        @Nonnull final SrvcConfItemDuration srvcConfItemDuration )
    {
        return addRequestUpdate(service::updateSrvcConfItemDuration, srvcConfItemDuration);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return addRequestCreate(service::createSrvcConfItemPartner, srvcConfItemPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return addRequestUpdate(service::updateSrvcConfItemPartner, srvcConfItemPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteSrvcConfItemPartner(
        @Nonnull final SrvcConfItemPartner srvcConfItemPartner )
    {
        return addRequestDelete(service::deleteSrvcConfItemPartner, srvcConfItemPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfItmPartnerAddress(
        @Nonnull final SrvcConfItmPartnerAddress srvcConfItmPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcConfItmPartnerAddress, srvcConfItmPartnerAddress);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet createSrvcConfPartner(
        @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return addRequestCreate(service::createSrvcConfPartner, srvcConfPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfPartner(
        @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return addRequestUpdate(service::updateSrvcConfPartner, srvcConfPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet deleteSrvcConfPartner(
        @Nonnull final SrvcConfPartner srvcConfPartner )
    {
        return addRequestDelete(service::deleteSrvcConfPartner, srvcConfPartner);
    }

    @Nonnull
    @Override
    public ServiceConfirmationServiceBatchChangeSet updateSrvcConfPartnerAddress(
        @Nonnull final SrvcConfPartnerAddress srvcConfPartnerAddress )
    {
        return addRequestUpdate(service::updateSrvcConfPartnerAddress, srvcConfPartnerAddress);
    }

}
