/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceConfirmationService
 * ServiceConfirmationService}.
 *
 */
public interface ServiceConfirmationServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ServiceConfirmationServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ServiceConfirmationServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *            ServiceConfirmation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfirmation( @Nonnull final ServiceConfirmation serviceConfirmation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     * ServiceConfirmation} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmation
     *            ServiceConfirmation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfirmation( @Nonnull final ServiceConfirmation serviceConfirmation );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     * ServiceConfirmationItem} entity in the S/4HANA system.
     *
     * @param serviceConfirmationItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItem
     *            ServiceConfirmationItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfirmationItem( @Nonnull final ServiceConfirmationItem serviceConfirmationItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     * ServiceConfirmationItemText} entity in the S/4HANA system.
     *
     * @param serviceConfirmationItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationItemText
     *            ServiceConfirmationItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfirmationItemText( @Nonnull final ServiceConfirmationItemText serviceConfirmationItemText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity and save it to the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     * ServiceConfirmationText} entity in the S/4HANA system.
     *
     * @param serviceConfirmationText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfirmationText
     *            ServiceConfirmationText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfirmationText( @Nonnull final ServiceConfirmationText serviceConfirmationText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *            ServiceConfItemPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfItemPriceElement( @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     * ServiceConfItemPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemPriceElement
     *            ServiceConfItemPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfItemPriceElement( @Nonnull final ServiceConfItemPriceElement serviceConfItemPriceElement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *            ServiceConfItemUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfItemUserStatus( @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     * ServiceConfItemUserStatus} entity in the S/4HANA system.
     *
     * @param serviceConfItemUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItemUserStatus
     *            ServiceConfItemUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfItemUserStatus( @Nonnull final ServiceConfItemUserStatus serviceConfItemUserStatus );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceConfItmRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *            ServiceConfItmRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfItmRefObject( @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     * ServiceConfItmRefObject} entity in the S/4HANA system.
     *
     * @param serviceConfItmRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
     *            ServiceConfItmRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfItmRefObject( @Nonnull final ServiceConfItmRefObject serviceConfItmRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     * ServiceConfPersonResp} entity in the S/4HANA system.
     *
     * @param serviceConfPersonResp
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
     *            ServiceConfPersonResp} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfPersonResp( @Nonnull final ServiceConfPersonResp serviceConfPersonResp );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *            ServiceConfPriceElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfPriceElement( @Nonnull final ServiceConfPriceElement serviceConfPriceElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     * ServiceConfPriceElement} entity and save it to the S/4HANA system.
     *
     * @param serviceConfPriceElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
     *            ServiceConfPriceElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateServiceConfPriceElement( @Nonnull final ServiceConfPriceElement serviceConfPriceElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity and save it to the S/4HANA system.
     *
     * @param serviceConfRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *            ServiceConfRefObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfRefObject( @Nonnull final ServiceConfRefObject serviceConfRefObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     * ServiceConfRefObject} entity in the S/4HANA system.
     *
     * @param serviceConfRefObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfRefObject
     *            ServiceConfRefObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfRefObject( @Nonnull final ServiceConfRefObject serviceConfRefObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entity and save it to the S/4HANA system.
     *
     * @param serviceConfUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *            ServiceConfUserStatus} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createServiceConfUserStatus( @Nonnull final ServiceConfUserStatus serviceConfUserStatus );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     * ServiceConfUserStatus} entity in the S/4HANA system.
     *
     * @param serviceConfUserStatus
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfUserStatus
     *            ServiceConfUserStatus} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteServiceConfUserStatus( @Nonnull final ServiceConfUserStatus serviceConfUserStatus );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *            SrvcConfAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createSrvcConfAppointment( @Nonnull final SrvcConfAppointment srvcConfAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     * SrvcConfAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
     *            SrvcConfAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfAppointment( @Nonnull final SrvcConfAppointment srvcConfAppointment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     * SrvcConfDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *            SrvcConfDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet createSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration SrvcConfDuration}
     * entity and save it to the S/4HANA system.
     *
     * @param srvcConfDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfDuration
     *            SrvcConfDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet updateSrvcConfDuration( @Nonnull final SrvcConfDuration srvcConfDuration );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *            SrvcConfItemAppointment} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createSrvcConfItemAppointment( @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     * SrvcConfItemAppointment} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemAppointment
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemAppointment
     *            SrvcConfItemAppointment} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfItemAppointment( @Nonnull final SrvcConfItemAppointment srvcConfItemAppointment );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *            SrvcConfItemDuration} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createSrvcConfItemDuration( @Nonnull final SrvcConfItemDuration srvcConfItemDuration );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     * SrvcConfItemDuration} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemDuration
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
     *            SrvcConfItemDuration} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfItemDuration( @Nonnull final SrvcConfItemDuration srvcConfItemDuration );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        createSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     * SrvcConfItemPartner} entity in the S/4HANA system.
     *
     * @param srvcConfItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemPartner
     *            SrvcConfItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        deleteSrvcConfItemPartner( @Nonnull final SrvcConfItemPartner srvcConfItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     * SrvcConfItmPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcConfItmPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItmPartnerAddress
     *            SrvcConfItmPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfItmPartnerAddress( @Nonnull final SrvcConfItmPartnerAddress srvcConfItmPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet createSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     * SrvcConfPartner} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet updateSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner SrvcConfPartner}
     * entity in the S/4HANA system.
     *
     * @param srvcConfPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartner
     *            SrvcConfPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet deleteSrvcConfPartner( @Nonnull final SrvcConfPartner srvcConfPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     * SrvcConfPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param srvcConfPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfPartnerAddress
     *            SrvcConfPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ServiceConfirmationServiceBatchChangeSet
        updateSrvcConfPartnerAddress( @Nonnull final SrvcConfPartnerAddress srvcConfPartnerAddress );

}
