/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject
 * ServiceConfItmRefObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfItmRefObjectField
 * ServiceConfItmRefObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfItmRefObjectLink
 * ServiceConfItmRefObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject#SERVICE_CONFIRMATION
 * SERVICE_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject#SERVICE_CONFIRMATION_ITEM
 * SERVICE_CONFIRMATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject#SERVICE_REFERENCE_EQUIPMENT
 * SERVICE_REFERENCE_EQUIPMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject#SERVICE_REF_FUNCTIONAL_LOCATION
 * SERVICE_REF_FUNCTIONAL_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfItmRefObject#SRVC_REF_OBJ_IS_MAIN_OBJECT
 * SRVC_REF_OBJ_IS_MAIN_OBJECT}</li>
 * </ul>
 *
 */
public interface ServiceConfItmRefObjectSelectable extends EntitySelectable<ServiceConfItmRefObject>
{

}
