/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp
 * ServiceConfPersonResp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfPersonRespField
 * ServiceConfPersonRespField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfPersonRespLink
 * ServiceConfPersonRespLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp#SERVICE_CONFIRMATION
 * SERVICE_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp#PERSON_RESPONSIBLE
 * PERSON_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPersonResp#CUST_MGMT_PARTNER_IS_MAIN_PARTNER
 * CUST_MGMT_PARTNER_IS_MAIN_PARTNER}</li>
 * </ul>
 *
 */
public interface ServiceConfPersonRespSelectable extends EntitySelectable<ServiceConfPersonResp>
{

}
