/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement
 * ServiceConfPriceElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.ServiceConfPriceElementField
 * ServiceConfPriceElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.ServiceConfPriceElementLink
 * ServiceConfPriceElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#SERVICE_CONFIRMATION
 * SERVICE_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#CONDITION_RATE_VALUE
 * CONDITION_RATE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#CONDITION_CURRENCY
 * CONDITION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#CONDITION_QUANTITY
 * CONDITION_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.ServiceConfPriceElement#CONDITION_QUANTITY_UNIT
 * CONDITION_QUANTITY_UNIT}</li>
 * </ul>
 *
 */
public interface ServiceConfPriceElementSelectable extends EntitySelectable<ServiceConfPriceElement>
{

}
