/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment
 * SrvcConfAppointment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.SrvcConfAppointmentField
 * SrvcConfAppointmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.SrvcConfAppointmentLink
 * SrvcConfAppointmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment#SERVICE_CONFIRMATION
 * SERVICE_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment#SRVC_DOC_APPOINTMENT_TYPE
 * SRVC_DOC_APPOINTMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment#SRVC_DOC_APPT_START_DATE_TIME
 * SRVC_DOC_APPT_START_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfAppointment#SRVC_DOC_APPT_END_DATE_TIME
 * SRVC_DOC_APPT_END_DATE_TIME}</li>
 * </ul>
 *
 */
public interface SrvcConfAppointmentSelectable extends EntitySelectable<SrvcConfAppointment>
{

}
