/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration
 * SrvcConfItemDuration}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.field.SrvcConfItemDurationField
 * SrvcConfItemDurationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.link.SrvcConfItemDurationLink
 * SrvcConfItemDurationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration#SERVICE_CONFIRMATION
 * SERVICE_CONFIRMATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration#SERVICE_CONFIRMATION_ITEM
 * SERVICE_CONFIRMATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration#SRVC_DOC_DURATION_TYPE
 * SRVC_DOC_DURATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration#SRVC_DOC_DURATION_VALUE
 * SRVC_DOC_DURATION_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.serviceconfirmation.SrvcConfItemDuration#SRVC_DOC_DURATION_UNIT
 * SRVC_DOC_DURATION_UNIT}</li>
 * </ul>
 *
 */
public interface SrvcConfItemDurationSelectable extends EntitySelectable<SrvcConfItemDuration>
{

}
