/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContrItemPriceElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContrItemPriceElementOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.ServiceContrItemPriceElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Price Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceContrItemPriceElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceContrItemPriceElement extends VdmEntity<ServiceContrItemPriceElement>
{

    /**
     * Selector for all available fields of ServiceContrItemPriceElement.
     *
     */
    public final static ServiceContrItemPriceElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> SERVICE_CONTRACT =
        new ServiceContrItemPriceElementField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> SERVICE_CONTRACT_ITEM =
        new ServiceContrItemPriceElementField<String>("ServiceContractItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> PRICING_PROCEDURE_STEP =
        new ServiceContrItemPriceElementField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> PRICING_PROCEDURE_COUNTER =
        new ServiceContrItemPriceElementField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> CONDITION_TYPE =
        new ServiceContrItemPriceElementField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<BigDecimal> CONDITION_RATE_VALUE =
        new ServiceContrItemPriceElementField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> CONDITION_CURRENCY =
        new ServiceContrItemPriceElementField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<BigDecimal> CONDITION_QUANTITY =
        new ServiceContrItemPriceElementField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit in the Document
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> CONDITION_QUANTITY_UNIT =
        new ServiceContrItemPriceElementField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @return Condition is Inactive
     */
    @SerializedName( "ConditionInactiveReason" )
    @JsonProperty( "ConditionInactiveReason" )
    @Nullable
    @ODataField( odataName = "ConditionInactiveReason" )
    private String conditionInactiveReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionInactiveReason</b> field to query operations.
     *
     */
    public final static ServiceContrItemPriceElementField<String> CONDITION_INACTIVE_REASON =
        new ServiceContrItemPriceElementField<String>("ConditionInactiveReason");
    /**
     * Navigation property <b>to_ServiceContractItem</b> for <b>ServiceContrItemPriceElement</b> to single
     * <b>ServiceContractItem</b>.
     *
     */
    @SerializedName( "to_ServiceContractItem" )
    @JsonProperty( "to_ServiceContractItem" )
    @ODataField( odataName = "to_ServiceContractItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceContractItem toServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContractItem</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceContrItemPriceElementOneToOneLink<ServiceContractItem> TO_SERVICE_CONTRACT_ITEM =
        new ServiceContrItemPriceElementOneToOneLink<ServiceContractItem>("to_ServiceContractItem");

    @Nonnull
    @Override
    public Class<ServiceContrItemPriceElement> getType()
    {
        return ServiceContrItemPriceElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceContrItemPriceElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("ServiceContractItem", getServiceContractItem());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionType", getConditionType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ServiceContractItem") ) {
                final Object value = (values).remove("to_ServiceContractItem");
                if( value instanceof Map ) {
                    if( toServiceContractItem == null ) {
                        toServiceContractItem = new ServiceContractItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContractItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ServiceContrItemPriceElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ServiceContrItemPriceElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceContrItemPriceElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceContrItemPriceElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toServiceContractItem != null ) {
            (values).put("to_ServiceContractItem", toServiceContractItem);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceContractItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ServiceContractItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceContractItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem fetchServiceContractItem()
    {
        return fetchFieldAsSingle("to_ServiceContractItem", ServiceContractItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property <b>to_ServiceContractItem</b> of a queried <b>ServiceContrItemPriceElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContractItem getServiceContractItemOrFetch()
    {
        if( toServiceContractItem == null ) {
            toServiceContractItem = fetchServiceContractItem();
        }
        return toServiceContractItem;
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContractItem</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContrItemPriceElement</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContractItem</b> is already loaded, the result
     *         will contain the <b>ServiceContractItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceContractItem> getServiceContractItemIfPresent()
    {
        return Option.of(toServiceContractItem);
    }

    /**
     * Overwrites the associated <b>ServiceContractItem</b> entity for the loaded navigation property
     * <b>to_ServiceContractItem</b>.
     *
     * @param value
     *            New <b>ServiceContractItem</b> entity.
     */
    public void setServiceContractItem( final ServiceContractItem value )
    {
        toServiceContractItem = value;
    }

    /**
     * Helper class to allow for fluent creation of ServiceContrItemPriceElement instances.
     *
     */
    public final static class ServiceContrItemPriceElementBuilder
    {

        private ServiceContractItem toServiceContractItem;
        private String serviceContractItem = null;

        private ServiceContrItemPriceElement.ServiceContrItemPriceElementBuilder toServiceContractItem(
            final ServiceContractItem value )
        {
            toServiceContractItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContractItem</b> for <b>ServiceContrItemPriceElement</b> to single
         * <b>ServiceContractItem</b>.
         *
         * @param value
         *            The ServiceContractItem to build this ServiceContrItemPriceElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContrItemPriceElement.ServiceContrItemPriceElementBuilder serviceContractItem(
            final ServiceContractItem value )
        {
            return toServiceContractItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>ServiceContractItem</b>
         * </p>
         *
         * @param value
         *            The serviceContractItem to build this ServiceContrItemPriceElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContrItemPriceElement.ServiceContrItemPriceElementBuilder serviceContractItem(
            final String value )
        {
            serviceContractItem = value;
            return this;
        }

    }

}
