/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.ServiceContrItmReleasedOrderSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
 * ServiceContrItmReleasedOrder} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class ServiceContrItmReleasedOrderByKeyFluentHelper
    extends
    FluentHelperByKey<ServiceContrItmReleasedOrderByKeyFluentHelper, ServiceContrItmReleasedOrder, ServiceContrItmReleasedOrderSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.ServiceContrItmReleasedOrder
     * ServiceContrItmReleasedOrder} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ServiceContrItmReleasedOrder}
     * @param serviceDocumentItmRelationUUID
     *            Object Relationship Service : GUID binary link
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code ServiceContrItmReleasedOrder}
     * @param serviceDocItmRltnSqncNumber
     *            Sequential Number of Segment in IDoc Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public ServiceContrItmReleasedOrderByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID serviceDocumentItmRelationUUID,
        final String serviceDocItmRltnSqncNumber )
    {
        super(servicePath, entityCollection);
        this.key.put("ServiceDocumentItmRelationUUID", serviceDocumentItmRelationUUID);
        this.key.put("ServiceDocItmRltnSqncNumber", serviceDocItmRltnSqncNumber);
    }

    @Override
    @Nonnull
    protected Class<ServiceContrItmReleasedOrder> getEntityClass()
    {
        return ServiceContrItmReleasedOrder.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
