/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContractField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.ServiceContractSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Contract Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceContractType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceContract extends VdmEntity<ServiceContract>
{

    /**
     * Selector for all available fields of ServiceContract.
     *
     */
    public final static ServiceContractSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT =
        new ServiceContractField<String>("ServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractType</b>
     * </p>
     *
     * @return Business Transaction Type
     */
    @SerializedName( "ServiceContractType" )
    @JsonProperty( "ServiceContractType" )
    @Nullable
    @ODataField( odataName = "ServiceContractType" )
    private String serviceContractType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractType</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT_TYPE =
        new ServiceContractField<String>("ServiceContractType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractDescription</b>
     * </p>
     *
     * @return Transaction Description
     */
    @SerializedName( "ServiceContractDescription" )
    @JsonProperty( "ServiceContractDescription" )
    @Nullable
    @ODataField( odataName = "ServiceContractDescription" )
    private String serviceContractDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractDescription</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT_DESCRIPTION =
        new ServiceContractField<String>("ServiceContractDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key of Description
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> LANGUAGE = new ServiceContractField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractStartDateTime</b>
     * </p>
     *
     * @return Contract Start date
     */
    @SerializedName( "ServiceContractStartDateTime" )
    @JsonProperty( "ServiceContractStartDateTime" )
    @Nullable
    @ODataField( odataName = "ServiceContractStartDateTime" )
    private BigDecimal serviceContractStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SERVICE_CONTRACT_START_DATE_TIME =
        new ServiceContractField<BigDecimal>("ServiceContractStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractEndDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "ServiceContractEndDateTime" )
    @JsonProperty( "ServiceContractEndDateTime" )
    @Nullable
    @ODataField( odataName = "ServiceContractEndDateTime" )
    private BigDecimal serviceContractEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SERVICE_CONTRACT_END_DATE_TIME =
        new ServiceContractField<BigDecimal>("ServiceContractEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Sold-To Party's External Reference Number
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new ServiceContractField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Reference Document Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static ServiceContractField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new ServiceContractField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @return Total Gross Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocGrossAmount" )
    @JsonProperty( "ServiceDocGrossAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocGrossAmount" )
    private BigDecimal serviceDocGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocGrossAmount</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SERVICE_DOC_GROSS_AMOUNT =
        new ServiceContractField<BigDecimal>("ServiceDocGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @return Total Net Value of Document in Document Currency
     */
    @SerializedName( "ServiceDocNetAmount" )
    @JsonProperty( "ServiceDocNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocNetAmount" )
    private BigDecimal serviceDocNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocNetAmount</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SERVICE_DOC_NET_AMOUNT =
        new ServiceContractField<BigDecimal>("ServiceDocNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @return Total Tax Amount in Document Currency
     */
    @SerializedName( "ServiceDocTaxAmount" )
    @JsonProperty( "ServiceDocTaxAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocTaxAmount" )
    private BigDecimal serviceDocTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocTaxAmount</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SERVICE_DOC_TAX_AMOUNT =
        new ServiceContractField<BigDecimal>("ServiceDocTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> TRANSACTION_CURRENCY =
        new ServiceContractField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ServiceContractIsReleased" )
    @JsonProperty( "ServiceContractIsReleased" )
    @Nullable
    @ODataField( odataName = "ServiceContractIsReleased" )
    private String serviceContractIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractIsReleased</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT_IS_RELEASED =
        new ServiceContractField<String>("ServiceContractIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractIsCompleted</b>
     * </p>
     *
     * @return The serviceContractIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceContractIsCompleted" )
    @JsonProperty( "ServiceContractIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceContractIsCompleted" )
    private String serviceContractIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT_IS_COMPLETED =
        new ServiceContractField<String>("ServiceContractIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrCreditStatus</b>
     * </p>
     *
     * @return Credit Status of Header
     */
    @SerializedName( "SrvcContrCreditStatus" )
    @JsonProperty( "SrvcContrCreditStatus" )
    @Nullable
    @ODataField( odataName = "SrvcContrCreditStatus" )
    private String srvcContrCreditStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrCreditStatus</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SRVC_CONTR_CREDIT_STATUS =
        new ServiceContractField<String>("SrvcContrCreditStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SALES_ORGANIZATION =
        new ServiceContractField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> DISTRIBUTION_CHANNEL =
        new ServiceContractField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> DIVISION = new ServiceContractField<String>("Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SALES_OFFICE = new ServiceContractField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SALES_GROUP = new ServiceContractField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-To Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SOLD_TO_PARTY = new ServiceContractField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SHIP_TO_PARTY = new ServiceContractField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> BILL_TO_PARTY = new ServiceContractField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> PAYER_PARTY = new ServiceContractField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> CONTACT_PERSON = new ServiceContractField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> PERSON_RESPONSIBLE =
        new ServiceContractField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractCanclnParty</b>
     * </p>
     *
     * @return Cancelling Party
     */
    @SerializedName( "ServiceContractCanclnParty" )
    @JsonProperty( "ServiceContractCanclnParty" )
    @Nullable
    @ODataField( odataName = "ServiceContractCanclnParty" )
    private String serviceContractCanclnParty;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractCanclnParty</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTRACT_CANCLN_PARTY =
        new ServiceContractField<String>("ServiceContractCanclnParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrCancellationReason</b>
     * </p>
     *
     * @return CRM Service : Reason for Cancellation
     */
    @SerializedName( "ServiceContrCancellationReason" )
    @JsonProperty( "ServiceContrCancellationReason" )
    @Nullable
    @ODataField( odataName = "ServiceContrCancellationReason" )
    private String serviceContrCancellationReason;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContrCancellationReason</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> SERVICE_CONTR_CANCELLATION_REASON =
        new ServiceContractField<String>("ServiceContrCancellationReason");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrCancellationDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "SrvcContrCancellationDateTime" )
    @JsonProperty( "SrvcContrCancellationDateTime" )
    @Nullable
    @ODataField( odataName = "SrvcContrCancellationDateTime" )
    private BigDecimal srvcContrCancellationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrCancellationDateTime</b> field to query operations.
     *
     */
    public final static ServiceContractField<BigDecimal> SRVC_CONTR_CANCELLATION_DATE_TIME =
        new ServiceContractField<BigDecimal>("SrvcContrCancellationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceContract" )
    @JsonProperty( "ReferenceServiceContract" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContract" )
    private String referenceServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContract</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> REFERENCE_SERVICE_CONTRACT =
        new ServiceContractField<String>("ReferenceServiceContract");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceQtan</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceQtan" )
    @JsonProperty( "ReferenceServiceQtan" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceQtan" )
    private String referenceServiceQtan;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceQtan</b> field to query operations.
     *
     */
    public final static ServiceContractField<String> REFERENCE_SERVICE_QTAN =
        new ServiceContractField<String>("ReferenceServiceQtan");
    /**
     * Navigation property <b>to_Item</b> for <b>ServiceContract</b> to multiple <b>ServiceContractItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContractItem> toItem;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceContract</b> to multiple <b>ServiceContractText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContractText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static ServiceContractLink<ServiceContractItem> TO_ITEM =
        new ServiceContractLink<ServiceContractItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceContractLink<ServiceContractText> TO_TEXT =
        new ServiceContractLink<ServiceContractText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceContract> getType()
    {
        return ServiceContract.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractType</b>
     * </p>
     *
     * @param serviceContractType
     *            Business Transaction Type
     */
    public void setServiceContractType( @Nullable final String serviceContractType )
    {
        rememberChangedField("ServiceContractType", this.serviceContractType);
        this.serviceContractType = serviceContractType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractDescription</b>
     * </p>
     *
     * @param serviceContractDescription
     *            Transaction Description
     */
    public void setServiceContractDescription( @Nullable final String serviceContractDescription )
    {
        rememberChangedField("ServiceContractDescription", this.serviceContractDescription);
        this.serviceContractDescription = serviceContractDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key of Description
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractStartDateTime</b>
     * </p>
     *
     * @param serviceContractStartDateTime
     *            Contract Start date
     */
    public void setServiceContractStartDateTime( @Nullable final BigDecimal serviceContractStartDateTime )
    {
        rememberChangedField("ServiceContractStartDateTime", this.serviceContractStartDateTime);
        this.serviceContractStartDateTime = serviceContractStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractEndDateTime</b>
     * </p>
     *
     * @param serviceContractEndDateTime
     *            Contract End Date
     */
    public void setServiceContractEndDateTime( @Nullable final BigDecimal serviceContractEndDateTime )
    {
        rememberChangedField("ServiceContractEndDateTime", this.serviceContractEndDateTime);
        this.serviceContractEndDateTime = serviceContractEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Sold-To Party's External Reference Number
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Reference Document Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocGrossAmount</b>
     * </p>
     *
     * @param serviceDocGrossAmount
     *            Total Gross Value of Document in Document Currency
     */
    public void setServiceDocGrossAmount( @Nullable final BigDecimal serviceDocGrossAmount )
    {
        rememberChangedField("ServiceDocGrossAmount", this.serviceDocGrossAmount);
        this.serviceDocGrossAmount = serviceDocGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocNetAmount</b>
     * </p>
     *
     * @param serviceDocNetAmount
     *            Total Net Value of Document in Document Currency
     */
    public void setServiceDocNetAmount( @Nullable final BigDecimal serviceDocNetAmount )
    {
        rememberChangedField("ServiceDocNetAmount", this.serviceDocNetAmount);
        this.serviceDocNetAmount = serviceDocNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocTaxAmount</b>
     * </p>
     *
     * @param serviceDocTaxAmount
     *            Total Tax Amount in Document Currency
     */
    public void setServiceDocTaxAmount( @Nullable final BigDecimal serviceDocTaxAmount )
    {
        rememberChangedField("ServiceDocTaxAmount", this.serviceDocTaxAmount);
        this.serviceDocTaxAmount = serviceDocTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractIsReleased</b>
     * </p>
     *
     * @param serviceContractIsReleased
     *            Release Status
     */
    public void setServiceContractIsReleased( @Nullable final String serviceContractIsReleased )
    {
        rememberChangedField("ServiceContractIsReleased", this.serviceContractIsReleased);
        this.serviceContractIsReleased = serviceContractIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractIsCompleted</b>
     * </p>
     *
     * @param serviceContractIsCompleted
     *            The serviceContractIsCompleted to set.
     */
    public void setServiceContractIsCompleted( @Nullable final String serviceContractIsCompleted )
    {
        rememberChangedField("ServiceContractIsCompleted", this.serviceContractIsCompleted);
        this.serviceContractIsCompleted = serviceContractIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrCreditStatus</b>
     * </p>
     *
     * @param srvcContrCreditStatus
     *            Credit Status of Header
     */
    public void setSrvcContrCreditStatus( @Nullable final String srvcContrCreditStatus )
    {
        rememberChangedField("SrvcContrCreditStatus", this.srvcContrCreditStatus);
        this.srvcContrCreditStatus = srvcContrCreditStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-To Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractCanclnParty</b>
     * </p>
     *
     * @param serviceContractCanclnParty
     *            Cancelling Party
     */
    public void setServiceContractCanclnParty( @Nullable final String serviceContractCanclnParty )
    {
        rememberChangedField("ServiceContractCanclnParty", this.serviceContractCanclnParty);
        this.serviceContractCanclnParty = serviceContractCanclnParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrCancellationReason</b>
     * </p>
     *
     * @param serviceContrCancellationReason
     *            CRM Service : Reason for Cancellation
     */
    public void setServiceContrCancellationReason( @Nullable final String serviceContrCancellationReason )
    {
        rememberChangedField("ServiceContrCancellationReason", this.serviceContrCancellationReason);
        this.serviceContrCancellationReason = serviceContrCancellationReason;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrCancellationDateTime</b>
     * </p>
     *
     * @param srvcContrCancellationDateTime
     *            Contract End Date
     */
    public void setSrvcContrCancellationDateTime( @Nullable final BigDecimal srvcContrCancellationDateTime )
    {
        rememberChangedField("SrvcContrCancellationDateTime", this.srvcContrCancellationDateTime);
        this.srvcContrCancellationDateTime = srvcContrCancellationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContract</b>
     * </p>
     *
     * @param referenceServiceContract
     *            External Reference Number
     */
    public void setReferenceServiceContract( @Nullable final String referenceServiceContract )
    {
        rememberChangedField("ReferenceServiceContract", this.referenceServiceContract);
        this.referenceServiceContract = referenceServiceContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceQtan</b>
     * </p>
     *
     * @param referenceServiceQtan
     *            External Reference Number
     */
    public void setReferenceServiceQtan( @Nullable final String referenceServiceQtan )
    {
        rememberChangedField("ReferenceServiceQtan", this.referenceServiceQtan);
        this.referenceServiceQtan = referenceServiceQtan;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceContract";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractType", getServiceContractType());
        values.put("ServiceContractDescription", getServiceContractDescription());
        values.put("Language", getLanguage());
        values.put("ServiceContractStartDateTime", getServiceContractStartDateTime());
        values.put("ServiceContractEndDateTime", getServiceContractEndDateTime());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("ServiceDocGrossAmount", getServiceDocGrossAmount());
        values.put("ServiceDocNetAmount", getServiceDocNetAmount());
        values.put("ServiceDocTaxAmount", getServiceDocTaxAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ServiceContractIsReleased", getServiceContractIsReleased());
        values.put("ServiceContractIsCompleted", getServiceContractIsCompleted());
        values.put("SrvcContrCreditStatus", getSrvcContrCreditStatus());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("SoldToParty", getSoldToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ContactPerson", getContactPerson());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("ServiceContractCanclnParty", getServiceContractCanclnParty());
        values.put("ServiceContrCancellationReason", getServiceContrCancellationReason());
        values.put("SrvcContrCancellationDateTime", getSrvcContrCancellationDateTime());
        values.put("ReferenceServiceContract", getReferenceServiceContract());
        values.put("ReferenceServiceQtan", getReferenceServiceQtan());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractType") ) {
                final Object value = values.remove("ServiceContractType");
                if( (value == null) || (!value.equals(getServiceContractType())) ) {
                    setServiceContractType(((String) value));
                }
            }
            if( values.containsKey("ServiceContractDescription") ) {
                final Object value = values.remove("ServiceContractDescription");
                if( (value == null) || (!value.equals(getServiceContractDescription())) ) {
                    setServiceContractDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ServiceContractStartDateTime") ) {
                final Object value = values.remove("ServiceContractStartDateTime");
                if( (value == null) || (!value.equals(getServiceContractStartDateTime())) ) {
                    setServiceContractStartDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceContractEndDateTime") ) {
                final Object value = values.remove("ServiceContractEndDateTime");
                if( (value == null) || (!value.equals(getServiceContractEndDateTime())) ) {
                    setServiceContractEndDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ServiceDocGrossAmount") ) {
                final Object value = values.remove("ServiceDocGrossAmount");
                if( (value == null) || (!value.equals(getServiceDocGrossAmount())) ) {
                    setServiceDocGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocNetAmount") ) {
                final Object value = values.remove("ServiceDocNetAmount");
                if( (value == null) || (!value.equals(getServiceDocNetAmount())) ) {
                    setServiceDocNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocTaxAmount") ) {
                final Object value = values.remove("ServiceDocTaxAmount");
                if( (value == null) || (!value.equals(getServiceDocTaxAmount())) ) {
                    setServiceDocTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ServiceContractIsReleased") ) {
                final Object value = values.remove("ServiceContractIsReleased");
                if( (value == null) || (!value.equals(getServiceContractIsReleased())) ) {
                    setServiceContractIsReleased(((String) value));
                }
            }
            if( values.containsKey("ServiceContractIsCompleted") ) {
                final Object value = values.remove("ServiceContractIsCompleted");
                if( (value == null) || (!value.equals(getServiceContractIsCompleted())) ) {
                    setServiceContractIsCompleted(((String) value));
                }
            }
            if( values.containsKey("SrvcContrCreditStatus") ) {
                final Object value = values.remove("SrvcContrCreditStatus");
                if( (value == null) || (!value.equals(getSrvcContrCreditStatus())) ) {
                    setSrvcContrCreditStatus(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("ServiceContractCanclnParty") ) {
                final Object value = values.remove("ServiceContractCanclnParty");
                if( (value == null) || (!value.equals(getServiceContractCanclnParty())) ) {
                    setServiceContractCanclnParty(((String) value));
                }
            }
            if( values.containsKey("ServiceContrCancellationReason") ) {
                final Object value = values.remove("ServiceContrCancellationReason");
                if( (value == null) || (!value.equals(getServiceContrCancellationReason())) ) {
                    setServiceContrCancellationReason(((String) value));
                }
            }
            if( values.containsKey("SrvcContrCancellationDateTime") ) {
                final Object value = values.remove("SrvcContrCancellationDateTime");
                if( (value == null) || (!value.equals(getSrvcContrCancellationDateTime())) ) {
                    setSrvcContrCancellationDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReferenceServiceContract") ) {
                final Object value = values.remove("ReferenceServiceContract");
                if( (value == null) || (!value.equals(getReferenceServiceContract())) ) {
                    setReferenceServiceContract(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceQtan") ) {
                final Object value = values.remove("ReferenceServiceQtan");
                if( (value == null) || (!value.equals(getReferenceServiceQtan())) ) {
                    setReferenceServiceQtan(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContractItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new ServiceContractItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContractText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceContractText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceContractField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceContractField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceContractField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceContractField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceContractItem</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContractItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", ServiceContractItem.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>ServiceContractItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>ServiceContractItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceContractItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>ServiceContractItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContractItem</b> entities.
     */
    public void setItem( @Nonnull final List<ServiceContractItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContractItem</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContractItem</b> entities.
     */
    public void addItem( ServiceContractItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContractText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContractText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceContractText.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceContractText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContract</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceContractText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<ServiceContractText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceContractText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContractText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceContractText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContractText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContract</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContractText</b> entities.
     */
    public void addText( ServiceContractText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceContract instances.
     *
     */
    public final static class ServiceContractBuilder
    {

        private List<ServiceContractItem> toItem = Lists.newArrayList();
        private List<ServiceContractText> toText = Lists.newArrayList();

        private ServiceContract.ServiceContractBuilder toItem( final List<ServiceContractItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>ServiceContract</b> to multiple <b>ServiceContractItem</b>.
         *
         * @param value
         *            The ServiceContractItems to build this ServiceContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContract.ServiceContractBuilder item( ServiceContractItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private ServiceContract.ServiceContractBuilder toText( final List<ServiceContractText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceContract</b> to multiple <b>ServiceContractText</b>.
         *
         * @param value
         *            The ServiceContractTexts to build this ServiceContract with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContract.ServiceContractBuilder text( ServiceContractText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
