/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContractItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.ServiceContractItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Service Contract Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceContractItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceContractItem extends VdmEntity<ServiceContractItem>
{

    /**
     * Selector for all available fields of ServiceContractItem.
     *
     */
    public final static ServiceContractItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT =
        new ServiceContractItemField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "ServiceContractItem" )
    @JsonProperty( "ServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ServiceContractItem" )
    private String serviceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM =
        new ServiceContractItemField<String>("ServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCategory</b>
     * </p>
     *
     * @return Item Category
     */
    @SerializedName( "ServiceContractItemCategory" )
    @JsonProperty( "ServiceContractItemCategory" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemCategory" )
    private String serviceContractItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemCategory</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM_CATEGORY =
        new ServiceContractItemField<String>("ServiceContractItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Product Name Entered
     */
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> PRODUCT = new ServiceContractItemField<String>("Product");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return CRM: Order Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> QUANTITY =
        new ServiceContractItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @return Unit of Measure in Which the Product Is Sold
     */
    @SerializedName( "QuantityUnit" )
    @JsonProperty( "QuantityUnit" )
    @Nullable
    @ODataField( odataName = "QuantityUnit" )
    private String quantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>QuantityUnit</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> QUANTITY_UNIT =
        new ServiceContractItemField<String>("QuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemDescription</b>
     * </p>
     *
     * @return Product Description
     */
    @SerializedName( "ServiceContractItemDescription" )
    @JsonProperty( "ServiceContractItemDescription" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemDescription" )
    private String serviceContractItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemDescription</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM_DESCRIPTION =
        new ServiceContractItemField<String>("ServiceContractItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Short Text Language for an Item
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> LANGUAGE = new ServiceContractItemField<String>("Language");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemGrossAmount</b>
     * </p>
     *
     * @return Gross Order Value in PO Currency
     */
    @SerializedName( "ServiceDocItemGrossAmount" )
    @JsonProperty( "ServiceDocItemGrossAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocItemGrossAmount" )
    private BigDecimal serviceDocItemGrossAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocItemGrossAmount</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_DOC_ITEM_GROSS_AMOUNT =
        new ServiceContractItemField<BigDecimal>("ServiceDocItemGrossAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @return Net Value
     */
    @SerializedName( "ServiceDocumentItemNetAmount" )
    @JsonProperty( "ServiceDocumentItemNetAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemNetAmount" )
    private BigDecimal serviceDocumentItemNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemNetAmount</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_NET_AMOUNT =
        new ServiceContractItemField<BigDecimal>("ServiceDocumentItemNetAmount");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemTaxAmount</b>
     * </p>
     *
     * @return Tax amount in document currency
     */
    @SerializedName( "ServiceDocumentItemTaxAmount" )
    @JsonProperty( "ServiceDocumentItemTaxAmount" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItemTaxAmount" )
    private BigDecimal serviceDocumentItemTaxAmount;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItemTaxAmount</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_DOCUMENT_ITEM_TAX_AMOUNT =
        new ServiceContractItemField<BigDecimal>("ServiceDocumentItemTaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> TRANSACTION_CURRENCY =
        new ServiceContractItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemIsReleased</b>
     * </p>
     *
     * @return Release Status
     */
    @SerializedName( "ServiceContractItemIsReleased" )
    @JsonProperty( "ServiceContractItemIsReleased" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemIsReleased" )
    private String serviceContractItemIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemIsReleased</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM_IS_RELEASED =
        new ServiceContractItemField<String>("ServiceContractItemIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemIsCompleted</b>
     * </p>
     *
     * @return The serviceContractItemIsCompleted contained in this entity.
     */
    @SerializedName( "ServiceContractItemIsCompleted" )
    @JsonProperty( "ServiceContractItemIsCompleted" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemIsCompleted" )
    private String serviceContractItemIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemIsCompleted</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM_IS_COMPLETED =
        new ServiceContractItemField<String>("ServiceContractItemIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCanclnParty</b>
     * </p>
     *
     * @return Cancelling Party
     */
    @SerializedName( "ServiceContractItemCanclnParty" )
    @JsonProperty( "ServiceContractItemCanclnParty" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemCanclnParty" )
    private String serviceContractItemCanclnParty;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemCanclnParty</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITEM_CANCLN_PARTY =
        new ServiceContractItemField<String>("ServiceContractItemCanclnParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItmCanclnReason</b>
     * </p>
     *
     * @return CRM Service : Reason for Cancellation
     */
    @SerializedName( "ServiceContractItmCanclnReason" )
    @JsonProperty( "ServiceContractItmCanclnReason" )
    @Nullable
    @ODataField( odataName = "ServiceContractItmCanclnReason" )
    private String serviceContractItmCanclnReason;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItmCanclnReason</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SERVICE_CONTRACT_ITM_CANCLN_REASON =
        new ServiceContractItemField<String>("ServiceContractItmCanclnReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemCreditStatus</b>
     * </p>
     *
     * @return Credit Status of Item
     */
    @SerializedName( "SrvcContrItemCreditStatus" )
    @JsonProperty( "SrvcContrItemCreditStatus" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemCreditStatus" )
    private String srvcContrItemCreditStatus;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemCreditStatus</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_CONTR_ITEM_CREDIT_STATUS =
        new ServiceContractItemField<String>("SrvcContrItemCreditStatus");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCanclnDate</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "ServiceContractItemCanclnDate" )
    @JsonProperty( "ServiceContractItemCanclnDate" )
    @Nullable
    @ODataField( odataName = "ServiceContractItemCanclnDate" )
    private BigDecimal serviceContractItemCanclnDate;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContractItemCanclnDate</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_CONTRACT_ITEM_CANCLN_DATE =
        new ServiceContractItemField<BigDecimal>("ServiceContractItemCanclnDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemStartDateTime</b>
     * </p>
     *
     * @return Contract Start date
     */
    @SerializedName( "ServiceContrItemStartDateTime" )
    @JsonProperty( "ServiceContrItemStartDateTime" )
    @Nullable
    @ODataField( odataName = "ServiceContrItemStartDateTime" )
    private BigDecimal serviceContrItemStartDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContrItemStartDateTime</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_CONTR_ITEM_START_DATE_TIME =
        new ServiceContractItemField<BigDecimal>("ServiceContrItemStartDateTime");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemEndDateTime</b>
     * </p>
     *
     * @return Contract End Date
     */
    @SerializedName( "ServiceContrItemEndDateTime" )
    @JsonProperty( "ServiceContrItemEndDateTime" )
    @Nullable
    @ODataField( odataName = "ServiceContrItemEndDateTime" )
    private BigDecimal serviceContrItemEndDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContrItemEndDateTime</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SERVICE_CONTR_ITEM_END_DATE_TIME =
        new ServiceContractItemField<BigDecimal>("ServiceContrItemEndDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDateRuleName</b>
     * </p>
     *
     * @return Name for Date Rule
     */
    @SerializedName( "BillingPlanBillingDateRuleName" )
    @JsonProperty( "BillingPlanBillingDateRuleName" )
    @Nullable
    @ODataField( odataName = "BillingPlanBillingDateRuleName" )
    private String billingPlanBillingDateRuleName;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanBillingDateRuleName</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> BILLING_PLAN_BILLING_DATE_RULE_NAME =
        new ServiceContractItemField<String>("BillingPlanBillingDateRuleName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPeriodRuleName</b>
     * </p>
     *
     * @return Name for Date Rule
     */
    @SerializedName( "SettlementPeriodRuleName" )
    @JsonProperty( "SettlementPeriodRuleName" )
    @Nullable
    @ODataField( odataName = "SettlementPeriodRuleName" )
    private String settlementPeriodRuleName;
    /**
     * Use with available fluent helpers to apply the <b>SettlementPeriodRuleName</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SETTLEMENT_PERIOD_RULE_NAME =
        new ServiceContractItemField<String>("SettlementPeriodRuleName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanPriceDateRule</b>
     * </p>
     *
     * @return Rule for Determining the Pricing Date
     */
    @SerializedName( "BillingPlanPriceDateRule" )
    @JsonProperty( "BillingPlanPriceDateRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanPriceDateRule" )
    private String billingPlanPriceDateRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanPriceDateRule</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> BILLING_PLAN_PRICE_DATE_RULE =
        new ServiceContractItemField<String>("BillingPlanPriceDateRule");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanIsFinalized</b>
     * </p>
     *
     * @return Billing Plan Is Finalized
     */
    @SerializedName( "BillingPlanIsFinalized" )
    @JsonProperty( "BillingPlanIsFinalized" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BillingPlanIsFinalized" )
    private Boolean billingPlanIsFinalized;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanIsFinalized</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<Boolean> BILLING_PLAN_IS_FINALIZED =
        new ServiceContractItemField<Boolean>("BillingPlanIsFinalized");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @return Business Partner: Billing Block Reason
     */
    @SerializedName( "BillingBlockReason" )
    @JsonProperty( "BillingBlockReason" )
    @Nullable
    @ODataField( odataName = "BillingBlockReason" )
    private String billingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>BillingBlockReason</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> BILLING_BLOCK_REASON =
        new ServiceContractItemField<String>("BillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-To Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SHIP_TO_PARTY =
        new ServiceContractItemField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @return Employee Responsible
     */
    @SerializedName( "PersonResponsible" )
    @JsonProperty( "PersonResponsible" )
    @Nullable
    @ODataField( odataName = "PersonResponsible" )
    private String personResponsible;
    /**
     * Use with available fluent helpers to apply the <b>PersonResponsible</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> PERSON_RESPONSIBLE =
        new ServiceContractItemField<String>("PersonResponsible");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-To Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> BILL_TO_PARTY =
        new ServiceContractItemField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @return Payer
     */
    @SerializedName( "PayerParty" )
    @JsonProperty( "PayerParty" )
    @Nullable
    @ODataField( odataName = "PayerParty" )
    private String payerParty;
    /**
     * Use with available fluent helpers to apply the <b>PayerParty</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> PAYER_PARTY =
        new ServiceContractItemField<String>("PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Customer Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> CONTACT_PERSON =
        new ServiceContractItemField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceContractItem" )
    @JsonProperty( "ReferenceServiceContractItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceContractItem" )
    private String referenceServiceContractItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceContractItem</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> REFERENCE_SERVICE_CONTRACT_ITEM =
        new ServiceContractItemField<String>("ReferenceServiceContractItem");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceQtanItem</b>
     * </p>
     *
     * @return External Reference Number
     */
    @SerializedName( "ReferenceServiceQtanItem" )
    @JsonProperty( "ReferenceServiceQtanItem" )
    @Nullable
    @ODataField( odataName = "ReferenceServiceQtanItem" )
    private String referenceServiceQtanItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceServiceQtanItem</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> REFERENCE_SERVICE_QTAN_ITEM =
        new ServiceContractItemField<String>("ReferenceServiceQtanItem");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDuration</b>
     * </p>
     *
     * @return Unit for Auto Renewal Period
     */
    @SerializedName( "SrvcContrItemRnwlDuration" )
    @JsonProperty( "SrvcContrItemRnwlDuration" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemRnwlDuration" )
    private BigDecimal srvcContrItemRnwlDuration;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemRnwlDuration</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SRVC_CONTR_ITEM_RNWL_DURATION =
        new ServiceContractItemField<BigDecimal>("SrvcContrItemRnwlDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDurationUnit</b>
     * </p>
     *
     * @return UOM for Auto Renewal Period
     */
    @SerializedName( "SrvcContrItemRnwlDurationUnit" )
    @JsonProperty( "SrvcContrItemRnwlDurationUnit" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemRnwlDurationUnit" )
    private String srvcContrItemRnwlDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemRnwlDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_CONTR_ITEM_RNWL_DURATION_UNIT =
        new ServiceContractItemField<String>("SrvcContrItemRnwlDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtensionDuration</b>
     * </p>
     *
     * @return Unit for Contract Extension
     */
    @SerializedName( "SrvcContrItemExtensionDuration" )
    @JsonProperty( "SrvcContrItemExtensionDuration" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemExtensionDuration" )
    private BigDecimal srvcContrItemExtensionDuration;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemExtensionDuration</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<BigDecimal> SRVC_CONTR_ITEM_EXTENSION_DURATION =
        new ServiceContractItemField<BigDecimal>("SrvcContrItemExtensionDuration");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtnDurationUnit</b>
     * </p>
     *
     * @return UOM for Contract Extension
     */
    @SerializedName( "SrvcContrItemExtnDurationUnit" )
    @JsonProperty( "SrvcContrItemExtnDurationUnit" )
    @Nullable
    @ODataField( odataName = "SrvcContrItemExtnDurationUnit" )
    private String srvcContrItemExtnDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>SrvcContrItemExtnDurationUnit</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_CONTR_ITEM_EXTN_DURATION_UNIT =
        new ServiceContractItemField<String>("SrvcContrItemExtnDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChangeProcess</b>
     * </p>
     *
     * @return Process of Maint. FW
     */
    @SerializedName( "SrvcTransChangeProcess" )
    @JsonProperty( "SrvcTransChangeProcess" )
    @Nullable
    @ODataField( odataName = "SrvcTransChangeProcess" )
    private String srvcTransChangeProcess;
    /**
     * Use with available fluent helpers to apply the <b>SrvcTransChangeProcess</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_TRANS_CHANGE_PROCESS =
        new ServiceContractItemField<String>("SrvcTransChangeProcess");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChangeProcessType</b>
     * </p>
     *
     * @return Process Type
     */
    @SerializedName( "SrvcTransChangeProcessType" )
    @JsonProperty( "SrvcTransChangeProcessType" )
    @Nullable
    @ODataField( odataName = "SrvcTransChangeProcessType" )
    private String srvcTransChangeProcessType;
    /**
     * Use with available fluent helpers to apply the <b>SrvcTransChangeProcessType</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_TRANS_CHANGE_PROCESS_TYPE =
        new ServiceContractItemField<String>("SrvcTransChangeProcessType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceTransID</b>
     * </p>
     *
     * @return Transaction ID
     */
    @SerializedName( "SrvcTransChgProcSourceTransID" )
    @JsonProperty( "SrvcTransChgProcSourceTransID" )
    @Nullable
    @ODataField( odataName = "SrvcTransChgProcSourceTransID" )
    private String srvcTransChgProcSourceTransID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcTransChgProcSourceTransID</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_TRANS_CHG_PROC_SOURCE_TRANS_ID =
        new ServiceContractItemField<String>("SrvcTransChgProcSourceTransID");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceItemID</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @SerializedName( "SrvcTransChgProcSourceItemID" )
    @JsonProperty( "SrvcTransChgProcSourceItemID" )
    @Nullable
    @ODataField( odataName = "SrvcTransChgProcSourceItemID" )
    private String srvcTransChgProcSourceItemID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcTransChgProcSourceItemID</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> SRVC_TRANS_CHG_PROC_SOURCE_ITEM_ID =
        new ServiceContractItemField<String>("SrvcTransChgProcSourceItemID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceItemUUID</b>
     * </p>
     *
     * @return Contract Item Identifier
     */
    @SerializedName( "SrvcTransChgProcSourceItemUUID" )
    @JsonProperty( "SrvcTransChgProcSourceItemUUID" )
    @Nullable
    @ODataField( odataName = "SrvcTransChgProcSourceItemUUID" )
    private UUID srvcTransChgProcSourceItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>SrvcTransChgProcSourceItemUUID</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<UUID> SRVC_TRANS_CHG_PROC_SOURCE_ITEM_UUID =
        new ServiceContractItemField<UUID>("SrvcTransChgProcSourceItemUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ServiceContractItemField<String> PROFIT_CENTER =
        new ServiceContractItemField<String>("ProfitCenter");
    /**
     * Navigation property <b>to_BillingRequestItem</b> for <b>ServiceContractItem</b> to multiple
     * <b>SrvcContrItmBillgReqItem</b>.
     *
     */
    @SerializedName( "to_BillingRequestItem" )
    @JsonProperty( "to_BillingRequestItem" )
    @ODataField( odataName = "to_BillingRequestItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcContrItmBillgReqItem> toBillingRequestItem;
    /**
     * Navigation property <b>to_ObjectList</b> for <b>ServiceContractItem</b> to multiple
     * <b>ServiceContrItemObjectList</b>.
     *
     */
    @SerializedName( "to_ObjectList" )
    @JsonProperty( "to_ObjectList" )
    @ODataField( odataName = "to_ObjectList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContrItemObjectList> toObjectList;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>ServiceContractItem</b> to multiple
     * <b>ServiceContrItemPriceElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContrItemPriceElement> toPricingElement;
    /**
     * Navigation property <b>to_ProductList</b> for <b>ServiceContractItem</b> to multiple <b>SrvcContrItemProduct</b>.
     *
     */
    @SerializedName( "to_ProductList" )
    @JsonProperty( "to_ProductList" )
    @ODataField( odataName = "to_ProductList" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcContrItemProduct> toProductList;
    /**
     * Navigation property <b>to_ReleasedOrder</b> for <b>ServiceContractItem</b> to multiple
     * <b>ServiceContrItmReleasedOrder</b>.
     *
     */
    @SerializedName( "to_ReleasedOrder" )
    @JsonProperty( "to_ReleasedOrder" )
    @ODataField( odataName = "to_ReleasedOrder" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContrItmReleasedOrder> toReleasedOrder;
    /**
     * Navigation property <b>to_ServiceContract</b> for <b>ServiceContractItem</b> to single <b>ServiceContract</b>.
     *
     */
    @SerializedName( "to_ServiceContract" )
    @JsonProperty( "to_ServiceContract" )
    @ODataField( odataName = "to_ServiceContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceContract toServiceContract;
    /**
     * Navigation property <b>to_Text</b> for <b>ServiceContractItem</b> to multiple <b>ServiceContractItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ServiceContractItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static ServiceContractItemLink<SrvcContrItmBillgReqItem> TO_BILLING_REQUEST_ITEM =
        new ServiceContractItemLink<SrvcContrItmBillgReqItem>("to_BillingRequestItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ObjectList</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemLink<ServiceContrItemObjectList> TO_OBJECT_LIST =
        new ServiceContractItemLink<ServiceContrItemObjectList>("to_ObjectList");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemLink<ServiceContrItemPriceElement> TO_PRICING_ELEMENT =
        new ServiceContractItemLink<ServiceContrItemPriceElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductList</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemLink<SrvcContrItemProduct> TO_PRODUCT_LIST =
        new ServiceContractItemLink<SrvcContrItemProduct>("to_ProductList");
    /**
     * Use with available fluent helpers to apply the <b>to_ReleasedOrder</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemLink<ServiceContrItmReleasedOrder> TO_RELEASED_ORDER =
        new ServiceContractItemLink<ServiceContrItmReleasedOrder>("to_ReleasedOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContract</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemOneToOneLink<ServiceContract> TO_SERVICE_CONTRACT =
        new ServiceContractItemOneToOneLink<ServiceContract>("to_ServiceContract");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static ServiceContractItemLink<ServiceContractItemText> TO_TEXT =
        new ServiceContractItemLink<ServiceContractItemText>("to_Text");

    @Nonnull
    @Override
    public Class<ServiceContractItem> getType()
    {
        return ServiceContractItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItem</b>
     * </p>
     *
     * @param serviceContractItem
     *            Shortened Item Number in Document
     */
    public void setServiceContractItem( @Nullable final String serviceContractItem )
    {
        rememberChangedField("ServiceContractItem", this.serviceContractItem);
        this.serviceContractItem = serviceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCategory</b>
     * </p>
     *
     * @param serviceContractItemCategory
     *            Item Category
     */
    public void setServiceContractItemCategory( @Nullable final String serviceContractItemCategory )
    {
        rememberChangedField("ServiceContractItemCategory", this.serviceContractItemCategory);
        this.serviceContractItemCategory = serviceContractItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 54
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Product Name Entered
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            CRM: Order Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>QuantityUnit</b>
     * </p>
     *
     * @param quantityUnit
     *            Unit of Measure in Which the Product Is Sold
     */
    public void setQuantityUnit( @Nullable final String quantityUnit )
    {
        rememberChangedField("QuantityUnit", this.quantityUnit);
        this.quantityUnit = quantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemDescription</b>
     * </p>
     *
     * @param serviceContractItemDescription
     *            Product Description
     */
    public void setServiceContractItemDescription( @Nullable final String serviceContractItemDescription )
    {
        rememberChangedField("ServiceContractItemDescription", this.serviceContractItemDescription);
        this.serviceContractItemDescription = serviceContractItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Short Text Language for an Item
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocItemGrossAmount</b>
     * </p>
     *
     * @param serviceDocItemGrossAmount
     *            Gross Order Value in PO Currency
     */
    public void setServiceDocItemGrossAmount( @Nullable final BigDecimal serviceDocItemGrossAmount )
    {
        rememberChangedField("ServiceDocItemGrossAmount", this.serviceDocItemGrossAmount);
        this.serviceDocItemGrossAmount = serviceDocItemGrossAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemNetAmount</b>
     * </p>
     *
     * @param serviceDocumentItemNetAmount
     *            Net Value
     */
    public void setServiceDocumentItemNetAmount( @Nullable final BigDecimal serviceDocumentItemNetAmount )
    {
        rememberChangedField("ServiceDocumentItemNetAmount", this.serviceDocumentItemNetAmount);
        this.serviceDocumentItemNetAmount = serviceDocumentItemNetAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItemTaxAmount</b>
     * </p>
     *
     * @param serviceDocumentItemTaxAmount
     *            Tax amount in document currency
     */
    public void setServiceDocumentItemTaxAmount( @Nullable final BigDecimal serviceDocumentItemTaxAmount )
    {
        rememberChangedField("ServiceDocumentItemTaxAmount", this.serviceDocumentItemTaxAmount);
        this.serviceDocumentItemTaxAmount = serviceDocumentItemTaxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemIsReleased</b>
     * </p>
     *
     * @param serviceContractItemIsReleased
     *            Release Status
     */
    public void setServiceContractItemIsReleased( @Nullable final String serviceContractItemIsReleased )
    {
        rememberChangedField("ServiceContractItemIsReleased", this.serviceContractItemIsReleased);
        this.serviceContractItemIsReleased = serviceContractItemIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemIsCompleted</b>
     * </p>
     *
     * @param serviceContractItemIsCompleted
     *            The serviceContractItemIsCompleted to set.
     */
    public void setServiceContractItemIsCompleted( @Nullable final String serviceContractItemIsCompleted )
    {
        rememberChangedField("ServiceContractItemIsCompleted", this.serviceContractItemIsCompleted);
        this.serviceContractItemIsCompleted = serviceContractItemIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCanclnParty</b>
     * </p>
     *
     * @param serviceContractItemCanclnParty
     *            Cancelling Party
     */
    public void setServiceContractItemCanclnParty( @Nullable final String serviceContractItemCanclnParty )
    {
        rememberChangedField("ServiceContractItemCanclnParty", this.serviceContractItemCanclnParty);
        this.serviceContractItemCanclnParty = serviceContractItemCanclnParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItmCanclnReason</b>
     * </p>
     *
     * @param serviceContractItmCanclnReason
     *            CRM Service : Reason for Cancellation
     */
    public void setServiceContractItmCanclnReason( @Nullable final String serviceContractItmCanclnReason )
    {
        rememberChangedField("ServiceContractItmCanclnReason", this.serviceContractItmCanclnReason);
        this.serviceContractItmCanclnReason = serviceContractItmCanclnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemCreditStatus</b>
     * </p>
     *
     * @param srvcContrItemCreditStatus
     *            Credit Status of Item
     */
    public void setSrvcContrItemCreditStatus( @Nullable final String srvcContrItemCreditStatus )
    {
        rememberChangedField("SrvcContrItemCreditStatus", this.srvcContrItemCreditStatus);
        this.srvcContrItemCreditStatus = srvcContrItemCreditStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContractItemCanclnDate</b>
     * </p>
     *
     * @param serviceContractItemCanclnDate
     *            Contract End Date
     */
    public void setServiceContractItemCanclnDate( @Nullable final BigDecimal serviceContractItemCanclnDate )
    {
        rememberChangedField("ServiceContractItemCanclnDate", this.serviceContractItemCanclnDate);
        this.serviceContractItemCanclnDate = serviceContractItemCanclnDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemStartDateTime</b>
     * </p>
     *
     * @param serviceContrItemStartDateTime
     *            Contract Start date
     */
    public void setServiceContrItemStartDateTime( @Nullable final BigDecimal serviceContrItemStartDateTime )
    {
        rememberChangedField("ServiceContrItemStartDateTime", this.serviceContrItemStartDateTime);
        this.serviceContrItemStartDateTime = serviceContrItemStartDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContrItemEndDateTime</b>
     * </p>
     *
     * @param serviceContrItemEndDateTime
     *            Contract End Date
     */
    public void setServiceContrItemEndDateTime( @Nullable final BigDecimal serviceContrItemEndDateTime )
    {
        rememberChangedField("ServiceContrItemEndDateTime", this.serviceContrItemEndDateTime);
        this.serviceContrItemEndDateTime = serviceContrItemEndDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDateRuleName</b>
     * </p>
     *
     * @param billingPlanBillingDateRuleName
     *            Name for Date Rule
     */
    public void setBillingPlanBillingDateRuleName( @Nullable final String billingPlanBillingDateRuleName )
    {
        rememberChangedField("BillingPlanBillingDateRuleName", this.billingPlanBillingDateRuleName);
        this.billingPlanBillingDateRuleName = billingPlanBillingDateRuleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SettlementPeriodRuleName</b>
     * </p>
     *
     * @param settlementPeriodRuleName
     *            Name for Date Rule
     */
    public void setSettlementPeriodRuleName( @Nullable final String settlementPeriodRuleName )
    {
        rememberChangedField("SettlementPeriodRuleName", this.settlementPeriodRuleName);
        this.settlementPeriodRuleName = settlementPeriodRuleName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanPriceDateRule</b>
     * </p>
     *
     * @param billingPlanPriceDateRule
     *            Rule for Determining the Pricing Date
     */
    public void setBillingPlanPriceDateRule( @Nullable final String billingPlanPriceDateRule )
    {
        rememberChangedField("BillingPlanPriceDateRule", this.billingPlanPriceDateRule);
        this.billingPlanPriceDateRule = billingPlanPriceDateRule;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanIsFinalized</b>
     * </p>
     *
     * @param billingPlanIsFinalized
     *            Billing Plan Is Finalized
     */
    public void setBillingPlanIsFinalized( @Nullable final Boolean billingPlanIsFinalized )
    {
        rememberChangedField("BillingPlanIsFinalized", this.billingPlanIsFinalized);
        this.billingPlanIsFinalized = billingPlanIsFinalized;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @param billingBlockReason
     *            Business Partner: Billing Block Reason
     */
    public void setBillingBlockReason( @Nullable final String billingBlockReason )
    {
        rememberChangedField("BillingBlockReason", this.billingBlockReason);
        this.billingBlockReason = billingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-To Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PersonResponsible</b>
     * </p>
     *
     * @param personResponsible
     *            Employee Responsible
     */
    public void setPersonResponsible( @Nullable final String personResponsible )
    {
        rememberChangedField("PersonResponsible", this.personResponsible);
        this.personResponsible = personResponsible;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-To Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     *
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Customer Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceContractItem</b>
     * </p>
     *
     * @param referenceServiceContractItem
     *            External Reference Number
     */
    public void setReferenceServiceContractItem( @Nullable final String referenceServiceContractItem )
    {
        rememberChangedField("ReferenceServiceContractItem", this.referenceServiceContractItem);
        this.referenceServiceContractItem = referenceServiceContractItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceServiceQtanItem</b>
     * </p>
     *
     * @param referenceServiceQtanItem
     *            External Reference Number
     */
    public void setReferenceServiceQtanItem( @Nullable final String referenceServiceQtanItem )
    {
        rememberChangedField("ReferenceServiceQtanItem", this.referenceServiceQtanItem);
        this.referenceServiceQtanItem = referenceServiceQtanItem;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDuration</b>
     * </p>
     *
     * @param srvcContrItemRnwlDuration
     *            Unit for Auto Renewal Period
     */
    public void setSrvcContrItemRnwlDuration( @Nullable final BigDecimal srvcContrItemRnwlDuration )
    {
        rememberChangedField("SrvcContrItemRnwlDuration", this.srvcContrItemRnwlDuration);
        this.srvcContrItemRnwlDuration = srvcContrItemRnwlDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemRnwlDurationUnit</b>
     * </p>
     *
     * @param srvcContrItemRnwlDurationUnit
     *            UOM for Auto Renewal Period
     */
    public void setSrvcContrItemRnwlDurationUnit( @Nullable final String srvcContrItemRnwlDurationUnit )
    {
        rememberChangedField("SrvcContrItemRnwlDurationUnit", this.srvcContrItemRnwlDurationUnit);
        this.srvcContrItemRnwlDurationUnit = srvcContrItemRnwlDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtensionDuration</b>
     * </p>
     *
     * @param srvcContrItemExtensionDuration
     *            Unit for Contract Extension
     */
    public void setSrvcContrItemExtensionDuration( @Nullable final BigDecimal srvcContrItemExtensionDuration )
    {
        rememberChangedField("SrvcContrItemExtensionDuration", this.srvcContrItemExtensionDuration);
        this.srvcContrItemExtensionDuration = srvcContrItemExtensionDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SrvcContrItemExtnDurationUnit</b>
     * </p>
     *
     * @param srvcContrItemExtnDurationUnit
     *            UOM for Contract Extension
     */
    public void setSrvcContrItemExtnDurationUnit( @Nullable final String srvcContrItemExtnDurationUnit )
    {
        rememberChangedField("SrvcContrItemExtnDurationUnit", this.srvcContrItemExtnDurationUnit);
        this.srvcContrItemExtnDurationUnit = srvcContrItemExtnDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChangeProcess</b>
     * </p>
     *
     * @param srvcTransChangeProcess
     *            Process of Maint. FW
     */
    public void setSrvcTransChangeProcess( @Nullable final String srvcTransChangeProcess )
    {
        rememberChangedField("SrvcTransChangeProcess", this.srvcTransChangeProcess);
        this.srvcTransChangeProcess = srvcTransChangeProcess;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChangeProcessType</b>
     * </p>
     *
     * @param srvcTransChangeProcessType
     *            Process Type
     */
    public void setSrvcTransChangeProcessType( @Nullable final String srvcTransChangeProcessType )
    {
        rememberChangedField("SrvcTransChangeProcessType", this.srvcTransChangeProcessType);
        this.srvcTransChangeProcessType = srvcTransChangeProcessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceTransID</b>
     * </p>
     *
     * @param srvcTransChgProcSourceTransID
     *            Transaction ID
     */
    public void setSrvcTransChgProcSourceTransID( @Nullable final String srvcTransChgProcSourceTransID )
    {
        rememberChangedField("SrvcTransChgProcSourceTransID", this.srvcTransChgProcSourceTransID);
        this.srvcTransChgProcSourceTransID = srvcTransChgProcSourceTransID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceItemID</b>
     * </p>
     *
     * @param srvcTransChgProcSourceItemID
     *            Shortened Item Number in Document
     */
    public void setSrvcTransChgProcSourceItemID( @Nullable final String srvcTransChgProcSourceItemID )
    {
        rememberChangedField("SrvcTransChgProcSourceItemID", this.srvcTransChgProcSourceItemID);
        this.srvcTransChgProcSourceItemID = srvcTransChgProcSourceItemID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SrvcTransChgProcSourceItemUUID</b>
     * </p>
     *
     * @param srvcTransChgProcSourceItemUUID
     *            Contract Item Identifier
     */
    public void setSrvcTransChgProcSourceItemUUID( @Nullable final UUID srvcTransChgProcSourceItemUUID )
    {
        rememberChangedField("SrvcTransChgProcSourceItemUUID", this.srvcTransChgProcSourceItemUUID);
        this.srvcTransChgProcSourceItemUUID = srvcTransChgProcSourceItemUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceContractItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("ServiceContractItem", getServiceContractItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("ServiceContractItem", getServiceContractItem());
        values.put("ServiceContractItemCategory", getServiceContractItemCategory());
        values.put("Product", getProduct());
        values.put("Quantity", getQuantity());
        values.put("QuantityUnit", getQuantityUnit());
        values.put("ServiceContractItemDescription", getServiceContractItemDescription());
        values.put("Language", getLanguage());
        values.put("ServiceDocItemGrossAmount", getServiceDocItemGrossAmount());
        values.put("ServiceDocumentItemNetAmount", getServiceDocumentItemNetAmount());
        values.put("ServiceDocumentItemTaxAmount", getServiceDocumentItemTaxAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ServiceContractItemIsReleased", getServiceContractItemIsReleased());
        values.put("ServiceContractItemIsCompleted", getServiceContractItemIsCompleted());
        values.put("ServiceContractItemCanclnParty", getServiceContractItemCanclnParty());
        values.put("ServiceContractItmCanclnReason", getServiceContractItmCanclnReason());
        values.put("SrvcContrItemCreditStatus", getSrvcContrItemCreditStatus());
        values.put("ServiceContractItemCanclnDate", getServiceContractItemCanclnDate());
        values.put("ServiceContrItemStartDateTime", getServiceContrItemStartDateTime());
        values.put("ServiceContrItemEndDateTime", getServiceContrItemEndDateTime());
        values.put("BillingPlanBillingDateRuleName", getBillingPlanBillingDateRuleName());
        values.put("SettlementPeriodRuleName", getSettlementPeriodRuleName());
        values.put("BillingPlanPriceDateRule", getBillingPlanPriceDateRule());
        values.put("BillingPlanIsFinalized", getBillingPlanIsFinalized());
        values.put("BillingBlockReason", getBillingBlockReason());
        values.put("ShipToParty", getShipToParty());
        values.put("PersonResponsible", getPersonResponsible());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ContactPerson", getContactPerson());
        values.put("ReferenceServiceContractItem", getReferenceServiceContractItem());
        values.put("ReferenceServiceQtanItem", getReferenceServiceQtanItem());
        values.put("SrvcContrItemRnwlDuration", getSrvcContrItemRnwlDuration());
        values.put("SrvcContrItemRnwlDurationUnit", getSrvcContrItemRnwlDurationUnit());
        values.put("SrvcContrItemExtensionDuration", getSrvcContrItemExtensionDuration());
        values.put("SrvcContrItemExtnDurationUnit", getSrvcContrItemExtnDurationUnit());
        values.put("SrvcTransChangeProcess", getSrvcTransChangeProcess());
        values.put("SrvcTransChangeProcessType", getSrvcTransChangeProcessType());
        values.put("SrvcTransChgProcSourceTransID", getSrvcTransChgProcSourceTransID());
        values.put("SrvcTransChgProcSourceItemID", getSrvcTransChgProcSourceItemID());
        values.put("SrvcTransChgProcSourceItemUUID", getSrvcTransChgProcSourceItemUUID());
        values.put("ProfitCenter", getProfitCenter());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItem") ) {
                final Object value = values.remove("ServiceContractItem");
                if( (value == null) || (!value.equals(getServiceContractItem())) ) {
                    setServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemCategory") ) {
                final Object value = values.remove("ServiceContractItemCategory");
                if( (value == null) || (!value.equals(getServiceContractItemCategory())) ) {
                    setServiceContractItemCategory(((String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityUnit") ) {
                final Object value = values.remove("QuantityUnit");
                if( (value == null) || (!value.equals(getQuantityUnit())) ) {
                    setQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemDescription") ) {
                final Object value = values.remove("ServiceContractItemDescription");
                if( (value == null) || (!value.equals(getServiceContractItemDescription())) ) {
                    setServiceContractItemDescription(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ServiceDocItemGrossAmount") ) {
                final Object value = values.remove("ServiceDocItemGrossAmount");
                if( (value == null) || (!value.equals(getServiceDocItemGrossAmount())) ) {
                    setServiceDocItemGrossAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemNetAmount") ) {
                final Object value = values.remove("ServiceDocumentItemNetAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemNetAmount())) ) {
                    setServiceDocumentItemNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceDocumentItemTaxAmount") ) {
                final Object value = values.remove("ServiceDocumentItemTaxAmount");
                if( (value == null) || (!value.equals(getServiceDocumentItemTaxAmount())) ) {
                    setServiceDocumentItemTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemIsReleased") ) {
                final Object value = values.remove("ServiceContractItemIsReleased");
                if( (value == null) || (!value.equals(getServiceContractItemIsReleased())) ) {
                    setServiceContractItemIsReleased(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemIsCompleted") ) {
                final Object value = values.remove("ServiceContractItemIsCompleted");
                if( (value == null) || (!value.equals(getServiceContractItemIsCompleted())) ) {
                    setServiceContractItemIsCompleted(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemCanclnParty") ) {
                final Object value = values.remove("ServiceContractItemCanclnParty");
                if( (value == null) || (!value.equals(getServiceContractItemCanclnParty())) ) {
                    setServiceContractItemCanclnParty(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItmCanclnReason") ) {
                final Object value = values.remove("ServiceContractItmCanclnReason");
                if( (value == null) || (!value.equals(getServiceContractItmCanclnReason())) ) {
                    setServiceContractItmCanclnReason(((String) value));
                }
            }
            if( values.containsKey("SrvcContrItemCreditStatus") ) {
                final Object value = values.remove("SrvcContrItemCreditStatus");
                if( (value == null) || (!value.equals(getSrvcContrItemCreditStatus())) ) {
                    setSrvcContrItemCreditStatus(((String) value));
                }
            }
            if( values.containsKey("ServiceContractItemCanclnDate") ) {
                final Object value = values.remove("ServiceContractItemCanclnDate");
                if( (value == null) || (!value.equals(getServiceContractItemCanclnDate())) ) {
                    setServiceContractItemCanclnDate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceContrItemStartDateTime") ) {
                final Object value = values.remove("ServiceContrItemStartDateTime");
                if( (value == null) || (!value.equals(getServiceContrItemStartDateTime())) ) {
                    setServiceContrItemStartDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("ServiceContrItemEndDateTime") ) {
                final Object value = values.remove("ServiceContrItemEndDateTime");
                if( (value == null) || (!value.equals(getServiceContrItemEndDateTime())) ) {
                    setServiceContrItemEndDateTime(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingPlanBillingDateRuleName") ) {
                final Object value = values.remove("BillingPlanBillingDateRuleName");
                if( (value == null) || (!value.equals(getBillingPlanBillingDateRuleName())) ) {
                    setBillingPlanBillingDateRuleName(((String) value));
                }
            }
            if( values.containsKey("SettlementPeriodRuleName") ) {
                final Object value = values.remove("SettlementPeriodRuleName");
                if( (value == null) || (!value.equals(getSettlementPeriodRuleName())) ) {
                    setSettlementPeriodRuleName(((String) value));
                }
            }
            if( values.containsKey("BillingPlanPriceDateRule") ) {
                final Object value = values.remove("BillingPlanPriceDateRule");
                if( (value == null) || (!value.equals(getBillingPlanPriceDateRule())) ) {
                    setBillingPlanPriceDateRule(((String) value));
                }
            }
            if( values.containsKey("BillingPlanIsFinalized") ) {
                final Object value = values.remove("BillingPlanIsFinalized");
                if( (value == null) || (!value.equals(getBillingPlanIsFinalized())) ) {
                    setBillingPlanIsFinalized(((Boolean) value));
                }
            }
            if( values.containsKey("BillingBlockReason") ) {
                final Object value = values.remove("BillingBlockReason");
                if( (value == null) || (!value.equals(getBillingBlockReason())) ) {
                    setBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("PersonResponsible") ) {
                final Object value = values.remove("PersonResponsible");
                if( (value == null) || (!value.equals(getPersonResponsible())) ) {
                    setPersonResponsible(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceContractItem") ) {
                final Object value = values.remove("ReferenceServiceContractItem");
                if( (value == null) || (!value.equals(getReferenceServiceContractItem())) ) {
                    setReferenceServiceContractItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceServiceQtanItem") ) {
                final Object value = values.remove("ReferenceServiceQtanItem");
                if( (value == null) || (!value.equals(getReferenceServiceQtanItem())) ) {
                    setReferenceServiceQtanItem(((String) value));
                }
            }
            if( values.containsKey("SrvcContrItemRnwlDuration") ) {
                final Object value = values.remove("SrvcContrItemRnwlDuration");
                if( (value == null) || (!value.equals(getSrvcContrItemRnwlDuration())) ) {
                    setSrvcContrItemRnwlDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcContrItemRnwlDurationUnit") ) {
                final Object value = values.remove("SrvcContrItemRnwlDurationUnit");
                if( (value == null) || (!value.equals(getSrvcContrItemRnwlDurationUnit())) ) {
                    setSrvcContrItemRnwlDurationUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcContrItemExtensionDuration") ) {
                final Object value = values.remove("SrvcContrItemExtensionDuration");
                if( (value == null) || (!value.equals(getSrvcContrItemExtensionDuration())) ) {
                    setSrvcContrItemExtensionDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("SrvcContrItemExtnDurationUnit") ) {
                final Object value = values.remove("SrvcContrItemExtnDurationUnit");
                if( (value == null) || (!value.equals(getSrvcContrItemExtnDurationUnit())) ) {
                    setSrvcContrItemExtnDurationUnit(((String) value));
                }
            }
            if( values.containsKey("SrvcTransChangeProcess") ) {
                final Object value = values.remove("SrvcTransChangeProcess");
                if( (value == null) || (!value.equals(getSrvcTransChangeProcess())) ) {
                    setSrvcTransChangeProcess(((String) value));
                }
            }
            if( values.containsKey("SrvcTransChangeProcessType") ) {
                final Object value = values.remove("SrvcTransChangeProcessType");
                if( (value == null) || (!value.equals(getSrvcTransChangeProcessType())) ) {
                    setSrvcTransChangeProcessType(((String) value));
                }
            }
            if( values.containsKey("SrvcTransChgProcSourceTransID") ) {
                final Object value = values.remove("SrvcTransChgProcSourceTransID");
                if( (value == null) || (!value.equals(getSrvcTransChgProcSourceTransID())) ) {
                    setSrvcTransChgProcSourceTransID(((String) value));
                }
            }
            if( values.containsKey("SrvcTransChgProcSourceItemID") ) {
                final Object value = values.remove("SrvcTransChgProcSourceItemID");
                if( (value == null) || (!value.equals(getSrvcTransChgProcSourceItemID())) ) {
                    setSrvcTransChgProcSourceItemID(((String) value));
                }
            }
            if( values.containsKey("SrvcTransChgProcSourceItemUUID") ) {
                final Object value = values.remove("SrvcTransChgProcSourceItemUUID");
                if( (value == null) || (!value.equals(getSrvcTransChgProcSourceItemUUID())) ) {
                    setSrvcTransChgProcSourceItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingRequestItem") ) {
                final Object value = (values).remove("to_BillingRequestItem");
                if( value instanceof Iterable ) {
                    if( toBillingRequestItem == null ) {
                        toBillingRequestItem = Lists.newArrayList();
                    } else {
                        toBillingRequestItem = Lists.newArrayList(toBillingRequestItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcContrItmBillgReqItem entity;
                        if( toBillingRequestItem.size() > i ) {
                            entity = toBillingRequestItem.get(i);
                        } else {
                            entity = new SrvcContrItmBillgReqItem();
                            toBillingRequestItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ObjectList") ) {
                final Object value = (values).remove("to_ObjectList");
                if( value instanceof Iterable ) {
                    if( toObjectList == null ) {
                        toObjectList = Lists.newArrayList();
                    } else {
                        toObjectList = Lists.newArrayList(toObjectList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContrItemObjectList entity;
                        if( toObjectList.size() > i ) {
                            entity = toObjectList.get(i);
                        } else {
                            entity = new ServiceContrItemObjectList();
                            toObjectList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContrItemPriceElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new ServiceContrItemPriceElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductList") ) {
                final Object value = (values).remove("to_ProductList");
                if( value instanceof Iterable ) {
                    if( toProductList == null ) {
                        toProductList = Lists.newArrayList();
                    } else {
                        toProductList = Lists.newArrayList(toProductList);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcContrItemProduct entity;
                        if( toProductList.size() > i ) {
                            entity = toProductList.get(i);
                        } else {
                            entity = new SrvcContrItemProduct();
                            toProductList.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ReleasedOrder") ) {
                final Object value = (values).remove("to_ReleasedOrder");
                if( value instanceof Iterable ) {
                    if( toReleasedOrder == null ) {
                        toReleasedOrder = Lists.newArrayList();
                    } else {
                        toReleasedOrder = Lists.newArrayList(toReleasedOrder);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContrItmReleasedOrder entity;
                        if( toReleasedOrder.size() > i ) {
                            entity = toReleasedOrder.get(i);
                        } else {
                            entity = new ServiceContrItmReleasedOrder();
                            toReleasedOrder.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ServiceContract") ) {
                final Object value = (values).remove("to_ServiceContract");
                if( value instanceof Map ) {
                    if( toServiceContract == null ) {
                        toServiceContract = new ServiceContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContract.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ServiceContractItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new ServiceContractItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceContractItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceContractItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceContractItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceContractItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingRequestItem != null ) {
            (values).put("to_BillingRequestItem", toBillingRequestItem);
        }
        if( toObjectList != null ) {
            (values).put("to_ObjectList", toObjectList);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toProductList != null ) {
            (values).put("to_ProductList", toProductList);
        }
        if( toReleasedOrder != null ) {
            (values).put("to_ReleasedOrder", toReleasedOrder);
        }
        if( toServiceContract != null ) {
            (values).put("to_ServiceContract", toServiceContract);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcContrItmBillgReqItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcContrItmBillgReqItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItmBillgReqItem> fetchBillingRequestItem()
    {
        return fetchFieldAsList("to_BillingRequestItem", SrvcContrItmBillgReqItem.class);
    }

    /**
     * Retrieval of associated <b>SrvcContrItmBillgReqItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>ServiceContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcContrItmBillgReqItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItmBillgReqItem> getBillingRequestItemOrFetch()
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = fetchBillingRequestItem();
        }
        return toBillingRequestItem;
    }

    /**
     * Retrieval of associated <b>SrvcContrItmBillgReqItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingRequestItem</b> is already loaded, the result
     *         will contain the <b>SrvcContrItmBillgReqItem</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcContrItmBillgReqItem>> getBillingRequestItemIfPresent()
    {
        return Option.of(toBillingRequestItem);
    }

    /**
     * Overwrites the list of associated <b>SrvcContrItmBillgReqItem</b> entities for the loaded navigation property
     * <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>ServiceContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcContrItmBillgReqItem</b> entities.
     */
    public void setBillingRequestItem( @Nonnull final List<SrvcContrItmBillgReqItem> value )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.clear();
        toBillingRequestItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcContrItmBillgReqItem</b> entities. This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>ServiceContractItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcContrItmBillgReqItem</b> entities.
     */
    public void addBillingRequestItem( SrvcContrItmBillgReqItem... entity )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContrItemObjectList</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ObjectList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContrItemObjectList</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItemObjectList> fetchObjectList()
    {
        return fetchFieldAsList("to_ObjectList", ServiceContrItemObjectList.class);
    }

    /**
     * Retrieval of associated <b>ServiceContrItemObjectList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContrItemObjectList</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItemObjectList> getObjectListOrFetch()
    {
        if( toObjectList == null ) {
            toObjectList = fetchObjectList();
        }
        return toObjectList;
    }

    /**
     * Retrieval of associated <b>ServiceContrItemObjectList</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ObjectList</b> is already loaded, the result will
     *         contain the <b>ServiceContrItemObjectList</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceContrItemObjectList>> getObjectListIfPresent()
    {
        return Option.of(toObjectList);
    }

    /**
     * Overwrites the list of associated <b>ServiceContrItemObjectList</b> entities for the loaded navigation property
     * <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContrItemObjectList</b> entities.
     */
    public void setObjectList( @Nonnull final List<ServiceContrItemObjectList> value )
    {
        if( toObjectList == null ) {
            toObjectList = Lists.newArrayList();
        }
        toObjectList.clear();
        toObjectList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContrItemObjectList</b> entities. This corresponds to the OData
     * navigation property <b>to_ObjectList</b>.
     * <p>
     * If the navigation property <b>to_ObjectList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContrItemObjectList</b> entities.
     */
    public void addObjectList( ServiceContrItemObjectList... entity )
    {
        if( toObjectList == null ) {
            toObjectList = Lists.newArrayList();
        }
        toObjectList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContrItemPriceElement</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContrItemPriceElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItemPriceElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", ServiceContrItemPriceElement.class);
    }

    /**
     * Retrieval of associated <b>ServiceContrItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContrItemPriceElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItemPriceElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>ServiceContrItemPriceElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>ServiceContrItemPriceElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceContrItemPriceElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>ServiceContrItemPriceElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContrItemPriceElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<ServiceContrItemPriceElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContrItemPriceElement</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>ServiceContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContrItemPriceElement</b> entities.
     */
    public void addPricingElement( ServiceContrItemPriceElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SrvcContrItemProduct</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProductList</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcContrItemProduct</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItemProduct> fetchProductList()
    {
        return fetchFieldAsList("to_ProductList", SrvcContrItemProduct.class);
    }

    /**
     * Retrieval of associated <b>SrvcContrItemProduct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcContrItemProduct</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItemProduct> getProductListOrFetch()
    {
        if( toProductList == null ) {
            toProductList = fetchProductList();
        }
        return toProductList;
    }

    /**
     * Retrieval of associated <b>SrvcContrItemProduct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductList</b> is already loaded, the result will
     *         contain the <b>SrvcContrItemProduct</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcContrItemProduct>> getProductListIfPresent()
    {
        return Option.of(toProductList);
    }

    /**
     * Overwrites the list of associated <b>SrvcContrItemProduct</b> entities for the loaded navigation property
     * <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcContrItemProduct</b> entities.
     */
    public void setProductList( @Nonnull final List<SrvcContrItemProduct> value )
    {
        if( toProductList == null ) {
            toProductList = Lists.newArrayList();
        }
        toProductList.clear();
        toProductList.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcContrItemProduct</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductList</b>.
     * <p>
     * If the navigation property <b>to_ProductList</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcContrItemProduct</b> entities.
     */
    public void addProductList( SrvcContrItemProduct... entity )
    {
        if( toProductList == null ) {
            toProductList = Lists.newArrayList();
        }
        toProductList.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContrItmReleasedOrder</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ReleasedOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContrItmReleasedOrder</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItmReleasedOrder> fetchReleasedOrder()
    {
        return fetchFieldAsList("to_ReleasedOrder", ServiceContrItmReleasedOrder.class);
    }

    /**
     * Retrieval of associated <b>ServiceContrItmReleasedOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReleasedOrder</b>.
     * <p>
     * If the navigation property <b>to_ReleasedOrder</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContrItmReleasedOrder</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContrItmReleasedOrder> getReleasedOrderOrFetch()
    {
        if( toReleasedOrder == null ) {
            toReleasedOrder = fetchReleasedOrder();
        }
        return toReleasedOrder;
    }

    /**
     * Retrieval of associated <b>ServiceContrItmReleasedOrder</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ReleasedOrder</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReleasedOrder</b> is already loaded, the result will
     *         contain the <b>ServiceContrItmReleasedOrder</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceContrItmReleasedOrder>> getReleasedOrderIfPresent()
    {
        return Option.of(toReleasedOrder);
    }

    /**
     * Overwrites the list of associated <b>ServiceContrItmReleasedOrder</b> entities for the loaded navigation property
     * <b>to_ReleasedOrder</b>.
     * <p>
     * If the navigation property <b>to_ReleasedOrder</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContrItmReleasedOrder</b> entities.
     */
    public void setReleasedOrder( @Nonnull final List<ServiceContrItmReleasedOrder> value )
    {
        if( toReleasedOrder == null ) {
            toReleasedOrder = Lists.newArrayList();
        }
        toReleasedOrder.clear();
        toReleasedOrder.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContrItmReleasedOrder</b> entities. This corresponds to the
     * OData navigation property <b>to_ReleasedOrder</b>.
     * <p>
     * If the navigation property <b>to_ReleasedOrder</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContrItmReleasedOrder</b> entities.
     */
    public void addReleasedOrder( ServiceContrItmReleasedOrder... entity )
    {
        if( toReleasedOrder == null ) {
            toReleasedOrder = Lists.newArrayList();
        }
        toReleasedOrder.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ServiceContract</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContract fetchServiceContract()
    {
        return fetchFieldAsSingle("to_ServiceContract", ServiceContract.class);
    }

    /**
     * Retrieval of associated <b>ServiceContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>ServiceContractItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContract getServiceContractOrFetch()
    {
        if( toServiceContract == null ) {
            toServiceContract = fetchServiceContract();
        }
        return toServiceContract;
    }

    /**
     * Retrieval of associated <b>ServiceContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContract</b> is already loaded, the result will
     *         contain the <b>ServiceContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceContract> getServiceContractIfPresent()
    {
        return Option.of(toServiceContract);
    }

    /**
     * Overwrites the associated <b>ServiceContract</b> entity for the loaded navigation property
     * <b>to_ServiceContract</b>.
     *
     * @param value
     *            New <b>ServiceContract</b> entity.
     */
    public void setServiceContract( final ServiceContract value )
    {
        toServiceContract = value;
    }

    /**
     * Fetches the <b>ServiceContractItemText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ServiceContractItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", ServiceContractItemText.class);
    }

    /**
     * Retrieval of associated <b>ServiceContractItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContractItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ServiceContractItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>ServiceContractItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>ServiceContractItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ServiceContractItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>ServiceContractItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ServiceContractItemText</b> entities.
     */
    public void setText( @Nonnull final List<ServiceContractItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ServiceContractItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>ServiceContractItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ServiceContractItemText</b> entities.
     */
    public void addText( ServiceContractItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ServiceContractItem instances.
     *
     */
    public final static class ServiceContractItemBuilder
    {

        private List<SrvcContrItmBillgReqItem> toBillingRequestItem = Lists.newArrayList();
        private List<ServiceContrItemObjectList> toObjectList = Lists.newArrayList();
        private List<ServiceContrItemPriceElement> toPricingElement = Lists.newArrayList();
        private List<SrvcContrItemProduct> toProductList = Lists.newArrayList();
        private List<ServiceContrItmReleasedOrder> toReleasedOrder = Lists.newArrayList();
        private ServiceContract toServiceContract;
        private String serviceContract = null;
        private List<ServiceContractItemText> toText = Lists.newArrayList();

        private ServiceContractItem.ServiceContractItemBuilder toBillingRequestItem(
            final List<SrvcContrItmBillgReqItem> value )
        {
            toBillingRequestItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillingRequestItem</b> for <b>ServiceContractItem</b> to multiple
         * <b>SrvcContrItmBillgReqItem</b>.
         *
         * @param value
         *            The SrvcContrItmBillgReqItems to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder billingRequestItem( SrvcContrItmBillgReqItem... value )
        {
            return toBillingRequestItem(Lists.newArrayList(value));
        }

        private ServiceContractItem.ServiceContractItemBuilder toObjectList(
            final List<ServiceContrItemObjectList> value )
        {
            toObjectList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ObjectList</b> for <b>ServiceContractItem</b> to multiple
         * <b>ServiceContrItemObjectList</b>.
         *
         * @param value
         *            The ServiceContrItemObjectLists to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder objectList( ServiceContrItemObjectList... value )
        {
            return toObjectList(Lists.newArrayList(value));
        }

        private ServiceContractItem.ServiceContractItemBuilder toPricingElement(
            final List<ServiceContrItemPriceElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>ServiceContractItem</b> to multiple
         * <b>ServiceContrItemPriceElement</b>.
         *
         * @param value
         *            The ServiceContrItemPriceElements to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder pricingElement( ServiceContrItemPriceElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private ServiceContractItem.ServiceContractItemBuilder toProductList( final List<SrvcContrItemProduct> value )
        {
            toProductList.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductList</b> for <b>ServiceContractItem</b> to multiple
         * <b>SrvcContrItemProduct</b>.
         *
         * @param value
         *            The SrvcContrItemProducts to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder productList( SrvcContrItemProduct... value )
        {
            return toProductList(Lists.newArrayList(value));
        }

        private ServiceContractItem.ServiceContractItemBuilder toReleasedOrder(
            final List<ServiceContrItmReleasedOrder> value )
        {
            toReleasedOrder.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ReleasedOrder</b> for <b>ServiceContractItem</b> to multiple
         * <b>ServiceContrItmReleasedOrder</b>.
         *
         * @param value
         *            The ServiceContrItmReleasedOrders to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder releasedOrder( ServiceContrItmReleasedOrder... value )
        {
            return toReleasedOrder(Lists.newArrayList(value));
        }

        private ServiceContractItem.ServiceContractItemBuilder toServiceContract( final ServiceContract value )
        {
            toServiceContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContract</b> for <b>ServiceContractItem</b> to single
         * <b>ServiceContract</b>.
         *
         * @param value
         *            The ServiceContract to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder serviceContract( final ServiceContract value )
        {
            return toServiceContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceContract</b>
         * </p>
         *
         * @param value
         *            The serviceContract to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder serviceContract( final String value )
        {
            serviceContract = value;
            return this;
        }

        private ServiceContractItem.ServiceContractItemBuilder toText( final List<ServiceContractItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>ServiceContractItem</b> to multiple <b>ServiceContractItemText</b>.
         *
         * @param value
         *            The ServiceContractItemTexts to build this ServiceContractItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractItem.ServiceContractItemBuilder text( ServiceContractItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
