/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.ServiceContractTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.ServiceContractTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.ServiceContractTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ServiceContractTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ServiceContractText extends VdmEntity<ServiceContractText>
{

    /**
     * Selector for all available fields of ServiceContractText.
     *
     */
    public final static ServiceContractTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static ServiceContractTextField<String> SERVICE_CONTRACT =
        new ServiceContractTextField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ServiceContractTextField<String> LANGUAGE = new ServiceContractTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static ServiceContractTextField<String> LONG_TEXT_ID =
        new ServiceContractTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static ServiceContractTextField<String> LONG_TEXT = new ServiceContractTextField<String>("LongText");
    /**
     * Navigation property <b>to_ServiceContract</b> for <b>ServiceContractText</b> to single <b>ServiceContract</b>.
     *
     */
    @SerializedName( "to_ServiceContract" )
    @JsonProperty( "to_ServiceContract" )
    @ODataField( odataName = "to_ServiceContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ServiceContract toServiceContract;
    /**
     * Use with available fluent helpers to apply the <b>to_ServiceContract</b> navigation property to query operations.
     *
     */
    public final static ServiceContractTextOneToOneLink<ServiceContract> TO_SERVICE_CONTRACT =
        new ServiceContractTextOneToOneLink<ServiceContract>("to_ServiceContract");

    @Nonnull
    @Override
    public Class<ServiceContractText> getType()
    {
        return ServiceContractText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ServiceContractText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ServiceContract") ) {
                final Object value = (values).remove("to_ServiceContract");
                if( value instanceof Map ) {
                    if( toServiceContract == null ) {
                        toServiceContract = new ServiceContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toServiceContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ServiceContractTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ServiceContractTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ServiceContractTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ServiceContractTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toServiceContract != null ) {
            (values).put("to_ServiceContract", toServiceContract);
        }
        return values;
    }

    /**
     * Fetches the <b>ServiceContract</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ServiceContract</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ServiceContract</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContract fetchServiceContract()
    {
        return fetchFieldAsSingle("to_ServiceContract", ServiceContract.class);
    }

    /**
     * Retrieval of associated <b>ServiceContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property <b>to_ServiceContract</b> of a queried <b>ServiceContractText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ServiceContract</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ServiceContract getServiceContractOrFetch()
    {
        if( toServiceContract == null ) {
            toServiceContract = fetchServiceContract();
        }
        return toServiceContract;
    }

    /**
     * Retrieval of associated <b>ServiceContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ServiceContract</b>.
     * <p>
     * If the navigation property for an entity <b>ServiceContractText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ServiceContract</b> is already loaded, the result will
     *         contain the <b>ServiceContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ServiceContract> getServiceContractIfPresent()
    {
        return Option.of(toServiceContract);
    }

    /**
     * Overwrites the associated <b>ServiceContract</b> entity for the loaded navigation property
     * <b>to_ServiceContract</b>.
     *
     * @param value
     *            New <b>ServiceContract</b> entity.
     */
    public void setServiceContract( final ServiceContract value )
    {
        toServiceContract = value;
    }

    /**
     * Helper class to allow for fluent creation of ServiceContractText instances.
     *
     */
    public final static class ServiceContractTextBuilder
    {

        private ServiceContract toServiceContract;
        private String serviceContract = null;

        private ServiceContractText.ServiceContractTextBuilder toServiceContract( final ServiceContract value )
        {
            toServiceContract = value;
            return this;
        }

        /**
         * Navigation property <b>to_ServiceContract</b> for <b>ServiceContractText</b> to single
         * <b>ServiceContract</b>.
         *
         * @param value
         *            The ServiceContract to build this ServiceContractText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractText.ServiceContractTextBuilder serviceContract( final ServiceContract value )
        {
            return toServiceContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ServiceContract</b>
         * </p>
         *
         * @param value
         *            The serviceContract to build this ServiceContractText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ServiceContractText.ServiceContractTextBuilder serviceContract( final String value )
        {
            serviceContract = value;
            return this;
        }

    }

}
