/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.field.SrvcContrBillgReqItmPrcElmntField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.link.SrvcContrBillgReqItmPrcElmntLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.servicecontract.selectable.SrvcContrBillgReqItmPrcElmntSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * BRL Price Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SrvcContrBillgReqItmPrcElmntType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SrvcContrBillgReqItmPrcElmnt extends VdmEntity<SrvcContrBillgReqItmPrcElmnt>
{

    /**
     * Selector for all available fields of SrvcContrBillgReqItmPrcElmnt.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @return Transaction ID
     */
    @Key
    @SerializedName( "ServiceContract" )
    @JsonProperty( "ServiceContract" )
    @Nullable
    @ODataField( odataName = "ServiceContract" )
    private String serviceContract;
    /**
     * Use with available fluent helpers to apply the <b>ServiceContract</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> SERVICE_CONTRACT =
        new SrvcContrBillgReqItmPrcElmntField<String>("ServiceContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @return Shortened Item Number in Document
     */
    @Key
    @SerializedName( "BillingRequestItem" )
    @JsonProperty( "BillingRequestItem" )
    @Nullable
    @ODataField( odataName = "BillingRequestItem" )
    private String billingRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingRequestItem</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> BILLING_REQUEST_ITEM =
        new SrvcContrBillgReqItmPrcElmntField<String>("BillingRequestItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> PRICING_PROCEDURE_STEP =
        new SrvcContrBillgReqItmPrcElmntField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> PRICING_PROCEDURE_COUNTER =
        new SrvcContrBillgReqItmPrcElmntField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> CONDITION_TYPE =
        new SrvcContrBillgReqItmPrcElmntField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @return Condition Amount or Percentage
     */
    @SerializedName( "ConditionRateValue" )
    @JsonProperty( "ConditionRateValue" )
    @Nullable
    @ODataField( odataName = "ConditionRateValue" )
    private BigDecimal conditionRateValue;
    /**
     * Use with available fluent helpers to apply the <b>ConditionRateValue</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<BigDecimal> CONDITION_RATE_VALUE =
        new SrvcContrBillgReqItmPrcElmntField<BigDecimal>("ConditionRateValue");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "ConditionCurrency" )
    @JsonProperty( "ConditionCurrency" )
    @Nullable
    @ODataField( odataName = "ConditionCurrency" )
    private String conditionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>ConditionCurrency</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> CONDITION_CURRENCY =
        new SrvcContrBillgReqItmPrcElmntField<String>("ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @return Condition Pricing Unit
     */
    @SerializedName( "ConditionQuantity" )
    @JsonProperty( "ConditionQuantity" )
    @Nullable
    @ODataField( odataName = "ConditionQuantity" )
    private BigDecimal conditionQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantity</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<BigDecimal> CONDITION_QUANTITY =
        new SrvcContrBillgReqItmPrcElmntField<BigDecimal>("ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @return Condition Unit in the Document
     */
    @SerializedName( "ConditionQuantityUnit" )
    @JsonProperty( "ConditionQuantityUnit" )
    @Nullable
    @ODataField( odataName = "ConditionQuantityUnit" )
    private String conditionQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConditionQuantityUnit</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> CONDITION_QUANTITY_UNIT =
        new SrvcContrBillgReqItmPrcElmntField<String>("ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @return Condition is Inactive
     */
    @SerializedName( "ConditionInactiveReason" )
    @JsonProperty( "ConditionInactiveReason" )
    @Nullable
    @ODataField( odataName = "ConditionInactiveReason" )
    private String conditionInactiveReason;
    /**
     * Use with available fluent helpers to apply the <b>ConditionInactiveReason</b> field to query operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntField<String> CONDITION_INACTIVE_REASON =
        new SrvcContrBillgReqItmPrcElmntField<String>("ConditionInactiveReason");
    /**
     * Navigation property <b>to_BillingRequestItem</b> for <b>SrvcContrBillgReqItmPrcElmnt</b> to multiple
     * <b>SrvcContrItmBillgReqItem</b>.
     *
     */
    @SerializedName( "to_BillingRequestItem" )
    @JsonProperty( "to_BillingRequestItem" )
    @ODataField( odataName = "to_BillingRequestItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SrvcContrItmBillgReqItem> toBillingRequestItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingRequestItem</b> navigation property to query
     * operations.
     *
     */
    public final static SrvcContrBillgReqItmPrcElmntLink<SrvcContrItmBillgReqItem> TO_BILLING_REQUEST_ITEM =
        new SrvcContrBillgReqItmPrcElmntLink<SrvcContrItmBillgReqItem>("to_BillingRequestItem");

    @Nonnull
    @Override
    public Class<SrvcContrBillgReqItmPrcElmnt> getType()
    {
        return SrvcContrBillgReqItmPrcElmnt.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceContract</b>
     * </p>
     *
     * @param serviceContract
     *            Transaction ID
     */
    public void setServiceContract( @Nullable final String serviceContract )
    {
        rememberChangedField("ServiceContract", this.serviceContract);
        this.serviceContract = serviceContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingRequestItem</b>
     * </p>
     *
     * @param billingRequestItem
     *            Shortened Item Number in Document
     */
    public void setBillingRequestItem( @Nullable final String billingRequestItem )
    {
        rememberChangedField("BillingRequestItem", this.billingRequestItem);
        this.billingRequestItem = billingRequestItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateValue</b>
     * </p>
     *
     * @param conditionRateValue
     *            Condition Amount or Percentage
     */
    public void setConditionRateValue( @Nullable final BigDecimal conditionRateValue )
    {
        rememberChangedField("ConditionRateValue", this.conditionRateValue);
        this.conditionRateValue = conditionRateValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     *
     * @param conditionCurrency
     *            Currency Key
     */
    public void setConditionCurrency( @Nullable final String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     *
     * @param conditionQuantity
     *            Condition Pricing Unit
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     *
     * @param conditionQuantityUnit
     *            Condition Unit in the Document
     */
    public void setConditionQuantityUnit( @Nullable final String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionInactiveReason</b>
     * </p>
     *
     * @param conditionInactiveReason
     *            Condition is Inactive
     */
    public void setConditionInactiveReason( @Nullable final String conditionInactiveReason )
    {
        rememberChangedField("ConditionInactiveReason", this.conditionInactiveReason);
        this.conditionInactiveReason = conditionInactiveReason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SrvcContrBillgReqItmPrcElmnt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ServiceContract", getServiceContract());
        result.put("BillingRequestItem", getBillingRequestItem());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ServiceContract", getServiceContract());
        values.put("BillingRequestItem", getBillingRequestItem());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionType", getConditionType());
        values.put("ConditionRateValue", getConditionRateValue());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionInactiveReason", getConditionInactiveReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ServiceContract") ) {
                final Object value = values.remove("ServiceContract");
                if( (value == null) || (!value.equals(getServiceContract())) ) {
                    setServiceContract(((String) value));
                }
            }
            if( values.containsKey("BillingRequestItem") ) {
                final Object value = values.remove("BillingRequestItem");
                if( (value == null) || (!value.equals(getBillingRequestItem())) ) {
                    setBillingRequestItem(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionRateValue") ) {
                final Object value = values.remove("ConditionRateValue");
                if( (value == null) || (!value.equals(getConditionRateValue())) ) {
                    setConditionRateValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConditionInactiveReason") ) {
                final Object value = values.remove("ConditionInactiveReason");
                if( (value == null) || (!value.equals(getConditionInactiveReason())) ) {
                    setConditionInactiveReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingRequestItem") ) {
                final Object value = (values).remove("to_BillingRequestItem");
                if( value instanceof Iterable ) {
                    if( toBillingRequestItem == null ) {
                        toBillingRequestItem = Lists.newArrayList();
                    } else {
                        toBillingRequestItem = Lists.newArrayList(toBillingRequestItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SrvcContrItmBillgReqItem entity;
                        if( toBillingRequestItem.size() > i ) {
                            entity = toBillingRequestItem.get(i);
                        } else {
                            entity = new SrvcContrItmBillgReqItem();
                            toBillingRequestItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SrvcContrBillgReqItmPrcElmntField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SrvcContrBillgReqItmPrcElmntField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SrvcContrBillgReqItmPrcElmntField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SrvcContrBillgReqItmPrcElmntField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ServiceContractService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingRequestItem != null ) {
            (values).put("to_BillingRequestItem", toBillingRequestItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SrvcContrItmBillgReqItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SrvcContrItmBillgReqItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItmBillgReqItem> fetchBillingRequestItem()
    {
        return fetchFieldAsList("to_BillingRequestItem", SrvcContrItmBillgReqItem.class);
    }

    /**
     * Retrieval of associated <b>SrvcContrItmBillgReqItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>SrvcContrBillgReqItmPrcElmnt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SrvcContrItmBillgReqItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SrvcContrItmBillgReqItem> getBillingRequestItemOrFetch()
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = fetchBillingRequestItem();
        }
        return toBillingRequestItem;
    }

    /**
     * Retrieval of associated <b>SrvcContrItmBillgReqItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property for an entity <b>SrvcContrBillgReqItmPrcElmnt</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingRequestItem</b> is already loaded, the result
     *         will contain the <b>SrvcContrItmBillgReqItem</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SrvcContrItmBillgReqItem>> getBillingRequestItemIfPresent()
    {
        return Option.of(toBillingRequestItem);
    }

    /**
     * Overwrites the list of associated <b>SrvcContrItmBillgReqItem</b> entities for the loaded navigation property
     * <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>SrvcContrBillgReqItmPrcElmnt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SrvcContrItmBillgReqItem</b> entities.
     */
    public void setBillingRequestItem( @Nonnull final List<SrvcContrItmBillgReqItem> value )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.clear();
        toBillingRequestItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SrvcContrItmBillgReqItem</b> entities. This corresponds to the OData
     * navigation property <b>to_BillingRequestItem</b>.
     * <p>
     * If the navigation property <b>to_BillingRequestItem</b> of a queried <b>SrvcContrBillgReqItmPrcElmnt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SrvcContrItmBillgReqItem</b> entities.
     */
    public void addBillingRequestItem( SrvcContrItmBillgReqItem... entity )
    {
        if( toBillingRequestItem == null ) {
            toBillingRequestItem = Lists.newArrayList();
        }
        toBillingRequestItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SrvcContrBillgReqItmPrcElmnt instances.
     *
     */
    public final static class SrvcContrBillgReqItmPrcElmntBuilder
    {

        private List<SrvcContrItmBillgReqItem> toBillingRequestItem = Lists.newArrayList();
        private String billingRequestItem = null;

        private SrvcContrBillgReqItmPrcElmnt.SrvcContrBillgReqItmPrcElmntBuilder toBillingRequestItem(
            final List<SrvcContrItmBillgReqItem> value )
        {
            toBillingRequestItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillingRequestItem</b> for <b>SrvcContrBillgReqItmPrcElmnt</b> to multiple
         * <b>SrvcContrItmBillgReqItem</b>.
         *
         * @param value
         *            The SrvcContrItmBillgReqItems to build this SrvcContrBillgReqItmPrcElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrBillgReqItmPrcElmnt.SrvcContrBillgReqItmPrcElmntBuilder billingRequestItem(
            SrvcContrItmBillgReqItem... value )
        {
            return toBillingRequestItem(Lists.newArrayList(value));
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>BillingRequestItem</b>
         * </p>
         *
         * @param value
         *            The billingRequestItem to build this SrvcContrBillgReqItmPrcElmnt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SrvcContrBillgReqItmPrcElmnt.SrvcContrBillgReqItmPrcElmntBuilder billingRequestItem( final String value )
        {
            billingRequestItem = value;
            return this;
        }

    }

}
